/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionFunction;
import smallsql.database.MutableNumeric;
import smallsql.database.Utils;

public class ExpressionFunctionTimestampDiff
extends ExpressionFunction {
    private final int interval;

    static final int mapIntervalType(int n) {
        switch (n) {
            case 1209: {
                return 1250;
            }
            case 1215: {
                return 1251;
            }
            case 1210: {
                return 1252;
            }
            case 1208: {
                return 1253;
            }
            case 400: 
            case 1207: {
                return 1254;
            }
            case 1218: {
                return 1255;
            }
            case 1211: {
                return 1256;
            }
            case 1214: {
                return 1257;
            }
            case 1219: {
                return 1258;
            }
        }
        return n;
    }

    ExpressionFunctionTimestampDiff(int n, Expression expression, Expression expression2) {
        this.interval = ExpressionFunctionTimestampDiff.mapIntervalType(n);
        this.setParams(new Expression[]{expression, expression2});
    }

    int getFunction() {
        return 1217;
    }

    boolean isNull() throws Exception {
        return this.param1.isNull() || this.param2.isNull();
    }

    boolean getBoolean() throws Exception {
        return this.getInt() != 0;
    }

    int getInt() throws Exception {
        if (this.isNull()) {
            return 0;
        }
        switch (this.interval) {
            case 1250: {
                return (int)(this.param2.getLong() - this.param1.getLong());
            }
            case 1251: {
                return (int)(this.param2.getLong() / 1000L - this.param1.getLong() / 1000L);
            }
            case 1252: {
                return (int)(this.param2.getLong() / 60000L - this.param1.getLong() / 60000L);
            }
            case 1253: {
                return (int)(this.param2.getLong() / 3600000L - this.param1.getLong() / 3600000L);
            }
            case 1254: {
                return (int)(this.param2.getLong() / 86400000L - this.param1.getLong() / 86400000L);
            }
            case 1255: {
                long l = this.param2.getLong() / 86400000L;
                long l2 = this.param1.getLong() / 86400000L;
                return (int)((l + 3L) / 7L - (l2 + 3L) / 7L);
            }
            case 1256: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                DateTime.Details details2 = new DateTime.Details(this.param1.getLong());
                return details.year * 12 + details.month - (details2.year * 12 + details2.month);
            }
            case 1257: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                DateTime.Details details3 = new DateTime.Details(this.param1.getLong());
                return details.year * 4 + details.month / 3 - (details3.year * 4 + details3.month / 3);
            }
            case 1258: {
                DateTime.Details details = new DateTime.Details(this.param2.getLong());
                DateTime.Details details4 = new DateTime.Details(this.param1.getLong());
                return details.year - details4.year;
            }
        }
        throw new Error();
    }

    long getLong() throws Exception {
        return this.getInt();
    }

    float getFloat() throws Exception {
        return this.getInt();
    }

    double getDouble() throws Exception {
        return this.getInt();
    }

    long getMoney() throws Exception {
        return (long)this.getInt() * 10000L;
    }

    MutableNumeric getNumeric() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return new MutableNumeric(this.getInt());
    }

    Object getObject() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return Utils.getInteger(this.getInt());
    }

    String getString() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getInt());
    }

    int getDataType() {
        return 323;
    }
}

