/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expressions;
import smallsql.database.Index;
import smallsql.database.RowSource;

final class Distinct
extends RowSource {
    private final Expressions distinctColumns;
    private final RowSource rowSource;
    private Index index;
    private int row;

    Distinct(RowSource rowSource, Expressions expressions) {
        this.rowSource = rowSource;
        this.distinctColumns = expressions;
    }

    final void execute() throws Exception {
        this.rowSource.execute();
        this.index = new Index(true);
    }

    final boolean isScrollable() {
        return false;
    }

    final void beforeFirst() throws Exception {
        this.rowSource.beforeFirst();
        this.row = 0;
    }

    final boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    final boolean next() throws Exception {
        long l;
        Long l2;
        do {
            boolean bl;
            if (!(bl = this.rowSource.next())) {
                return false;
            }
            l2 = (Long)this.index.findRows(this.distinctColumns, true, null);
            l = this.rowSource.getRowPosition();
            if (l2 != null) continue;
            this.index.addValues(l, this.distinctColumns);
            ++this.row;
            return true;
        } while (l2 != l);
        ++this.row;
        return true;
    }

    final void afterLast() throws Exception {
        this.rowSource.afterLast();
        this.row = 0;
    }

    final int getRow() throws Exception {
        return this.row;
    }

    final long getRowPosition() {
        return this.rowSource.getRowPosition();
    }

    final void setRowPosition(long l) throws Exception {
        this.rowSource.setRowPosition(l);
    }

    final void nullRow() {
        this.rowSource.nullRow();
        this.row = 0;
    }

    final void noRow() {
        this.rowSource.noRow();
        this.row = 0;
    }

    final boolean rowInserted() {
        return this.rowSource.rowInserted();
    }

    final boolean rowDeleted() {
        return this.rowSource.rowDeleted();
    }

    boolean isExpressionsFromThisRowSource(Expressions expressions) {
        return this.rowSource.isExpressionsFromThisRowSource(expressions);
    }
}

