/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import smallsql.database.Mutable;
import smallsql.database.SmallSQLException;
import smallsql.database.Utils;

public final class DateTime
implements Mutable {
    long time;
    private int dataType = 342;
    static final int[] MONTH_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final String[] SHORT_MONTHS = new DateFormatSymbols().getShortMonths();
    private static final Calendar cal = Calendar.getInstance();

    DateTime(long l, int n) {
        switch (n) {
            case 343: {
                int n2 = (int)(l % 60000L);
                if (n2 < 0) {
                    n2 += 60000;
                }
                l -= (long)n2;
                break;
            }
            case 341: {
                l %= 86400000L;
                break;
            }
            case 340: {
                int n3 = (int)(l % 86400000L);
                if (n3 < 0) {
                    n3 += 86400000;
                }
                l -= (long)n3;
            }
        }
        this.time = l;
        this.dataType = n;
    }

    static long calcMillis(Details details) {
        return DateTime.calcMillis(details.year, details.month, details.day, details.hour, details.minute, details.second, details.millis);
    }

    static long calcMillis(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        long l = n7;
        l += (long)(n6 * 1000);
        l += (long)(n5 * 60000);
        l += (long)(n4 * 3600000);
        l += (long)(n3 - 1) * 86400000L;
        if (n2 > 11) {
            n += n2 / 12;
            n2 %= 12;
        }
        l += (long)MONTH_DAYS[n2] * 86400000L;
        l += (long)(n - 1970) * 31536000000L;
        l += (long)(n / 4 - n / 100 + n / 400 - 477) * 86400000L;
        if (n2 < 2 && n % 4 == 0 && (n % 100 != 0 || n % 400 == 0)) {
            l -= 86400000L;
        }
        return l;
    }

    static long now() {
        return DateTime.removeDateTimeOffset(System.currentTimeMillis());
    }

    static int dayOfWeek(long l) {
        return (int)((l / 86400000L + 3L) % 7L);
    }

    static long parse(Date date) {
        long l = date.getTime();
        return DateTime.removeDateTimeOffset(l);
    }

    static DateTime valueOf(Date date) {
        if (date == null) {
            return null;
        }
        int n = date instanceof java.sql.Date ? 340 : (date instanceof Time ? 341 : 342);
        return new DateTime(DateTime.parse(date), n);
    }

    static DateTime valueOf(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return new DateTime(DateTime.parse(date), 340);
    }

    static DateTime valueOf(Time time) {
        if (time == null) {
            return null;
        }
        return new DateTime(DateTime.parse(time), 341);
    }

    static DateTime valueOf(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new DateTime(DateTime.parse(timestamp), 342);
    }

    static DateTime valueOf(String string, int n) throws SQLException {
        if (string == null) {
            return null;
        }
        return new DateTime(DateTime.parse(string), n);
    }

    static long parse(String string) throws SQLException {
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = string.length();
            int n9 = 0;
            int n10 = string.indexOf(45);
            if (n10 > 0) {
                n7 = Integer.parseInt(string.substring(n9, n10).trim());
                n9 = n10 + 1;
                n10 = string.indexOf(45, n9);
                n6 = Integer.parseInt(string.substring(n9, n10).trim()) - 1;
                n9 = n10 + 1;
                if ((n10 = string.indexOf(32, n9)) < 0) {
                    n10 = string.length();
                }
                n5 = Integer.parseInt(string.substring(n9, n10).trim());
            } else {
                n7 = 1970;
                n6 = 0;
                n5 = 1;
            }
            n9 = n10 + 1;
            n10 = string.indexOf(58, n9);
            if (n10 > 0) {
                n4 = Integer.parseInt(string.substring(n9, n10).trim());
                n9 = n10 + 1;
                n10 = string.indexOf(58, n9);
                n3 = Integer.parseInt(string.substring(n9, n10).trim());
                n9 = n10 + 1;
                if ((n10 = string.indexOf(46, n9)) < 0) {
                    n10 = string.length();
                }
                n2 = Integer.parseInt(string.substring(n9, n10).trim());
                n9 = n10 + 1;
                if (n9 < n8) {
                    String string2 = string.substring(n9).trim();
                    switch (string2.length()) {
                        case 1: {
                            n = Integer.parseInt(string2) * 100;
                            break;
                        }
                        case 2: {
                            n = Integer.parseInt(string2) * 10;
                            break;
                        }
                        case 3: {
                            n = Integer.parseInt(string2);
                            break;
                        }
                        default: {
                            n = Integer.parseInt(string2.substring(0, 3));
                            break;
                        }
                    }
                } else {
                    n = 0;
                }
            } else {
                n4 = 0;
                n3 = 0;
                n2 = 0;
                n = 0;
            }
            if (n9 == 0 && n8 > 0) {
                throw SmallSQLException.create("SS-0257");
            }
            if (n6 >= 12) {
                throw SmallSQLException.create("SS-0251", string);
            }
            if (n5 >= 32) {
                throw SmallSQLException.create("SS-0252", string);
            }
            if (n5 == 31) {
                switch (n6) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 10: {
                        throw SmallSQLException.create("SS-0252", string);
                    }
                }
            }
            if (n6 == 1) {
                if (n5 == 30) {
                    throw SmallSQLException.create("SS-0252", string);
                }
                if (n5 == 29 && !DateTime.isLeapYear(n7)) {
                    throw SmallSQLException.create("SS-0252", string);
                }
            }
            if (n4 >= 24) {
                throw SmallSQLException.create("SS-0253", string);
            }
            if (n3 >= 60) {
                throw SmallSQLException.create("SS-0254", string);
            }
            if (n2 >= 60) {
                throw SmallSQLException.create("SS-0255", string);
            }
            if (n >= 1000) {
                throw SmallSQLException.create("SS-0256", string);
            }
            return DateTime.calcMillis(n7, n6, n5, n4, n3, n2, n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw SmallSQLException.createFromException("SS-0257", string, throwable);
        }
    }

    long getTimeMillis() {
        return this.time;
    }

    int getDataType() {
        return this.dataType;
    }

    public String toString() {
        Details details = new Details(this.time);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dataType != 341) {
            DateTime.formatNumber(details.year, 4, stringBuffer);
            stringBuffer.append('-');
            DateTime.formatNumber(details.month + 1, 2, stringBuffer);
            stringBuffer.append('-');
            DateTime.formatNumber(details.day, 2, stringBuffer);
        }
        if (this.dataType != 340) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            DateTime.formatNumber(details.hour, 2, stringBuffer);
            stringBuffer.append(':');
            DateTime.formatNumber(details.minute, 2, stringBuffer);
            stringBuffer.append(':');
            DateTime.formatNumber(details.second, 2, stringBuffer);
        }
        switch (this.dataType) {
            case 342: 
            case 343: {
                stringBuffer.append('.');
                DateTime.formatMillis(details.millis, stringBuffer);
            }
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateTime)) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        return dateTime.time == this.time && dateTime.dataType == this.dataType;
    }

    String toString(int n) {
        if (n < 0) {
            return this.toString();
        }
        Details details = new Details(this.time);
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 0: 
            case 100: {
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatHour12(details.hour, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(details.hour < 12 ? "AM" : "PM");
                return stringBuffer.toString();
            }
            case 1: {
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 101: {
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 2: {
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 102: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 3: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 103: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 4: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 104: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 5: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 105: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 6: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 106: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 7: {
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(',');
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 107: {
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(',');
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 8: 
            case 108: {
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 9: 
            case 109: {
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatHour12(details.hour, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatMillis(details.millis, stringBuffer);
                stringBuffer.append(details.hour < 12 ? "AM" : "PM");
                return stringBuffer.toString();
            }
            case 10: {
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 110: {
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                return stringBuffer.toString();
            }
            case 11: {
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 111: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 12: {
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 112: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                DateTime.formatNumber(details.day, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 13: 
            case 113: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatMillis(details.millis, stringBuffer);
                return stringBuffer.toString();
            }
            case 14: 
            case 114: {
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatMillis(details.millis, stringBuffer);
                return stringBuffer.toString();
            }
            case 20: 
            case 120: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                return stringBuffer.toString();
            }
            case 21: 
            case 121: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatMillis(details.millis, stringBuffer);
                return stringBuffer.toString();
            }
            case 26: 
            case 126: {
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('-');
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('T');
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append('.');
                DateTime.formatMillis(details.millis, stringBuffer);
                return stringBuffer.toString();
            }
            case 130: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append(' ');
                stringBuffer.append(SHORT_MONTHS[details.month]);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.year, 4, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatHour12(details.hour, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatMillis(details.millis, stringBuffer);
                stringBuffer.append(details.hour < 12 ? "AM" : "PM");
                return stringBuffer.toString();
            }
            case 131: {
                DateTime.formatNumber(details.day, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.month + 1, 2, stringBuffer);
                stringBuffer.append('/');
                DateTime.formatNumber(details.year % 100, 2, stringBuffer);
                stringBuffer.append(' ');
                DateTime.formatNumber(details.hour, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.minute, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatNumber(details.second, 2, stringBuffer);
                stringBuffer.append(':');
                DateTime.formatMillis(details.millis, stringBuffer);
                return stringBuffer.toString();
            }
        }
        return this.toString();
    }

    private static final void formatNumber(int n, int n2, StringBuffer stringBuffer) {
        stringBuffer.setLength(stringBuffer.length() + n2);
        if (n < 0) {
            n = -n;
        }
        for (int i = 1; i <= n2; ++i) {
            stringBuffer.setCharAt(stringBuffer.length() - i, Utils.digits[n % 10]);
            n /= 10;
        }
    }

    private static final void formatMillis(int n, StringBuffer stringBuffer) {
        stringBuffer.append(Utils.digits[n / 100 % 10]);
        int n2 = n % 100;
        if (n2 != 0) {
            stringBuffer.append(Utils.digits[n2 / 10]);
            if ((n2 %= 10) != 0) {
                stringBuffer.append(Utils.digits[n2]);
            }
        }
    }

    private static final void formatHour12(int n, StringBuffer stringBuffer) {
        if ((n %= 12) == 0) {
            n = 12;
        }
        DateTime.formatNumber(n, 2, stringBuffer);
    }

    private static final long addDateTimeOffset(long l) {
        return DateTime.addDateTimeOffset(l, TimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final long addDateTimeOffset(long l, TimeZone timeZone) {
        int n = (int)(l % 86400000L);
        int n2 = (int)(l / 86400000L);
        if (n < 0) {
            n += 86400000;
            --n2;
        }
        int n3 = n % 1000;
        n /= 1000;
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTimeZone(timeZone);
            cal.set(1970, 0, n2 + 1, 0, 0, n);
            cal.set(14, n3);
            return cal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long removeDateTimeOffset(long l) {
        Calendar calendar = cal;
        synchronized (calendar) {
            cal.setTimeZone(TimeZone.getDefault());
            cal.setTimeInMillis(l);
            return l + (long)cal.get(15) + (long)cal.get(16);
        }
    }

    static Timestamp getTimestamp(long l) {
        return new Timestamp(DateTime.addDateTimeOffset(l));
    }

    static Time getTime(long l) {
        return new Time(DateTime.addDateTimeOffset(l));
    }

    static java.sql.Date getDate(long l) {
        return new java.sql.Date(DateTime.addDateTimeOffset(l));
    }

    public Object getImmutableObject() {
        switch (this.dataType) {
            case 340: {
                return DateTime.getDate(this.time);
            }
            case 341: {
                return DateTime.getTime(this.time);
            }
        }
        return DateTime.getTimestamp(this.time);
    }

    static boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    static class Details {
        int year;
        int month;
        int dayofyear;
        int day;
        int hour;
        int minute;
        int second;
        int millis;

        Details(long l) {
            boolean bl;
            int n = (int)(l % 86400000L);
            int n2 = (int)(l / 86400000L);
            if (n < 0) {
                n += 86400000;
                --n2;
            }
            this.millis = n % 1000;
            this.second = (n /= 1000) % 60;
            this.minute = (n /= 60) % 60;
            this.hour = (n /= 60) % 24;
            this.year = 1970 - (int)((double)n / 365.2425);
            while (true) {
                bl = false;
                this.dayofyear = this.day = n2 - ((this.year - 1970) * 365 + this.year / 4 - this.year / 100 + this.year / 400 - 477);
                if (DateTime.isLeapYear(this.year)) {
                    if (this.day < 59) {
                        ++this.day;
                        bl = true;
                    }
                    ++this.dayofyear;
                }
                if (this.day < 0) {
                    --this.year;
                    continue;
                }
                if (this.day < 365) break;
                ++this.year;
            }
            if (bl && this.day == 59) {
                this.month = 1;
                this.day = 29;
            } else {
                for (int i = 11; i >= 0; --i) {
                    if (MONTH_DAYS[i] > this.day) continue;
                    this.month = i;
                    this.day = this.day - MONTH_DAYS[i] + 1;
                    break;
                }
            }
        }
    }
}

