/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.DriverManager;
import java.sql.SQLException;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.CreateFile;
import smallsql.database.Database;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.Table;
import smallsql.database.Utils;
import smallsql.database.View;

abstract class TableView {
    static final int MAGIC_TABLE = 1397836884;
    static final int MAGIC_VIEW = 1397836886;
    static final int TABLE_VIEW_VERSION = 2;
    static final int TABLE_VIEW_OLD_VERSION = 1;
    final String name;
    final Columns columns;
    private long timestamp = System.currentTimeMillis();
    static final int LOCK_NONE = 0;
    static final int LOCK_INSERT = 1;
    static final int LOCK_READ = 2;
    static final int LOCK_WRITE = 3;
    static final int LOCK_TAB = 4;

    TableView(String string, Columns columns) {
        this.name = string;
        this.columns = columns;
    }

    static TableView load(SSConnection sSConnection, Database database, String string) throws SQLException {
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            String string2 = Utils.createTableViewFileName(database, string);
            File file = new File(string2);
            if (!file.exists()) {
                throw SmallSQLException.create("SS-0196", string);
            }
            abstractInterruptibleChannel = Utils.openRaFile(file, database.isReadOnly());
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            ((FileChannel)abstractInterruptibleChannel).read(byteBuffer);
            byteBuffer.position(0);
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            switch (n) {
                case 1397836884: 
                case 1397836886: {
                    break;
                }
                default: {
                    throw SmallSQLException.create("SS-0198", string2);
                }
            }
            if (n2 > 2) {
                throw SmallSQLException.create("SS-0490", new Object[]{new Integer(n2), string2});
            }
            if (n2 < 1) {
                throw SmallSQLException.create("SS-0491", new Object[]{new Integer(n2), string2});
            }
            if (n == 1397836884) {
                return new Table(database, sSConnection, string, (FileChannel)abstractInterruptibleChannel, ((FileChannel)abstractInterruptibleChannel).position(), n2);
            }
            return new View(sSConnection, string, (FileChannel)abstractInterruptibleChannel, ((FileChannel)abstractInterruptibleChannel).position());
        }
        catch (Throwable throwable) {
            if (abstractInterruptibleChannel != null) {
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Exception exception) {
                    DriverManager.println(exception.toString());
                }
            }
            throw SmallSQLException.createFromException(throwable);
        }
    }

    File getFile(Database database) {
        return new File(Utils.createTableViewFileName(database, this.name));
    }

    FileChannel createFile(SSConnection sSConnection, Database database) throws Exception {
        if (database.isReadOnly()) {
            throw SmallSQLException.create("SS-0034");
        }
        File file = this.getFile(database);
        boolean bl = file.createNewFile();
        if (!bl) {
            throw SmallSQLException.create("SS-0199", this.name);
        }
        FileChannel fileChannel = Utils.openRaFile(file, database.isReadOnly());
        sSConnection.add(new CreateFile(file, fileChannel, sSConnection, database));
        this.writeMagic(fileChannel);
        return fileChannel;
    }

    abstract void writeMagic(FileChannel var1) throws Exception;

    String getName() {
        return this.name;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    final int findColumnIdx(String string) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    final Column findColumn(String string) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Column column = this.columns.get(i);
            if (!column.getName().equalsIgnoreCase(string)) continue;
            return column;
        }
        return null;
    }

    void close() throws Exception {
    }
}

