/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import smallsql.database.language.Language;

class SmallSQLException
extends SQLException {
    private static final long serialVersionUID = -1683756623665114L;
    private boolean isInit;
    private static Language language;

    private SmallSQLException(String string, String string2) {
        super("[SmallSQL]" + string, string2, 0);
        this.init();
    }

    private SmallSQLException(Throwable throwable, String string, String string2) {
        super("[SmallSQL]" + string, string2, 0);
        this.initCause(throwable);
        this.init();
    }

    private void init() {
        this.isInit = true;
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter != null) {
            this.printStackTrace(printWriter);
        }
    }

    static void setLanguage(Object object) throws SQLException {
        if (language != null && object == null) {
            return;
        }
        language = object == null ? Language.getDefaultLanguage() : Language.getLanguage(object.toString());
    }

    public void printStackTrace() {
        if (!this.isInit) {
            return;
        }
        super.printStackTrace();
    }

    public void printStackTrace(PrintStream printStream) {
        if (!this.isInit) {
            return;
        }
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (!this.isInit) {
            return;
        }
        super.printStackTrace(printWriter);
    }

    static SQLException create(String string) {
        assert (string != null) : "Fill parameters";
        String string2 = SmallSQLException.translateMsg(string, null);
        String string3 = language.getSqlState(string);
        return new SmallSQLException(string2, string3);
    }

    static SQLException create(String string, Object object) {
        String string2 = SmallSQLException.translateMsg(string, new Object[]{object});
        String string3 = language.getSqlState(string);
        return new SmallSQLException(string2, string3);
    }

    static SQLException create(String string, Object[] objectArray) {
        String string2 = SmallSQLException.translateMsg(string, objectArray);
        String string3 = language.getSqlState(string);
        return new SmallSQLException(string2, string3);
    }

    static SQLException createFromException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        String string = SmallSQLException.stripMsg(throwable);
        String string2 = language.getSqlState("SS-0000");
        return new SmallSQLException(throwable, string, string2);
    }

    static SQLException createFromException(String string, Object object, Throwable throwable) {
        String string2 = SmallSQLException.translateMsg(string, new Object[]{object});
        String string3 = language.getSqlState(string);
        return new SmallSQLException(throwable, string2, string3);
    }

    static String translateMsg(String string, Object[] objectArray) {
        assert (string != null && objectArray != null) : "Fill parameters. msgCode=" + string + " params=" + objectArray;
        String string2 = language.getMessage(string);
        return MessageFormat.format(string2, objectArray);
    }

    private static String stripMsg(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null || string.length() < 30) {
            String string2 = throwable.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
            if (string != null) {
                string2 = string2 + ':' + string;
            }
            return string2;
        }
        return throwable.getMessage();
    }
}

