/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import smallsql.database.Column;
import smallsql.database.Columns;
import smallsql.database.DataSource;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.MutableNumeric;
import smallsql.database.SmallSQLException;
import smallsql.database.TableView;

class MemoryResult
extends DataSource {
    ExpressionValue[] currentRow;
    private final Columns columns = new Columns();
    private int rowIdx = -1;
    private List rowList = new ArrayList();

    MemoryResult() {
    }

    MemoryResult(Object[][] objectArray, int n) throws SQLException {
        Object[] objectArray2;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2 = new Column();
            objectArray2.setDataType(504);
            this.columns.add((Column)objectArray2);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            objectArray2 = objectArray[n2];
            ExpressionValue[] expressionValueArray = new ExpressionValue[objectArray2.length];
            this.addRow(expressionValueArray);
            for (int i = 0; i < n; ++i) {
                ExpressionValue expressionValue = expressionValueArray[i] = new ExpressionValue();
                expressionValue.set(objectArray2[i], -1);
                Column column = this.columns.get(i);
                if (expressionValue.getDataType() != 504) {
                    column.setDataType(expressionValue.getDataType());
                }
                if (expressionValue.getPrecision() <= column.getPrecision()) continue;
                column.setPrecision(expressionValue.getPrecision());
            }
        }
    }

    final void addRow(ExpressionValue[] expressionValueArray) {
        this.rowList.add(expressionValueArray);
    }

    final Column getColumn(int n) {
        return this.columns.get(n);
    }

    final void addColumn(Column column) {
        this.columns.add(column);
    }

    final boolean isScrollable() {
        return true;
    }

    final void beforeFirst() {
        this.rowIdx = -1;
        this.currentRow = null;
    }

    final boolean isBeforeFirst() {
        return this.rowIdx < 0 || this.rowList.size() == 0;
    }

    final boolean isFirst() {
        return this.rowIdx == 0 && this.currentRow != null;
    }

    final boolean first() {
        this.rowIdx = 0;
        return this.move();
    }

    final boolean previous() {
        if (this.rowIdx-- < 0) {
            this.rowIdx = -1;
        }
        return this.move();
    }

    final boolean next() {
        ++this.rowIdx;
        return this.move();
    }

    final boolean last() {
        this.rowIdx = this.rowList.size() - 1;
        return this.move();
    }

    final boolean isLast() {
        return this.rowIdx == this.rowList.size() - 1 && this.currentRow != null;
    }

    final boolean isAfterLast() {
        return this.rowIdx >= this.rowList.size() || this.rowList.size() == 0;
    }

    final void afterLast() {
        this.rowIdx = this.rowList.size();
        this.currentRow = null;
    }

    final boolean absolute(int n) throws SQLException {
        if (n == 0) {
            throw SmallSQLException.create("SS-0520");
        }
        this.rowIdx = n > 0 ? Math.min(n - 1, this.rowList.size()) : Math.max(n + this.rowList.size(), -1);
        return this.move();
    }

    final boolean relative(int n) {
        if (n == 0) {
            return this.currentRow != null;
        }
        this.rowIdx = Math.min(Math.max(this.rowIdx + n, -1), this.rowList.size());
        return this.move();
    }

    final int getRow() {
        return this.currentRow == null ? 0 : this.rowIdx + 1;
    }

    final long getRowPosition() {
        return this.rowIdx;
    }

    final void setRowPosition(long l) throws Exception {
        this.rowIdx = (int)l;
        this.move();
    }

    final boolean rowInserted() {
        return false;
    }

    final boolean rowDeleted() {
        return false;
    }

    void nullRow() {
        throw new Error();
    }

    void noRow() {
        this.currentRow = null;
    }

    private final boolean move() {
        if (this.rowIdx < this.rowList.size() && this.rowIdx >= 0) {
            this.currentRow = (ExpressionValue[])this.rowList.get(this.rowIdx);
            return true;
        }
        this.currentRow = null;
        return false;
    }

    boolean isNull(int n) throws Exception {
        return this.get(n).isNull();
    }

    boolean getBoolean(int n) throws Exception {
        return this.get(n).getBoolean();
    }

    int getInt(int n) throws Exception {
        return this.get(n).getInt();
    }

    long getLong(int n) throws Exception {
        return this.get(n).getLong();
    }

    float getFloat(int n) throws Exception {
        return this.get(n).getFloat();
    }

    double getDouble(int n) throws Exception {
        return this.get(n).getDouble();
    }

    long getMoney(int n) throws Exception {
        return this.get(n).getMoney();
    }

    MutableNumeric getNumeric(int n) throws Exception {
        return this.get(n).getNumeric();
    }

    Object getObject(int n) throws Exception {
        return this.get(n).getObject();
    }

    String getString(int n) throws Exception {
        return this.get(n).getString();
    }

    byte[] getBytes(int n) throws Exception {
        return this.get(n).getBytes();
    }

    int getDataType(int n) {
        return this.columns.get(n).getDataType();
    }

    final TableView getTableView() {
        return null;
    }

    final void deleteRow() throws Exception {
        throw SmallSQLException.create("SS-0131");
    }

    final void updateRow(Expression[] expressionArray) throws Exception {
        throw SmallSQLException.create("SS-0131");
    }

    final void insertRow(Expression[] expressionArray) throws Exception {
        throw SmallSQLException.create("SS-0131");
    }

    private Expression get(int n) throws Exception {
        if (this.currentRow == null) {
            throw SmallSQLException.create("SS-0521");
        }
        return this.currentRow[n];
    }

    int getRowCount() {
        return this.rowList.size();
    }

    void execute() throws Exception {
        this.rowList.clear();
    }
}

