/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.IndexNode;
import smallsql.database.MemoryStream;
import smallsql.database.StoreImpl;
import smallsql.database.StorePage;

public class FileIndexNode
extends IndexNode {
    private final FileChannel file;
    private long fileOffset;

    FileIndexNode(boolean bl, char c, FileChannel fileChannel) {
        super(bl, c);
        this.file = fileChannel;
        this.fileOffset = -1L;
    }

    protected IndexNode createIndexNode(boolean bl, char c) {
        return new FileIndexNode(bl, c, this.file);
    }

    void save() throws SQLException {
        StorePage storePage = new StorePage(null, -1, this.file, this.fileOffset);
        StoreImpl storeImpl = StoreImpl.createStore(null, storePage, 1107, this.fileOffset);
        this.save(storeImpl);
        this.fileOffset = storeImpl.writeFinsh(null);
    }

    void saveRef(StoreImpl storeImpl) throws SQLException {
        if (this.fileOffset < 0L) {
            this.save();
        }
        storeImpl.writeLong(this.fileOffset);
    }

    IndexNode loadRef(long l) throws SQLException {
        StorePage storePage = new StorePage(null, -1, this.file, l);
        StoreImpl storeImpl = StoreImpl.createStore(null, storePage, 1107, this.fileOffset);
        MemoryStream memoryStream = new MemoryStream();
        FileIndexNode fileIndexNode = new FileIndexNode(this.getUnique(), (char)memoryStream.readShort(), this.file);
        fileIndexNode.fileOffset = l;
        fileIndexNode.load(storeImpl);
        return fileIndexNode;
    }

    static FileIndexNode loadRootNode(boolean bl, FileChannel fileChannel, long l) throws Exception {
        StorePage storePage = new StorePage(null, -1, fileChannel, l);
        StoreImpl storeImpl = StoreImpl.createStore(null, storePage, 200, l);
        FileIndexNode fileIndexNode = new FileIndexNode(bl, (char)storeImpl.readShort(), fileChannel);
        fileIndexNode.fileOffset = l;
        fileIndexNode.load(storeImpl);
        return fileIndexNode;
    }
}

