/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;

final class Expressions {
    private int size;
    private Expression[] data;

    Expressions() {
        this.data = new Expression[16];
    }

    Expressions(int n) {
        this.data = new Expression[n];
    }

    final int size() {
        return this.size;
    }

    final void setSize(int n) {
        for (int i = n; i < this.size; ++i) {
            this.data[i] = null;
        }
        this.size = n;
        if (this.size > this.data.length) {
            this.resize(n);
        }
    }

    final Expression get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.data[n];
    }

    final void add(Expression expression) {
        if (this.size >= this.data.length) {
            this.resize(this.size << 1);
        }
        this.data[this.size++] = expression;
    }

    final void add(int n, Expression expression) {
        if (this.size >= this.data.length) {
            this.resize(this.size << 1);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size++ - n);
        this.data[n] = expression;
    }

    final void addAll(Expressions expressions) {
        int n = expressions.size();
        if (this.size + n >= this.data.length) {
            this.resize(this.size + n);
        }
        System.arraycopy(expressions.data, 0, this.data, this.size, n);
        this.size += n;
    }

    final void clear() {
        this.size = 0;
    }

    final void remove(int n) {
        System.arraycopy(this.data, n + 1, this.data, n, --this.size - n);
    }

    final void set(int n, Expression expression) {
        this.data[n] = expression;
    }

    final int indexOf(Expression expression) {
        if (expression == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.data[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!expression.equals(this.data[i])) continue;
                return i;
            }
        }
        return -1;
    }

    final void toArray(Expression[] expressionArray) {
        System.arraycopy(this.data, 0, expressionArray, 0, this.size);
    }

    final Expression[] toArray() {
        Expression[] expressionArray = new Expression[this.size];
        System.arraycopy(this.data, 0, expressionArray, 0, this.size);
        return expressionArray;
    }

    private final void resize(int n) {
        Expression[] expressionArray = new Expression[n];
        System.arraycopy(this.data, 0, expressionArray, 0, this.size);
        this.data = expressionArray;
    }
}

