/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.CommandSelect;
import smallsql.database.Expression;
import smallsql.database.ExpressionArithmetic;
import smallsql.database.Expressions;
import smallsql.database.Index;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;

class ExpressionInSelect
extends ExpressionArithmetic {
    private final CommandSelect cmdSel;
    private final Index index = new Index(true);
    private final SSConnection con;

    ExpressionInSelect(SSConnection sSConnection, Expression expression, CommandSelect commandSelect, int n) {
        super(expression, (Expressions)null, n);
        this.cmdSel = commandSelect;
        this.con = sSConnection;
    }

    private void loadInList() throws Exception {
        if (this.cmdSel.compile(this.con)) {
            this.cmdSel.from.execute();
            if (this.cmdSel.columnExpressions.size() != 1) {
                throw SmallSQLException.create("SS-0160", new Integer(this.cmdSel.columnExpressions.size()));
            }
            this.index.clear();
            while (this.cmdSel.next()) {
                try {
                    this.index.addValues(0L, this.cmdSel.columnExpressions);
                }
                catch (Exception exception) {}
            }
        }
    }

    boolean isInList() throws Exception {
        this.loadInList();
        return this.index.findRows(this.getParams(), false, null) != null;
    }
}

