/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.File;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.Database;
import smallsql.database.SSConnection;
import smallsql.database.SmallSQLException;
import smallsql.database.TransactionStep;

public class CreateFile
extends TransactionStep {
    private final File file;
    private final SSConnection con;
    private final Database database;

    CreateFile(File file, FileChannel fileChannel, SSConnection sSConnection, Database database) {
        super(fileChannel);
        this.file = file;
        this.con = sSConnection;
        this.database = database;
    }

    long commit() {
        this.raFile = null;
        return -1L;
    }

    void rollback() throws SQLException {
        FileChannel fileChannel = this.raFile;
        if (this.raFile == null) {
            return;
        }
        this.raFile = null;
        try {
            fileChannel.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.con.rollbackFile(fileChannel);
        if (!this.file.delete()) {
            this.file.deleteOnExit();
            throw SmallSQLException.create("SS-0492", this.file.getPath());
        }
        String string = this.file.getName();
        string = string.substring(0, string.lastIndexOf(46));
        this.database.removeTableView(string);
    }
}

