/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.ColumnExpression;
import smallsql.database.DateTime;
import smallsql.database.Expression;
import smallsql.database.ExpressionFunctionConvert;
import smallsql.database.ExpressionFunctionRTrim;
import smallsql.database.Expressions;
import smallsql.database.Money;
import smallsql.database.MutableNumeric;
import smallsql.database.SQLTokenizer;
import smallsql.database.SmallSQLException;
import smallsql.database.Utils;

public class ExpressionArithmetic
extends Expression {
    private Expression left;
    private Expression right;
    private Expression right2;
    private Expression[] inList;
    private final int operation;
    static final int OR = 11;
    static final int AND = 21;
    static final int NOT = 31;
    static final int BIT_OR = 41;
    static final int BIT_AND = 42;
    static final int BIT_XOR = 43;
    static final int EQUALS = 51;
    static final int EQUALS_NULL = 52;
    static final int GREATER = 53;
    static final int GRE_EQU = 54;
    static final int LESSER = 55;
    static final int LES_EQU = 56;
    static final int UNEQUALS = 57;
    static final int IN = 61;
    static final int BETWEEN = 62;
    static final int LIKE = 63;
    static final int ISNULL = 64;
    static final int ISNOTNULL = 65;
    static final int ADD = 71;
    static final int SUB = 72;
    static final int MUL = 81;
    static final int DIV = 82;
    static final int MOD = 83;
    static final int BIT_NOT = 91;
    static final int NEGATIVE = 101;
    private static final int[] DatatypeRange = new int[]{342, 343, 340, 341, 338, 337, 336, 332, 333, 331, 330, 325, 323, 322, 321, 300, 301, 360, 370, 355, 352, 353, 350, 359, 362, 311, 310, 313, 316, 504};
    private static int NVARCHAR_IDX = Utils.indexOf(355, DatatypeRange);
    private static int INT_IDX = Utils.indexOf(323, DatatypeRange);
    private static int BIGINT_IDX = Utils.indexOf(325, DatatypeRange);
    private static int MONEY_IDX = Utils.indexOf(331, DatatypeRange);
    private static int DECIMAL_IDX = Utils.indexOf(332, DatatypeRange);

    ExpressionArithmetic(Expression expression, int n) {
        super(3);
        this.left = expression;
        this.operation = n;
        super.setParams(new Expression[]{expression});
    }

    ExpressionArithmetic(Expression expression, Expression expression2, int n) {
        super(3);
        this.left = expression;
        this.right = expression2;
        this.operation = n;
        super.setParams(new Expression[]{expression, expression2});
    }

    ExpressionArithmetic(Expression expression, Expression expression2, Expression expression3, int n) {
        super(3);
        this.left = expression;
        this.right = expression2;
        this.right2 = expression3;
        this.operation = n;
        super.setParams(new Expression[]{expression, expression2, expression3});
    }

    ExpressionArithmetic(Expression expression, Expressions expressions, int n) {
        super(3);
        Expression[] expressionArray;
        this.left = expression;
        this.operation = n;
        if (expressions != null) {
            this.inList = expressions.toArray();
            expressionArray = new Expression[this.inList.length + 1];
            expressionArray[0] = expression;
            System.arraycopy(this.inList, 0, expressionArray, 1, this.inList.length);
        } else {
            expressionArray = new Expression[]{expression};
        }
        super.setParams(expressionArray);
    }

    int getOperation() {
        return this.operation;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Expression convertExpressionIfNeeded(Expression expression, Expression expression2) {
        if (expression == null || expression2 == null) {
            return expression;
        }
        switch (expression.getDataType()) {
            case 310: 
            case 350: 
            case 352: {
                switch (expression2.getDataType()) {
                    case 311: 
                    case 353: 
                    case 355: 
                    case 359: 
                    case 360: 
                    case 362: 
                    case 363: {
                        ExpressionFunctionRTrim expressionFunctionRTrim = new ExpressionFunctionRTrim();
                        expressionFunctionRTrim.setParams(new Expression[]{expression});
                        return expressionFunctionRTrim;
                    }
                    case 310: 
                    case 350: 
                    case 352: {
                        if (expression2.getPrecision() <= expression.getPrecision()) return expression;
                        return new ExpressionFunctionConvert(new ColumnExpression(expression2), expression, null);
                    }
                }
                return expression;
            }
        }
        return expression;
    }

    final void setParamAt(Expression expression, int n) {
        switch (n) {
            case 0: {
                this.left = expression;
                break;
            }
            case 1: {
                if (this.right == null) break;
                this.right = expression;
                break;
            }
            case 2: {
                if (this.right == null) break;
                this.right2 = expression;
            }
        }
        if (this.inList != null && n > 0 && n <= this.inList.length) {
            this.inList[n - 1] = expression;
        }
        super.setParamAt(expression, n);
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof ExpressionArithmetic)) {
            return false;
        }
        return ((ExpressionArithmetic)object).operation == this.operation;
    }

    int getInt() throws Exception {
        if (this.isNull()) {
            return 0;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? 1 : 0;
            }
            case 321: 
            case 322: 
            case 323: {
                return this.getIntImpl();
            }
            case 325: {
                return (int)this.getLongImpl();
            }
            case 336: {
                return (int)this.getFloatImpl();
            }
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 337: 
            case 338: {
                return (int)this.getDoubleImpl();
            }
        }
        throw this.createUnspportedConversion(323);
    }

    private int getIntImpl() throws Exception {
        switch (this.operation) {
            case 71: {
                return this.left.getInt() + this.right.getInt();
            }
            case 72: {
                return this.left.getInt() - this.right.getInt();
            }
            case 81: {
                return this.left.getInt() * this.right.getInt();
            }
            case 82: {
                return this.left.getInt() / this.right.getInt();
            }
            case 101: {
                return -this.left.getInt();
            }
            case 83: {
                return this.left.getInt() % this.right.getInt();
            }
            case 91: {
                return ~this.left.getInt();
            }
        }
        throw this.createUnspportedConversion(323);
    }

    long getLong() throws Exception {
        if (this.isNull()) {
            return 0L;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? 1L : 0L;
            }
            case 321: 
            case 322: 
            case 323: {
                return this.getIntImpl();
            }
            case 325: {
                return this.getLongImpl();
            }
            case 336: {
                return (long)this.getFloatImpl();
            }
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 337: 
            case 338: {
                return (long)this.getDoubleImpl();
            }
        }
        throw this.createUnspportedConversion(361);
    }

    private long getLongImpl() throws Exception {
        if (this.isNull()) {
            return 0L;
        }
        switch (this.operation) {
            case 71: {
                return this.left.getLong() + this.right.getLong();
            }
            case 72: {
                return this.left.getLong() - this.right.getLong();
            }
            case 81: {
                return this.left.getLong() * this.right.getLong();
            }
            case 82: {
                return this.left.getLong() / this.right.getLong();
            }
            case 101: {
                return -this.left.getLong();
            }
            case 83: {
                return this.left.getLong() % this.right.getLong();
            }
            case 91: {
                return ~this.right.getInt();
            }
        }
        throw this.createUnspportedConversion(361);
    }

    double getDouble() throws Exception {
        if (this.isNull()) {
            return 0.0;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? 1.0 : 0.0;
            }
            case 321: 
            case 322: 
            case 323: {
                return this.getIntImpl();
            }
            case 325: {
                return this.getLongImpl();
            }
            case 336: {
                return this.getFloatImpl();
            }
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 337: 
            case 338: {
                return this.getDoubleImpl();
            }
        }
        throw this.createUnspportedConversion(338);
    }

    private double getDoubleImpl() throws Exception {
        if (this.operation == 101) {
            return this.getDoubleImpl(0.0, this.left.getDouble());
        }
        return this.getDoubleImpl(this.left.getDouble(), this.right.getDouble());
    }

    private double getDoubleImpl(double d, double d2) throws Exception {
        switch (this.operation) {
            case 71: {
                return d + d2;
            }
            case 72: {
                return d - d2;
            }
            case 81: {
                return d * d2;
            }
            case 82: {
                return d / d2;
            }
            case 101: {
                return -d2;
            }
            case 83: {
                return d % d2;
            }
        }
        throw this.createUnspportedConversion(338);
    }

    float getFloat() throws Exception {
        if (this.isNull()) {
            return 0.0f;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? 1.0f : 0.0f;
            }
            case 321: 
            case 322: 
            case 323: {
                return this.getIntImpl();
            }
            case 325: {
                return this.getLongImpl();
            }
            case 336: {
                return this.getFloatImpl();
            }
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 337: 
            case 338: {
                return (float)this.getDoubleImpl();
            }
        }
        throw this.createUnspportedConversion(338);
    }

    private float getFloatImpl() throws Exception {
        switch (this.operation) {
            case 71: {
                return this.left.getFloat() + this.right.getFloat();
            }
            case 72: {
                return this.left.getFloat() - this.right.getFloat();
            }
            case 81: {
                return this.left.getFloat() * this.right.getFloat();
            }
            case 82: {
                return this.left.getFloat() / this.right.getFloat();
            }
            case 101: {
                return -this.left.getFloat();
            }
            case 83: {
                return this.left.getFloat() % this.right.getFloat();
            }
        }
        throw this.createUnspportedConversion(336);
    }

    long getMoney() throws Exception {
        if (this.isNull()) {
            return 0L;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? 10000L : 0L;
            }
            case 321: 
            case 322: 
            case 323: {
                return this.getIntImpl() * 10000;
            }
            case 325: {
                return this.getLongImpl() * 10000L;
            }
            case 336: {
                return Utils.doubleToMoney(this.getFloatImpl());
            }
            case 332: 
            case 333: 
            case 337: 
            case 338: {
                return Utils.doubleToMoney(this.getDoubleImpl());
            }
            case 330: 
            case 331: {
                return this.getMoneyImpl();
            }
        }
        throw this.createUnspportedConversion(338);
    }

    private long getMoneyImpl() throws Exception {
        switch (this.operation) {
            case 71: {
                return this.left.getMoney() + this.right.getMoney();
            }
            case 72: {
                return this.left.getMoney() - this.right.getMoney();
            }
            case 81: {
                return this.left.getMoney() * this.right.getMoney() / 10000L;
            }
            case 82: {
                return this.left.getMoney() * 10000L / this.right.getMoney();
            }
            case 101: {
                return -this.left.getMoney();
            }
        }
        throw this.createUnspportedConversion(331);
    }

    MutableNumeric getNumeric() throws Exception {
        if (this.isNull()) {
            return null;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return new MutableNumeric(this.getBoolean() ? 1 : 0);
            }
            case 321: 
            case 322: 
            case 323: {
                return new MutableNumeric(this.getIntImpl());
            }
            case 325: {
                return new MutableNumeric(this.getLongImpl());
            }
            case 336: {
                return new MutableNumeric(this.getFloatImpl());
            }
            case 337: 
            case 338: {
                return new MutableNumeric(this.getDoubleImpl());
            }
            case 332: 
            case 333: {
                return this.getNumericImpl();
            }
            case 330: 
            case 331: {
                return new MutableNumeric(this.getMoneyImpl(), 4);
            }
        }
        throw this.createUnspportedConversion(338);
    }

    private MutableNumeric getNumericImpl() throws Exception {
        switch (this.operation) {
            case 71: {
                MutableNumeric mutableNumeric = this.left.getNumeric();
                mutableNumeric.add(this.right.getNumeric());
                return mutableNumeric;
            }
            case 72: {
                MutableNumeric mutableNumeric = this.left.getNumeric();
                mutableNumeric.sub(this.right.getNumeric());
                return mutableNumeric;
            }
            case 81: {
                if (ExpressionArithmetic.getDataType(this.right.getDataType(), 323) == 323) {
                    MutableNumeric mutableNumeric = this.left.getNumeric();
                    mutableNumeric.mul(this.right.getInt());
                    return mutableNumeric;
                }
                if (ExpressionArithmetic.getDataType(this.left.getDataType(), 323) == 323) {
                    MutableNumeric mutableNumeric = this.right.getNumeric();
                    mutableNumeric.mul(this.left.getInt());
                    return mutableNumeric;
                }
                MutableNumeric mutableNumeric = this.left.getNumeric();
                mutableNumeric.mul(this.right.getNumeric());
                return mutableNumeric;
            }
            case 82: {
                MutableNumeric mutableNumeric = this.left.getNumeric();
                if (ExpressionArithmetic.getDataType(this.right.getDataType(), 323) == 323) {
                    mutableNumeric.div(this.right.getInt());
                } else {
                    mutableNumeric.div(this.right.getNumeric());
                }
                return mutableNumeric;
            }
            case 101: {
                MutableNumeric mutableNumeric = this.left.getNumeric();
                mutableNumeric.setSignum(-mutableNumeric.getSignum());
                return mutableNumeric;
            }
            case 83: {
                if (ExpressionArithmetic.getDataType(this.getDataType(), 323) == 323) {
                    return new MutableNumeric(this.getInt());
                }
                MutableNumeric mutableNumeric = this.left.getNumeric();
                mutableNumeric.mod(this.right.getNumeric());
                return mutableNumeric;
            }
        }
        throw this.createUnspportedConversion(333);
    }

    Object getObject() throws Exception {
        if (this.isNull()) {
            return null;
        }
        int n = this.getDataType();
        switch (n) {
            case 300: 
            case 301: {
                return this.getBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 310: 
            case 311: {
                return this.getBytes();
            }
            case 321: 
            case 322: 
            case 323: {
                return new Integer(this.getInt());
            }
            case 325: {
                return new Long(this.getLong());
            }
            case 336: {
                return new Float(this.getFloat());
            }
            case 337: 
            case 338: {
                return new Double(this.getDouble());
            }
            case 330: 
            case 331: {
                return Money.createFromUnscaledValue(this.getMoney());
            }
            case 332: 
            case 333: {
                return this.getNumeric();
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: 
            case 359: 
            case 360: {
                return this.getString(this.left.getString(), this.right.getString());
            }
            case 371: {
                Object object = this.left.getObject();
                Object object2 = this.right.getObject();
                if (object instanceof Number && object2 instanceof Number) {
                    return new Double(this.getDoubleImpl(((Number)object).doubleValue(), ((Number)object2).doubleValue()));
                }
                return this.getString(object.toString(), object2.toString());
            }
            case 313: {
                return this.getBytes();
            }
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                return new DateTime(this.getLong(), n);
            }
            case 370: {
                return this.getBytes();
            }
        }
        throw this.createUnspportedDataType();
    }

    boolean getBoolean() throws Exception {
        int n;
        int n2;
        switch (this.operation) {
            case 11: {
                return this.left.getBoolean() || this.right.getBoolean();
            }
            case 21: {
                return this.left.getBoolean() && this.right.getBoolean();
            }
            case 31: {
                return !this.left.getBoolean();
            }
            case 63: {
                return Utils.like(this.left.getString(), this.right.getString());
            }
            case 64: {
                return this.left.isNull();
            }
            case 65: {
                return !this.left.isNull();
            }
            case 61: {
                if (this.right != null) break;
                return this.isInList();
            }
        }
        boolean bl = this.left.isNull();
        if (this.operation == 101 || this.operation == 91) {
            if (bl) {
                return false;
            }
            n2 = this.left.getDataType();
        } else {
            n = this.right.isNull();
            if (this.operation == 52 && bl && n != 0) {
                return true;
            }
            if (bl || n != 0) {
                return false;
            }
            n2 = ExpressionArithmetic.getDataType(this.left, this.right);
        }
        switch (n2) {
            case 301: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getBoolean() == this.right.getBoolean();
                    }
                    case 57: {
                        return this.left.getBoolean() != this.right.getBoolean();
                    }
                }
            }
            case 300: 
            case 321: 
            case 322: 
            case 323: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getInt() == this.right.getInt();
                    }
                    case 53: {
                        return this.left.getInt() > this.right.getInt();
                    }
                    case 54: {
                        return this.left.getInt() >= this.right.getInt();
                    }
                    case 55: {
                        return this.left.getInt() < this.right.getInt();
                    }
                    case 56: {
                        return this.left.getInt() <= this.right.getInt();
                    }
                    case 57: {
                        return this.left.getInt() != this.right.getInt();
                    }
                    case 62: {
                        n = this.left.getInt();
                        return n >= this.right.getInt() && this.right2.getInt() >= n;
                    }
                }
                return this.getInt() != 0;
            }
            case 325: 
            case 340: 
            case 341: 
            case 342: 
            case 343: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getLong() == this.right.getLong();
                    }
                    case 53: {
                        return this.left.getLong() > this.right.getLong();
                    }
                    case 54: {
                        return this.left.getLong() >= this.right.getLong();
                    }
                    case 55: {
                        return this.left.getLong() < this.right.getLong();
                    }
                    case 56: {
                        return this.left.getLong() <= this.right.getLong();
                    }
                    case 57: {
                        return this.left.getLong() != this.right.getLong();
                    }
                    case 62: {
                        long l = this.left.getLong();
                        return l >= this.right.getLong() && this.right2.getLong() >= l;
                    }
                }
                return this.getLong() != 0L;
            }
            case 336: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getFloat() == this.right.getFloat();
                    }
                    case 53: {
                        return this.left.getFloat() > this.right.getFloat();
                    }
                    case 54: {
                        return this.left.getFloat() >= this.right.getFloat();
                    }
                    case 55: {
                        return this.left.getFloat() < this.right.getFloat();
                    }
                    case 56: {
                        return this.left.getFloat() <= this.right.getFloat();
                    }
                    case 57: {
                        return this.left.getFloat() != this.right.getFloat();
                    }
                    case 62: {
                        float f = this.left.getFloat();
                        return f >= this.right.getFloat() && this.right2.getFloat() >= f;
                    }
                }
                return this.getFloat() != 0.0f;
            }
            case 337: 
            case 338: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getDouble() == this.right.getDouble();
                    }
                    case 53: {
                        return this.left.getDouble() > this.right.getDouble();
                    }
                    case 54: {
                        return this.left.getDouble() >= this.right.getDouble();
                    }
                    case 55: {
                        return this.left.getDouble() < this.right.getDouble();
                    }
                    case 56: {
                        return this.left.getDouble() <= this.right.getDouble();
                    }
                    case 57: {
                        return this.left.getDouble() != this.right.getDouble();
                    }
                    case 62: {
                        double d = this.left.getDouble();
                        return d >= this.right.getDouble() && this.right2.getDouble() >= d;
                    }
                }
                return this.getDouble() != 0.0;
            }
            case 330: 
            case 331: {
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return this.left.getMoney() == this.right.getMoney();
                    }
                    case 53: {
                        return this.left.getMoney() > this.right.getMoney();
                    }
                    case 54: {
                        return this.left.getMoney() >= this.right.getMoney();
                    }
                    case 55: {
                        return this.left.getMoney() < this.right.getMoney();
                    }
                    case 56: {
                        return this.left.getMoney() <= this.right.getMoney();
                    }
                    case 57: {
                        return this.left.getMoney() != this.right.getMoney();
                    }
                    case 62: {
                        long l = this.left.getMoney();
                        return l >= this.right.getMoney() && this.right2.getMoney() >= l;
                    }
                }
                return this.getMoney() != 0L;
            }
            case 332: 
            case 333: {
                if (this.operation == 101) {
                    return this.left.getNumeric().getSignum() != 0;
                }
                n = this.left.getNumeric().compareTo(this.right.getNumeric());
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return n == 0;
                    }
                    case 53: {
                        return n > 0;
                    }
                    case 54: {
                        return n >= 0;
                    }
                    case 55: {
                        return n < 0;
                    }
                    case 56: {
                        return n <= 0;
                    }
                    case 57: {
                        return n != 0;
                    }
                    case 62: {
                        return n >= 0 && 0 >= this.left.getNumeric().compareTo(this.right2.getNumeric());
                    }
                }
                return this.getNumeric().getSignum() != 0;
            }
            case 350: 
            case 352: 
            case 353: 
            case 355: 
            case 359: 
            case 360: 
            case 362: {
                String string = this.left.getString();
                String string2 = this.right.getString();
                int n3 = String.CASE_INSENSITIVE_ORDER.compare(string, string2);
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return n3 == 0;
                    }
                    case 53: {
                        return n3 > 0;
                    }
                    case 54: {
                        return n3 >= 0;
                    }
                    case 55: {
                        return n3 < 0;
                    }
                    case 56: {
                        return n3 <= 0;
                    }
                    case 57: {
                        return n3 != 0;
                    }
                    case 62: {
                        return n3 >= 0 && 0 >= String.CASE_INSENSITIVE_ORDER.compare(string, this.right2.getString());
                    }
                    case 71: {
                        return Utils.string2boolean(string + string2);
                    }
                }
                break;
            }
            case 310: 
            case 311: 
            case 313: 
            case 316: 
            case 370: {
                byte[] byArray = this.left.getBytes();
                byte[] byArray2 = this.right.getBytes();
                int n4 = Utils.compareBytes(byArray, byArray2);
                switch (this.operation) {
                    case 51: 
                    case 52: 
                    case 61: {
                        return n4 == 0;
                    }
                    case 53: {
                        return n4 > 0;
                    }
                    case 54: {
                        return n4 >= 0;
                    }
                    case 55: {
                        return n4 < 0;
                    }
                    case 56: {
                        return n4 <= 0;
                    }
                    case 57: {
                        return n4 != 0;
                    }
                    case 62: {
                        return n4 >= 0 && 0 >= Utils.compareBytes(byArray, this.right2.getBytes());
                    }
                }
                break;
            }
        }
        throw this.createUnspportedDataType();
    }

    String getString() throws Exception {
        if (this.isNull()) {
            return null;
        }
        return this.getObject().toString();
    }

    private final String getString(String string, String string2) throws Exception {
        switch (this.operation) {
            case 71: {
                return string + string2;
            }
        }
        throw this.createUnspportedConversion(353);
    }

    int getDataType() {
        switch (this.operation) {
            case 91: 
            case 101: {
                return this.left.getDataType();
            }
            case 11: 
            case 21: 
            case 31: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return 301;
            }
        }
        return ExpressionArithmetic.getDataType(this.left, this.right);
    }

    int getScale() {
        int n = this.getDataType();
        switch (n) {
            case 332: 
            case 333: {
                switch (this.operation) {
                    case 71: 
                    case 72: {
                        return Math.max(this.left.getScale(), this.right.getScale());
                    }
                    case 81: {
                        return this.left.getScale() + this.right.getScale();
                    }
                    case 82: {
                        return Math.max(this.left.getScale() + 5, this.right.getScale() + 4);
                    }
                    case 101: {
                        return this.left.getScale();
                    }
                    case 83: {
                        return 0;
                    }
                }
            }
        }
        return ExpressionArithmetic.getScale(n);
    }

    boolean isNull() throws Exception {
        switch (this.operation) {
            case 11: 
            case 21: 
            case 31: 
            case 61: 
            case 63: 
            case 64: 
            case 65: {
                return false;
            }
            case 91: 
            case 101: {
                return this.left.isNull();
            }
        }
        return this.left.isNull() || this.right.isNull();
    }

    byte[] getBytes() throws Exception {
        throw this.createUnspportedConversion(310);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInList() throws Exception {
        if (this.left.isNull()) {
            return false;
        }
        try {
            for (int i = 0; i < this.inList.length; ++i) {
                this.right = this.inList[i];
                if (!this.getBoolean()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.right = null;
        }
        return false;
    }

    SQLException createUnspportedDataType() {
        Object[] objectArray = new Object[]{SQLTokenizer.getKeyWord(ExpressionArithmetic.getDataType(this.left, this.right)), ExpressionArithmetic.getKeywordFromOperation(this.operation)};
        return SmallSQLException.create("SS-0281", objectArray);
    }

    SQLException createUnspportedConversion(int n) {
        int n2 = this.left == null ? this.right.getDataType() : ExpressionArithmetic.getDataType(this.left, this.right);
        Object[] objectArray = new Object[]{SQLTokenizer.getKeyWord(n), SQLTokenizer.getKeyWord(n2), ExpressionArithmetic.getKeywordFromOperation(this.operation)};
        return SmallSQLException.create("SS-0280", objectArray);
    }

    void optimize() throws SQLException {
        super.optimize();
        Expression[] expressionArray = this.getParams();
        if (expressionArray.length == 1) {
            return;
        }
        this.setParamAt(this.convertExpressionIfNeeded(expressionArray[0], expressionArray[1]), 0);
        for (int i = 1; i < expressionArray.length; ++i) {
            this.setParamAt(this.convertExpressionIfNeeded(expressionArray[i], this.left), i);
        }
    }

    private static String getKeywordFromOperation(int n) {
        String string;
        int n2 = 0;
        for (int i = 1; i < 1000; ++i) {
            if (ExpressionArithmetic.getOperationFromToken(i) != n) continue;
            n2 = i;
            break;
        }
        if (n == 101) {
            n2 = 45;
        }
        if (n == 65) {
            n2 = 502;
        }
        if ((string = SQLTokenizer.getKeyWord(n2)) == null) {
            string = "" + (char)n2;
        }
        return string;
    }

    static int getOperationFromToken(int n) {
        switch (n) {
            case 43: {
                return 71;
            }
            case 45: {
                return 72;
            }
            case 42: {
                return 81;
            }
            case 47: {
                return 82;
            }
            case 37: {
                return 83;
            }
            case 61: {
                return 51;
            }
            case 62: {
                return 53;
            }
            case 162: {
                return 54;
            }
            case 60: {
                return 55;
            }
            case 160: {
                return 56;
            }
            case 161: {
                return 57;
            }
            case 507: {
                return 62;
            }
            case 508: {
                return 63;
            }
            case 509: {
                return 61;
            }
            case 502: {
                return 64;
            }
            case 500: {
                return 11;
            }
            case 501: {
                return 21;
            }
            case 503: {
                return 31;
            }
            case 124: {
                return 41;
            }
            case 38: {
                return 42;
            }
            case 94: {
                return 43;
            }
            case 126: {
                return 91;
            }
        }
        return 0;
    }

    static int getDataType(Expression expression, Expression expression2) {
        int n = expression.getDataType();
        int n2 = expression2.getDataType();
        return ExpressionArithmetic.getDataType(n, n2);
    }

    static int getBestNumberDataType(int n) {
        int n2 = Utils.indexOf(n, DatatypeRange);
        if (n2 >= NVARCHAR_IDX) {
            return 338;
        }
        if (n2 >= INT_IDX) {
            return 323;
        }
        if (n2 >= BIGINT_IDX) {
            return 325;
        }
        if (n2 >= MONEY_IDX) {
            return 331;
        }
        if (n2 >= DECIMAL_IDX) {
            return 332;
        }
        return 338;
    }

    static int getDataType(int n, int n2) {
        if (n == n2) {
            return n;
        }
        int n3 = Math.min(Utils.indexOf(n, DatatypeRange), Utils.indexOf(n2, DatatypeRange));
        if (n3 < 0) {
            throw new Error("getDataType(): " + n + ", " + n2);
        }
        return DatatypeRange[n3];
    }
}

