/*
 * Decompiled with CFR 0.152.
 */
package smallsql.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.swing.JOptionPane;
import smallsql.database.SSDriver;

public class CommandLine {
    public static void main(String[] stringArray) throws Exception {
        System.out.println("SmallSQL Database command line tool\n");
        Connection connection = new SSDriver().connect("jdbc:smallsql", new Properties());
        Statement statement = connection.createStatement();
        if (stringArray.length > 0) {
            connection.setCatalog(stringArray[0]);
        }
        System.out.println("\tVersion: " + connection.getMetaData().getDatabaseProductVersion());
        System.out.println("\tCurrent database: " + connection.getCatalog());
        System.out.println();
        System.out.println("\tUse the USE command to change the database context.");
        System.out.println("\tType 2 times ENTER to execute any SQL command.");
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    String string;
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        JOptionPane.showMessageDialog(null, "You need to start the command line of the \nSmallSQL Database with a console window:\n\n       java -jar smallsql.jar\n\n" + iOException, "Fatal Error", 0);
                        return;
                    }
                    if (string == null) {
                        return;
                    }
                    if (string.length() == 0 && stringBuffer.length() > 0) {
                        boolean bl = statement.execute(stringBuffer.toString());
                        if (bl) {
                            CommandLine.printRS(statement.getResultSet());
                        }
                        stringBuffer.setLength(0);
                    }
                    stringBuffer.append(string).append('\n');
                }
            }
            catch (Exception exception) {
                stringBuffer.setLength(0);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void printRS(ResultSet resultSet) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (n = 1; n <= n2; ++n) {
            System.out.print(resultSetMetaData.getColumnLabel(n));
            System.out.print('\t');
        }
        System.out.println();
        while (resultSet.next()) {
            for (n = 1; n <= n2; ++n) {
                System.out.print(resultSet.getObject(n));
                System.out.print('\t');
            }
            System.out.println();
        }
    }
}

