/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import smallsql.database.Expression;
import smallsql.database.RowSource;

class JoinScroll {
    private final Expression condition;
    final int type;
    final RowSource left;
    final RowSource right;
    private boolean isBeforeFirst = true;
    private boolean isOuterValid = true;
    private boolean[] isFullNotValid;
    private int fullRightRowCounter;
    private int fullRowCount;
    private int fullReturnCounter = -1;

    JoinScroll(int n, RowSource rowSource, RowSource rowSource2, Expression expression) {
        this.type = n;
        this.condition = expression;
        this.left = rowSource;
        this.right = rowSource2;
        if (n == 4) {
            this.isFullNotValid = new boolean[10];
        }
    }

    void beforeFirst() throws Exception {
        this.left.beforeFirst();
        this.right.beforeFirst();
        this.isBeforeFirst = true;
        this.fullRightRowCounter = 0;
        this.fullRowCount = 0;
        this.fullReturnCounter = -1;
    }

    boolean next() throws Exception {
        boolean bl;
        if (this.fullReturnCounter >= 0) {
            do {
                if (this.fullReturnCounter >= this.fullRowCount) {
                    return false;
                }
                this.right.next();
            } while (this.isFullNotValid[this.fullReturnCounter++]);
            return true;
        }
        do {
            if (this.isBeforeFirst) {
                bl = this.left.next();
                if (bl) {
                    bl = this.right.first();
                    if (!bl) {
                        switch (this.type) {
                            case 3: 
                            case 4: {
                                this.isOuterValid = false;
                                this.isBeforeFirst = false;
                                this.right.nullRow();
                                return true;
                            }
                        }
                    } else {
                        ++this.fullRightRowCounter;
                    }
                } else if (this.type == 4) {
                    while (this.right.next()) {
                        ++this.fullRightRowCounter;
                    }
                    this.fullRowCount = this.fullRightRowCounter;
                }
            } else {
                bl = this.right.next();
                if (!bl) {
                    switch (this.type) {
                        case 3: 
                        case 4: {
                            if (this.isOuterValid) {
                                this.isOuterValid = false;
                                this.right.nullRow();
                                return true;
                            }
                            this.fullRowCount = Math.max(this.fullRowCount, this.fullRightRowCounter);
                            this.fullRightRowCounter = 0;
                        }
                    }
                    this.isOuterValid = true;
                    bl = this.left.next();
                    if (bl) {
                        bl = this.right.first();
                        if (!bl) {
                            switch (this.type) {
                                case 3: 
                                case 4: {
                                    this.isOuterValid = false;
                                    this.right.nullRow();
                                    return true;
                                }
                            }
                        } else {
                            ++this.fullRightRowCounter;
                        }
                    }
                } else {
                    ++this.fullRightRowCounter;
                }
            }
            this.isBeforeFirst = false;
        } while (bl && !this.getBoolean());
        this.isOuterValid = false;
        if (this.type == 4) {
            if (this.fullRightRowCounter >= this.isFullNotValid.length) {
                boolean[] blArray = new boolean[this.fullRightRowCounter << 1];
                System.arraycopy(this.isFullNotValid, 0, blArray, 0, this.fullRightRowCounter);
                this.isFullNotValid = blArray;
            }
            if (!bl) {
                if (this.fullRowCount == 0) {
                    return false;
                }
                if (this.fullReturnCounter < 0) {
                    this.fullReturnCounter = 0;
                    this.right.first();
                    this.left.nullRow();
                }
                while (this.isFullNotValid[this.fullReturnCounter++]) {
                    if (this.fullReturnCounter >= this.fullRowCount) {
                        return false;
                    }
                    this.right.next();
                }
                return true;
            }
            this.isFullNotValid[this.fullRightRowCounter - 1] = bl;
        }
        return bl;
    }

    private boolean getBoolean() throws Exception {
        return this.type == 1 || this.condition.getBoolean();
    }
}

