/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.math.BigDecimal;
import java.math.BigInteger;
import smallsql.database.Mutable;
import smallsql.database.Utils;

public class Money
extends Number
implements Mutable {
    private static final long serialVersionUID = -620300937494609089L;
    long value;
    private static final BigDecimal ZERO = new BigDecimal("0.0000");

    private Money() {
    }

    public Money(double d) {
        this.value = (long)(d * 10000.0);
    }

    public Money(float f) {
        this.value = (long)(f * 10000.0f);
    }

    public static Money createFromUnscaledValue(long l) {
        Money money = new Money();
        money.value = l;
        return money;
    }

    public static Money createFromUnscaledValue(int n) {
        Money money = new Money();
        money.value = n;
        return money;
    }

    public int intValue() {
        return (int)((double)this.value / 10000.0);
    }

    public float floatValue() {
        return (float)this.value / 10000.0f;
    }

    public double doubleValue() {
        return (double)this.value / 10000.0;
    }

    public long longValue() {
        return (long)((double)this.value / 10000.0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.longValue()).append('.');
        long l = Math.abs(this.value);
        stringBuffer.append((char)(l % 10000L / 1000L + 48L));
        stringBuffer.append((char)(l % 1000L / 100L + 48L));
        stringBuffer.append((char)(l % 100L / 10L + 48L));
        stringBuffer.append((char)(l % 10L + 48L));
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        return object instanceof Money && ((Money)object).value == this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public long unscaledValue() {
        return this.value;
    }

    public static long parseMoney(String string) {
        return Utils.doubleToMoney(Double.parseDouble(string));
    }

    private byte[] toByteArray() {
        byte[] byArray = new byte[8];
        int n = 0;
        byArray[n++] = (byte)(this.value >> 56);
        byArray[n++] = (byte)(this.value >> 48);
        byArray[n++] = (byte)(this.value >> 40);
        byArray[n++] = (byte)(this.value >> 32);
        byArray[n++] = (byte)(this.value >> 24);
        byArray[n++] = (byte)(this.value >> 16);
        byArray[n++] = (byte)(this.value >> 8);
        byArray[n++] = (byte)this.value;
        return byArray;
    }

    public BigDecimal toBigDecimal() {
        if (this.value == 0L) {
            return ZERO;
        }
        return new BigDecimal(new BigInteger(this.toByteArray()), 4);
    }

    public Object getImmutableObject() {
        return this.toBigDecimal();
    }
}

