/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.ExpressionValue;
import smallsql.database.Mutable;
import smallsql.database.MutableNumeric;
import smallsql.database.SSResultSetMetaData;

abstract class Expression
implements Cloneable {
    static final Expression NULL = new ExpressionValue(null, 504);
    private final int type;
    private String name;
    private String alias;
    private Expression[] params;
    static final int VALUE = 1;
    static final int NAME = 2;
    static final int FUNCTION = 3;
    static final int GROUP_BY = 11;
    static final int COUNT = 12;
    static final int SUM = 13;
    static final int FIRST = 14;
    static final int LAST = 15;
    static final int MIN = 16;
    static final int MAX = 17;
    static final int GROUP_BEGIN = 11;

    Expression(int n) {
        this.type = n;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    final String getName() {
        return this.name;
    }

    final void setName(String string) {
        this.alias = this.name = string;
    }

    final String getAlias() {
        return this.alias;
    }

    final void setAlias(String string) {
        this.alias = string;
    }

    void setParams(Expression[] expressionArray) {
        this.params = expressionArray;
    }

    void setParamAt(Expression expression, int n) {
        this.params[n] = expression;
    }

    final Expression[] getParams() {
        return this.params;
    }

    void optimize() throws SQLException {
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                this.params[i].optimize();
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Expression)) {
            return false;
        }
        if (((Expression)object).type == this.type) {
            String string;
            String string2;
            Expression[] expressionArray = ((Expression)object).params;
            Expression[] expressionArray2 = this.params;
            if (expressionArray != null && expressionArray2 != null) {
                if (expressionArray == null) {
                    return false;
                }
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray2[i].equals(expressionArray[i])) continue;
                    return false;
                }
            }
            if ((string2 = ((Expression)object).name) == (string = this.name)) {
                return true;
            }
            if (string2 == null) {
                return false;
            }
            if (string2.equalsIgnoreCase(string)) {
                return true;
            }
        }
        return false;
    }

    abstract boolean isNull() throws Exception;

    abstract boolean getBoolean() throws Exception;

    abstract int getInt() throws Exception;

    abstract long getLong() throws Exception;

    abstract float getFloat() throws Exception;

    abstract double getDouble() throws Exception;

    abstract long getMoney() throws Exception;

    abstract MutableNumeric getNumeric() throws Exception;

    abstract Object getObject() throws Exception;

    final Object getApiObject() throws Exception {
        Object object = this.getObject();
        if (object instanceof Mutable) {
            return ((Mutable)object).getImmutableObject();
        }
        return object;
    }

    abstract String getString() throws Exception;

    abstract byte[] getBytes() throws Exception;

    abstract int getDataType();

    final int getType() {
        return this.type;
    }

    String getTableName() {
        return null;
    }

    int getPrecision() {
        return SSResultSetMetaData.getDataTypePrecision(this.getDataType(), -1);
    }

    int getScale() {
        return Expression.getScale(this.getDataType());
    }

    static final int getScale(int n) {
        switch (n) {
            case 330: 
            case 331: {
                return 4;
            }
            case 342: {
                return 9;
            }
            case 332: 
            case 333: {
                return 38;
            }
        }
        return 0;
    }

    int getDisplaySize() {
        return SSResultSetMetaData.getDisplaySize(this.getDataType(), this.getPrecision(), this.getScale());
    }

    boolean isDefinitelyWritable() {
        return false;
    }

    boolean isAutoIncrement() {
        return false;
    }

    boolean isCaseSensitive() {
        return false;
    }

    boolean isNullable() {
        return true;
    }
}

