/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.sql.SQLException;
import smallsql.database.Columns;
import smallsql.database.Command;
import smallsql.database.DataSource;
import smallsql.database.DataSources;
import smallsql.database.Distinct;
import smallsql.database.Expression;
import smallsql.database.ExpressionName;
import smallsql.database.ExpressionValue;
import smallsql.database.Expressions;
import smallsql.database.GroupResult;
import smallsql.database.Join;
import smallsql.database.Logger;
import smallsql.database.NoFromResult;
import smallsql.database.RowSource;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSet;
import smallsql.database.SSStatement;
import smallsql.database.Scrollable;
import smallsql.database.SmallSQLException;
import smallsql.database.SortedResult;
import smallsql.database.TableView;
import smallsql.database.TableViewResult;
import smallsql.database.Where;

class CommandSelect
extends Command {
    private DataSources tables;
    private Expression where;
    RowSource from;
    private Expressions groupBy;
    private Expression having;
    private Expressions orderBy;
    private boolean isAggregateFunction;
    private int maxRows = -1;
    private boolean isDistinct;

    CommandSelect(Logger logger) {
        super(logger);
    }

    CommandSelect(Logger logger, Expressions expressions) {
        super(logger, expressions);
    }

    boolean compile(SSConnection sSConnection) throws Exception {
        Object object;
        int n;
        boolean bl = false;
        if (this.tables != null) {
            for (n = 0; n < this.tables.size(); ++n) {
                object = this.tables.get(n);
                bl |= ((DataSource)object).init(sSConnection);
            }
        }
        if (this.from == null) {
            this.from = new NoFromResult();
            this.tables = new DataSources();
            bl = true;
        }
        if (!bl) {
            return false;
        }
        for (n = 0; n < this.columnExpressions.size(); ++n) {
            object = this.columnExpressions.get(n);
            if (((Expression)object).getAlias() == null) {
                ((Expression)object).setAlias("col" + (n + 1));
            }
            if (((Expression)object).getType() != 2) {
                this.compileLinkExpressionParams((Expression)object);
                continue;
            }
            ExpressionName expressionName = (ExpressionName)object;
            if ("*".equals(expressionName.getName())) {
                TableView tableView;
                DataSource dataSource;
                int n2;
                String string = expressionName.getTableAlias();
                if (string != null) {
                    for (n2 = 0; n2 < this.tables.size(); ++n2) {
                        dataSource = this.tables.get(n2);
                        if (!string.equalsIgnoreCase(dataSource.getAlias())) continue;
                        tableView = dataSource.getTableView();
                        this.columnExpressions.remove(n);
                        n = this.compileAdd_All_Table_Columns(dataSource, tableView, n) - 1;
                        break;
                    }
                    if (n2 != this.tables.size()) continue;
                    throw SmallSQLException.create("SS-0404", new Object[]{string});
                }
                this.columnExpressions.remove(n);
                for (n2 = 0; n2 < this.tables.size(); ++n2) {
                    dataSource = this.tables.get(n2);
                    tableView = dataSource.getTableView();
                    n = this.compileAdd_All_Table_Columns(dataSource, tableView, n);
                }
                --n;
                continue;
            }
            this.compileLinkExpressionName(expressionName);
        }
        if (this.where != null) {
            this.compileLinkExpression(this.where);
        }
        if (this.having != null) {
            this.compileLinkExpression(this.having);
        }
        if (this.orderBy != null) {
            for (n = 0; n < this.orderBy.size(); ++n) {
                this.compileLinkExpression(this.orderBy.get(n));
            }
        }
        if (this.groupBy != null) {
            for (n = 0; n < this.groupBy.size(); ++n) {
                this.compileLinkExpression(this.groupBy.get(n));
            }
        }
        if (this.from instanceof Join) {
            this.compileJoin((Join)this.from);
        }
        if (this.where != null) {
            this.from = new Where(this.from, this.where);
        }
        if (this.isGroupResult()) {
            this.from = new GroupResult(this, this.from, this.groupBy, this.having, this.orderBy);
            if (this.having != null) {
                this.from = new Where(this.from, this.having);
            }
        }
        if (this.isDistinct) {
            this.from = new Distinct(this.from, this.columnExpressions);
        }
        if (this.orderBy != null) {
            this.from = new SortedResult(this.from, this.orderBy);
        }
        return true;
    }

    final boolean isGroupResult() {
        return this.groupBy != null || this.having != null || this.isAggregateFunction;
    }

    private void compileJoin(Join join) throws Exception {
        if (join.condition != null) {
            this.compileLinkExpressionParams(join.condition);
        }
        if (join.left instanceof Join) {
            this.compileJoin((Join)join.left);
        }
        if (join.right instanceof Join) {
            this.compileJoin((Join)join.right);
        }
    }

    private void compileLinkExpression(Expression expression) throws Exception {
        if (expression.getType() == 2) {
            this.compileLinkExpressionName((ExpressionName)expression);
        } else {
            this.compileLinkExpressionParams(expression);
        }
    }

    private void compileLinkExpressionName(ExpressionName expressionName) throws Exception {
        String string = expressionName.getTableAlias();
        if (string != null) {
            int n;
            for (n = 0; n < this.tables.size(); ++n) {
                DataSource dataSource = this.tables.get(n);
                if (!string.equalsIgnoreCase(dataSource.getAlias())) continue;
                TableView tableView = dataSource.getTableView();
                int n2 = tableView.findColumnIdx(expressionName.getName());
                if (n2 >= 0) {
                    expressionName.setFrom(dataSource, n2, tableView);
                    break;
                }
                throw SmallSQLException.create("SS-0406", new Object[]{expressionName.getName()});
            }
            if (n == this.tables.size()) {
                throw SmallSQLException.create("SS-0404", string);
            }
        } else {
            boolean bl = false;
            for (int i = 0; i < this.tables.size(); ++i) {
                DataSource dataSource = this.tables.get(i);
                TableView tableView = dataSource.getTableView();
                int n = tableView.findColumnIdx(expressionName.getName());
                if (n < 0) continue;
                if (bl) {
                    throw SmallSQLException.create("SS-0408", expressionName.getName());
                }
                bl = true;
                expressionName.setFrom(dataSource, n, tableView);
            }
            if (!bl) {
                throw SmallSQLException.create("SS-0406", expressionName.getName());
            }
        }
        this.compileLinkExpressionParams(expressionName);
    }

    private void compileLinkExpressionParams(Expression expression) throws Exception {
        Expression[] expressionArray = expression.getParams();
        boolean bl = this.isAggregateFunction = this.isAggregateFunction || expression.getType() >= 11;
        if (expressionArray != null) {
            for (int i = 0; i < expressionArray.length; ++i) {
                Expression expression2 = expressionArray[i];
                int n = expression2.getType();
                boolean bl2 = this.isAggregateFunction = this.isAggregateFunction || n >= 11;
                if (n == 2) {
                    this.compileLinkExpressionName((ExpressionName)expression2);
                    continue;
                }
                this.compileLinkExpressionParams(expression2);
            }
        }
        expression.optimize();
    }

    private final int compileAdd_All_Table_Columns(DataSource dataSource, TableView tableView, int n) {
        for (int i = 0; i < tableView.columns.size(); ++i) {
            ExpressionName expressionName = new ExpressionName(tableView.columns.get(i).getName());
            expressionName.setFrom(dataSource, i, tableView);
            this.columnExpressions.add(n++, expressionName);
        }
        return n;
    }

    void executeImpl(SSConnection sSConnection, SSStatement sSStatement) throws Exception {
        this.compile(sSConnection);
        if (!(sSStatement.rsType != 1004 && sSStatement.rsType != 1005 || this.from.isScrollable())) {
            this.from = new Scrollable(this.from);
        }
        this.from.execute();
        this.rs = new SSResultSet(sSStatement, this);
    }

    void beforeFirst() throws Exception {
        this.from.beforeFirst();
    }

    boolean isBeforeFirst() throws SQLException {
        return this.from.isBeforeFirst();
    }

    boolean isFirst() throws SQLException {
        return this.from.isFirst();
    }

    boolean first() throws Exception {
        return this.from.first();
    }

    boolean previous() throws Exception {
        return this.from.previous();
    }

    boolean next() throws Exception {
        if (this.maxRows >= 0 && this.from.getRow() >= this.maxRows) {
            this.from.afterLast();
            return false;
        }
        return this.from.next();
    }

    final boolean last() throws Exception {
        if (this.maxRows >= 0) {
            if (this.maxRows == 0) {
                this.from.beforeFirst();
                return false;
            }
            return this.from.absolute(this.maxRows);
        }
        return this.from.last();
    }

    final void afterLast() throws Exception {
        this.from.afterLast();
    }

    boolean isLast() throws Exception {
        return this.from.isLast();
    }

    boolean isAfterLast() throws Exception {
        return this.from.isAfterLast();
    }

    final boolean absolute(int n) throws Exception {
        return this.from.absolute(n);
    }

    final boolean relative(int n) throws Exception {
        return this.from.relative(n);
    }

    final int getRow() throws Exception {
        int n = this.from.getRow();
        if (this.maxRows >= 0 && n > this.maxRows) {
            return 0;
        }
        return n;
    }

    final void updateRow(SSConnection sSConnection, Expression[] expressionArray) throws SQLException {
        int n = sSConnection.getSavepoint();
        try {
            for (int i = 0; i < this.tables.size(); ++i) {
                TableViewResult tableViewResult = TableViewResult.getTableViewResult(this.tables.get(i));
                TableView tableView = tableViewResult.getTableView();
                Columns columns = tableView.columns;
                int n2 = columns.size();
                Expression[] expressionArray2 = new Expression[n2];
                boolean bl = false;
                for (int j = 0; j < this.columnExpressions.size(); ++j) {
                    Expression expression = expressionArray[j];
                    if (expression == null || expression instanceof ExpressionValue && ((ExpressionValue)expression).isEmpty()) continue;
                    Expression expression2 = this.columnExpressions.get(j);
                    if (!expression2.isDefinitelyWritable()) {
                        throw SmallSQLException.create("SS-0405", new Integer(j));
                    }
                    ExpressionName expressionName = (ExpressionName)expression2;
                    if (tableView != expressionName.getTable()) continue;
                    expressionArray2[expressionName.getColumnIndex()] = expression;
                    bl = true;
                }
                if (!bl) continue;
                tableViewResult.updateRow(expressionArray2);
            }
        }
        catch (Throwable throwable) {
            sSConnection.rollback(n);
            throw SmallSQLException.createFromException(throwable);
        }
        finally {
            if (sSConnection.getAutoCommit()) {
                sSConnection.commit();
            }
        }
    }

    final void insertRow(SSConnection sSConnection, Expression[] expressionArray) throws SQLException {
        if (this.tables.size() > 1) {
            throw SmallSQLException.create("SS-0162");
        }
        if (this.tables.size() == 0) {
            throw SmallSQLException.create("SS-0164");
        }
        int n = sSConnection.getSavepoint();
        try {
            TableViewResult tableViewResult = TableViewResult.getTableViewResult(this.tables.get(0));
            TableView tableView = tableViewResult.getTableView();
            Columns columns = tableView.columns;
            int n2 = columns.size();
            Expression[] expressionArray2 = new Expression[n2];
            if (expressionArray != null) {
                for (int i = 0; i < this.columnExpressions.size(); ++i) {
                    Expression expression = expressionArray[i];
                    if (!(expression == null || expression instanceof ExpressionValue && ((ExpressionValue)expression).isEmpty())) {
                        Expression expression2 = this.columnExpressions.get(i);
                        if (!expression2.isDefinitelyWritable()) {
                            throw SmallSQLException.create("SS-0405", new Integer(i));
                        }
                        ExpressionName expressionName = (ExpressionName)expression2;
                        if (tableView == expressionName.getTable()) {
                            expressionArray2[expressionName.getColumnIndex()] = expression;
                            continue;
                        }
                    }
                    expressionArray2[i] = null;
                }
            }
            tableViewResult.insertRow(expressionArray2);
        }
        catch (Throwable throwable) {
            sSConnection.rollback(n);
            throw SmallSQLException.createFromException(throwable);
        }
        finally {
            if (sSConnection.getAutoCommit()) {
                sSConnection.commit();
            }
        }
    }

    final void deleteRow(SSConnection sSConnection) throws SQLException {
        int n = sSConnection.getSavepoint();
        try {
            if (this.tables.size() > 1) {
                throw SmallSQLException.create("SS-0161");
            }
            if (this.tables.size() == 0) {
                throw SmallSQLException.create("SS-0163");
            }
            TableViewResult.getTableViewResult(this.tables.get(0)).deleteRow();
        }
        catch (Throwable throwable) {
            sSConnection.rollback(n);
            throw SmallSQLException.createFromException(throwable);
        }
        finally {
            if (sSConnection.getAutoCommit()) {
                sSConnection.commit();
            }
        }
    }

    public int findColumn(String string) throws SQLException {
        Expressions expressions = this.columnExpressions;
        for (int i = 0; i < expressions.size(); ++i) {
            if (!string.equalsIgnoreCase(expressions.get(i).getAlias())) continue;
            return i;
        }
        throw SmallSQLException.create("SS-0401", string);
    }

    final void setDistinct(boolean bl) {
        this.isDistinct = bl;
    }

    final void setSource(RowSource rowSource) {
        this.from = rowSource;
    }

    final void setTables(DataSources dataSources) {
        this.tables = dataSources;
    }

    final void setWhere(Expression expression) {
        this.where = expression;
    }

    final void setGroup(Expressions expressions) {
        this.groupBy = expressions;
    }

    final void setHaving(Expression expression) {
        this.having = expression;
    }

    final void setOrder(Expressions expressions) {
        this.orderBy = expressions;
    }

    final void setMaxRows(int n) {
        this.maxRows = n;
    }

    final int getMaxRows() {
        return this.maxRows;
    }
}

