/*
 * Decompiled with CFR 0.152.
 */
package com.inet.designer.sampledatabase;

import com.inet.classloader.LoaderUtils;
import com.inet.classloader.jnlp.BaseUpdateableClassLoader;
import com.inet.designer.sampledatabase.a;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.Executable;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ArchiveFile;
import com.inet.plugin.fs.ResourceFile;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.ZipEntry;
import javax.annotation.SuppressFBWarnings;

@PluginInfo(id="sampledatabase", dependencies="reporting", optionalDependencies="adhoc", version="25.10.198", group="reporting;datasource;samples", icon="com/inet/designer/sampledatabase/sampledb_48.png", flags="designer")
public class SampleDatabaseServerPlugin
implements ServerPlugin {
    public static final String DATA_SOURCE_NAME = "Sample Database";

    public void registerExtension(ServerPluginManager spm) {
    }

    private <T> T a(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction);
    }

    public void init(ServerPluginManager spm) {
        ForkJoinPool.commonPool().execute(() -> this.a(() -> {
            try {
                File file = SampleDatabaseServerPlugin.a(spm);
                ClassLoader classLoader = LoaderUtils.getUpdateableClassLoader();
                if (classLoader instanceof BaseUpdateableClassLoader) {
                    ((BaseUpdateableClassLoader)classLoader).addUrl(IOFunctions.getFileURL((File)new File(file, "smallsql.jar")));
                    DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.createDataSourceConfiguration((String)DATA_SOURCE_NAME, (int)4);
                    dataSourceConfiguration.setUrl("jdbc:smallsql");
                    dataSourceConfiguration.setDriverClassname("smallsql.database.SSDriver");
                    dataSourceConfiguration.addProperty("dbpath", file.toString());
                    dataSourceConfiguration.addProperty("readonly", "true");
                    dataSourceConfiguration.save();
                    spm.runIfPluginLoaded("adhoc", () -> new Executable(){

                        public void execute() {
                            a.a();
                        }
                    });
                }
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error((Throwable)exception);
            }
            return null;
        }));
    }

    public void reset() {
    }

    public void restart() {
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    private static File a(ServerPluginManager serverPluginManager) throws IOException {
        ZipEntry zipEntry;
        ResourceFile resourceFile = serverPluginManager.getPluginDescription("sampledatabase").getLocation();
        ArchiveFile archiveFile = resourceFile.createArchiveFile();
        String string = Objects.requireNonNullElse(System.getProperty("java.io.tmpdir"), "");
        String string2 = System.getProperty("user.name");
        File file = new File(new File(string), "com.inet.designer.sampledatabase-" + string2);
        file.mkdirs();
        while ((zipEntry = archiveFile.getNextEntry()) != null) {
            File file2;
            String string3 = zipEntry.getName();
            if (string3.contains("/") || !string3.endsWith(".sdb") && !string3.endsWith(".lob") && !string3.equals("smallsql.master") && !string3.equals("smallsql.jar") || (file2 = new File(file, string3)).exists() && file2.length() == zipEntry.getSize()) continue;
            InputStream inputStream = archiveFile.getInputStream(zipEntry);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file2);){
                IOFunctions.copyData((InputStream)inputStream, (OutputStream)fileOutputStream);
                file2.setLastModified(System.currentTimeMillis() + 31536000000L);
            }
            catch (IOException iOException) {
                LogManager.getConfigLogger().error((Throwable)iOException);
            }
        }
        archiveFile.close();
        return file;
    }
}

