/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bCJ;
    private int bCD;
    private boolean bCK;
    private Timer bCL;
    private Popup bCM;
    private JLabel bCN;
    private JPanel bCO;
    private boolean bCP;
    private Point bCQ;
    private JComboBox bCR;
    private boolean bCS;
    private boolean bCT;
    private Class bCU;
    private Constructor bCV;
    private Class[] bCW = new Class[]{String.class};
    private Color bCX;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bCY;

    private RealtimeValidationPopup(int promptType) {
        this.bCD = promptType;
        this.bCN = new JLabel();
        this.bCO = new JPanel();
        this.bCO.setOpaque(true);
        this.bCO.add(this.bCN);
        this.bCO.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bCO.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bCL = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bCY == null) {
            return;
        }
        this.bCS = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bCR = surroundingBox;
        }
        this.bCJ = textcomponent;
        this.bCJ.addFocusListener(this);
        this.bCX = this.bCJ.getBackground();
    }

    private void initFormats() {
        this.bCY = null;
        switch (this.bCD % 128) {
            case 6: 
            case 7: {
                this.bCY = this.bCS ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bCY = this.bCS ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bCY = this.bCS ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bCY = this.bCS ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Pq() {
        if (this.bCJ instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bCJ.isEnabled() || !this.bCJ.isShowing() || object.toString().length() == 0 || this.bCJ instanceof JComboBox && ((JComboBox)this.bCJ).isPopupVisible() || (this.bCD % 128 == 6 || this.bCD % 128 == 7) && string.equals("-")) {
            if (!this.bCJ.isEnabled()) {
                this.bCJ.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bCJ.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bCY.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bCT && this.bCU != null) {
                if (this.bCU == Object.class) {
                    this.bCU = String.class;
                }
                this.bCV = this.bCU.getConstructor(this.bCW);
                this.bCV.newInstance(string);
            }
            this.bCK = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bCJ.getLocationOnScreen();
                point.y += this.bCJ.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bCJ.invalidate();
            this.bCJ.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bCY, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bCY.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).On();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bCJ.getLocationOnScreen();
        point.y += this.bCJ.getHeight();
        this.bCK = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bCJ.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bCJ.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bCJ.getLocationOnScreen();
        point.y += this.bCJ.getHeight();
        this.bCK = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bCJ.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bCJ.invalidate();
    }

    private String Pr() {
        Format format = switch (this.bCD) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bCD == 6 || this.bCD == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ee(string);
        this.bCN.setText(string);
        this.bCO.setBackground(color);
        if (!this.bCP) {
            this.bCQ = point;
        } else {
            point = this.bCQ;
        }
        if (this.bCM != null) {
            this.hidePopup();
        }
        this.bCM = PopupFactory.getSharedInstance().getPopup(this.bCJ, this.bCO, point.x, point.y);
        this.bCM.show();
        this.bCP = true;
        if (this.bCL.isRunning()) {
            this.bCL.restart();
        } else {
            this.bCL.start();
        }
    }

    private String ee(String object) {
        object = this.bCK ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bCJ instanceof JPasswordField) {
            return new String(((JPasswordField)this.bCJ).getPassword());
        }
        if (this.bCJ instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bCJ).getText();
            if (this.bCR == null) {
                return string2;
            }
            Object object = this.bCR.getSelectedItem();
            if (this.bCJ != null && this.bCR.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bCJ instanceof JComboBox) {
            return ((JComboBox)this.bCJ).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bCM != null) {
            this.bCM.hide();
        }
        this.bCP = false;
        if (this.bCL.isRunning()) {
            this.bCL.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bCT = checkClassType;
        this.bCU = classtype;
    }

    public void setPromptType(int promptType) {
        this.bCD = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bCJ == null) {
            return;
        }
        if (this.bCJ instanceof JTextField) {
            ((JTextField)this.bCJ).getDocument().removeDocumentListener(this);
        } else if (this.bCJ instanceof JComboBox) {
            ((JComboBox)this.bCJ).removeActionListener(this);
            ((JComboBox)this.bCJ).removePopupMenuListener(this);
        }
        this.bCJ.removeFocusListener(this);
        if (this.bCR != null) {
            this.bCR.removeActionListener(this);
            this.bCR.removePopupMenuListener(this);
        }
        this.bCJ.setBackground(this.bCX);
    }

    public boolean isPopupError() {
        return this.bCK;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Pq();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Pq();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bCY = format;
    }
}

