/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.report.renderer.pdf.l;
import com.inet.report.renderer.pdf.m;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class PDFConfig {
    private static final ConfigValue<Boolean> aUL = new ConfigValue(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS);
    private static final ConfigValue<Boolean> aUM = new ConfigValue(ConfigKey.TAGGED_PDF);
    private boolean aUo = (Boolean)aUL.get();
    private boolean aUN;
    private boolean aUO;
    private boolean aUP = (Boolean)aUM.get();
    private l aUQ;
    private m aUR;

    public boolean isNoTransparency() {
        return this.aUN;
    }

    public void setPdfA(@Nullable l pdfA) {
        this.aUQ = pdfA;
        if (pdfA != null) {
            this.aUo = true;
            if (pdfA == l.aWt) {
                this.aUN = true;
            }
        }
    }

    @Nullable
    public l getPdfA() {
        return this.aUQ;
    }

    public void setPdfUA(@Nullable m pdfUA) {
        this.aUR = pdfUA;
        if (pdfUA != null) {
            this.aUo = true;
            this.aUP = true;
        }
    }

    @Nullable
    public m getPdfUA() {
        return this.aUR;
    }

    public void setLinear(boolean linear) {
        this.aUO = linear;
    }

    public boolean isLinear() {
        return this.aUO;
    }

    public boolean isSignatureEnabled() {
        return false;
    }

    public boolean isReplaceMissingChars() {
        return true;
    }

    public boolean isCompression() {
        return false;
    }

    public boolean isMapAdobeFonts() {
        return true;
    }

    public int getAsianEncodingCodePage() {
        return 932;
    }

    public void setCreateStructure(boolean setStructure) {
        this.aUP = setStructure;
    }

    public boolean isCreateStructure() {
        return this.aUP;
    }

    public boolean isReplaceNotEmbeddedFonts() {
        return this.aUo;
    }

    @Nullable
    public List<String> getListOfPreferredSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SERIF_FONT_LIST.getKey(), ConfigKey.PDF_SERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredSansSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SANSSERIF_FONT_LIST.getKey(), ConfigKey.PDF_SANSSERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredMonospacedFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_MONOSPACED_FONT_LIST.getKey(), ConfigKey.PDF_MONOSPACED_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }
}

