/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.lib.json.Json;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.PreferencesUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.oauth.connection.api.token.OauthAccessTokenManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.af;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.UrlAuthConfig;
import com.inet.report.util.EngineUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public abstract class RelativePathDataFactory
extends BaseDataFactory {
    private static final boolean abm = ServerPluginManager.getInstance().isPluginLoaded("oauth.connection");
    public static final String PATH = "path";
    private URL IR;

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="the file is a directory to search for specific files")
    protected Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog, @Nonnull @Nonnull Function<@Nonnull String, @Nullable String> fileNameFilter) {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        List<String> list = this.getPathNames(ds);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string = list.get(i2);
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) continue;
            for (String string2 : stringArray) {
                String string3 = fileNameFilter.apply(string2);
                if (string3 == null) continue;
                hashMap.put(string3, new TableSourceInfo(catalog, null, string3, 20));
            }
        }
        return hashMap;
    }

    protected List<String> getPathNames(Datasource ds) {
        DataSourceConfiguration dataSourceConfiguration = ds.getDataSourceConfiguration();
        String string = dataSourceConfiguration == null ? "." : dataSourceConfiguration.getProperty(PATH);
        return this.getPathNames(ds, string);
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file used for checks")
    public List<String> getPathNames(@Nonnull Datasource ds, @Nonnull String pathOrFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(pathOrFile);
        if (file.isAbsolute() && file.exists()) {
            arrayList.add(pathOrFile);
        } else {
            Object object;
            block16: {
                if (this.IR == null) {
                    try {
                        object = af.getEngine(ds).getReportFile();
                        if (!((URL)object).getPath().isEmpty()) {
                            this.IR = object;
                        }
                    }
                    catch (ReportException reportException) {
                        BaseUtils.printStackTrace(reportException);
                    }
                }
                if (this.IR != null) {
                    try {
                        object = new URL(this.IR, pathOrFile);
                        if ("file".equals(((URL)object).getProtocol())) {
                            arrayList.add(IOFunctions.getFileName((URL)object));
                            break block16;
                        }
                        arrayList.add(((URL)object).toString());
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    try {
                        object = new URL(pathOrFile);
                        arrayList.add(((URL)object).toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            if (arrayList.size() == 0) {
                arrayList.add(pathOrFile);
                if (EngineUtils.isDesigner()) {
                    object = PreferencesUtils.userRoot().node("/com/inet/designer");
                    Preferences preferences = ((Preferences)object).node("lastOpened");
                    int n2 = ((Preferences)object).node("prefs").getInt("mruSize", 10);
                    for (int i2 = n2 - 1; i2 >= 0; --i2) {
                        File file2;
                        String string;
                        String string2 = preferences.get(String.valueOf(i2), null);
                        if (string2 == null || arrayList.contains(string = new File(file2 = new File(string2).getParentFile(), pathOrFile).getAbsolutePath())) continue;
                        arrayList.add(string);
                    }
                }
            }
        }
        return arrayList;
    }

    @Override
    @Nonnull
    public String getVersion() {
        return "25.10.314";
    }

    @Nullable
    protected String getContentType() {
        return null;
    }

    @Nonnull
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="URL are set from administrator and come not from user input")
    protected URLConnection openConnection(@Nonnull Datasource ds, @Nonnull URL url) throws IOException {
        @Nonnull URLConnection uRLConnection = url.openConnection();
        if (url.getProtocol().startsWith("http")) {
            String string;
            DataSourceConfiguration dataSourceConfiguration = ds.getDataSourceConfiguration();
            if (dataSourceConfiguration != null && !StringFunctions.isEmpty((String)(string = dataSourceConfiguration.getProperty("auth")))) {
                RelativePathDataFactory.a(string, uRLConnection, dataSourceConfiguration);
            }
            if ((string = this.getContentType()) != null) {
                uRLConnection.setRequestProperty("Accept", string);
            }
        }
        return uRLConnection;
    }

    private static void a(@Nonnull String string2, @Nonnull URLConnection uRLConnection, @Nonnull DataSourceConfiguration dataSourceConfiguration) throws IOException {
        UrlAuthConfig urlAuthConfig = (UrlAuthConfig)new Json().fromJson(string2, UrlAuthConfig.class, Json.NULL_MAP);
        switch (urlAuthConfig.getType()) {
            default: {
                break;
            }
            case basic: {
                String string3 = "Basic " + Base64.getEncoder().encodeToString((urlAuthConfig.getUsername() + ":" + urlAuthConfig.getPassword()).getBytes(StandardCharsets.UTF_8));
                uRLConnection.setRequestProperty("Authorization", string3);
                break;
            }
            case bearer: {
                uRLConnection.setRequestProperty("Authorization", "Bearer " + urlAuthConfig.getBearerToken());
                break;
            }
            case oauth: {
                if (!abm) break;
                String string4 = urlAuthConfig.getOauthProvider();
                String string5 = urlAuthConfig.getRefreshToken();
                if (string4 == null || string5 == null) break;
                String string6 = OauthAccessTokenManager.getAccessToken((String)string4, (String)string5, string -> {
                    urlAuthConfig.setRefreshToken((String)string);
                    dataSourceConfiguration.addProperty("auth", new Json().toJson((Object)urlAuthConfig));
                    dataSourceConfiguration.save();
                });
                uRLConnection.setRequestProperty("Authorization", "Bearer " + string6);
            }
        }
    }
}

