/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.list.StringList;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseCore;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseReportData;
import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.TableSource;
import com.inet.report.TablesourceList;
import com.inet.report.bi;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationManager;
import com.inet.report.config.datasource.DataSourceConfigurationXMLFileStore;
import com.inet.report.database.DataFactory;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcConnectionFactory;
import com.inet.report.database.base.DatabaseFactory;
import com.inet.report.database.fetch.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.NodeParser;
import com.inet.report.pool.PoolConnection;
import com.inet.report.pool.PoolManager;
import com.inet.report.util.EngineUtils;
import java.awt.EventQueue;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

@PublicApi
public class Datasource
implements Serializable {
    private static List<DataFactory> lr;
    private static final ConfigValue<Boolean> ls;
    private final Properties lt = new Properties();
    private DataSourceConfiguration lu;
    private transient PoolConnection lv;
    private transient boolean lw;
    private DataFactory lx;
    private final TablesourceList ly = new TablesourceList();
    @Nonnull
    private Engine lz;
    private boolean lA = false;
    private boolean lB = false;
    private boolean lC = true;
    private boolean lD;

    Datasource(String dsDll, String dsHost, String dsSchema, String dsCatalog, String dsUsername, String dsPassword, Engine engine) {
        this(dsDll, engine);
        if (dsHost != null) {
            this.lt.put("datasource_host", dsHost);
        }
        if (dsSchema != null) {
            this.lt.put("datasource_schema", dsSchema);
        }
        if (dsCatalog != null) {
            this.lt.put("datasource_catalog", dsCatalog);
        }
        if (dsUsername != null) {
            this.lt.put("user", dsUsername);
        }
        if (dsPassword != null) {
            this.lt.put("password", dsPassword);
        }
        this.lD = true;
        if (dsHost == null && dsCatalog == null && dsUsername == null && dsPassword == null) {
            return;
        }
        if (EngineUtils.isDesigner()) {
            this.bY();
        }
    }

    Datasource(String dataSourceConfigurationName, @Nonnull Engine engine) {
        this.lz = engine;
        this.setDataSourceConfigurationName(dataSourceConfigurationName);
    }

    @Nonnull
    public String toString() {
        DatabaseTables databaseTables = this.lz.bB.jc();
        int n2 = databaseTables.getDatasourceCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            n3 = i2;
            break;
        }
        return "#" + n3 + " (" + this.getDataSourceConfigurationName() + ")";
    }

    @Nonnull
    Engine getEngine() {
        return this.lz;
    }

    @SuppressFBWarnings(value={"EXTERNAL_CONFIG_CONTROL"}, justification="the catalog must be set")
    public synchronized Connection getConnection() throws ReportException {
        if (!this.hasValidConnection()) {
            block15: {
                Object object;
                if (!this.cc() && !DatabaseUtils.useJdbcDriver(this.lx)) {
                    this.bU();
                    return null;
                }
                Object obj = this.lz.bB.gH();
                if (obj != null) {
                    object = ((bi)obj).jc();
                    int n2 = ((DatabaseTables)object).getDatasourceCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Datasource datasource = ((DatabaseTables)object).getDatasource(i2);
                        if (datasource.lv == null || !this.equals(datasource) || !datasource.hasValidConnection()) continue;
                        this.lv = datasource.lv;
                        datasource.lw = true;
                        this.lv.incUseCount();
                    }
                }
                if (this.lv == null) {
                    if (this.lu == null) {
                        object = null;
                        object = this.getDataSourceConfigurationName();
                        if (object != null && ((String)object).length() > 0) {
                            this.a((String)object, this.lD);
                            if (this.lu == null) {
                                throw ReportExceptionFactory.createReportException(ReportErrorCode.dscNotDefined, object);
                            }
                        }
                        if (this.lu == null) {
                            throw new ReportException("No connection created for datasource: " + String.valueOf(this), 0);
                        }
                    }
                    this.lv = this.bV();
                    this.lv.incUseCount();
                }
                try {
                    if (this.getCatalog().length() > 0 && !this.getCatalog().equals(this.lv.getCatalog())) {
                        this.lv.setCatalog(this.getCatalog());
                    }
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isParanoid()) {
                        BaseUtils.paranoid("[Datasource#" + this.cb() + "] set catalog to " + this.getCatalog() + " failed.");
                    }
                    if (!BaseUtils.isParanoid()) break block15;
                    BaseUtils.paranoid(throwable);
                }
            }
            if (this.lC) {
                this.bW();
            }
            this.bS();
        } else {
            this.lv.incUseCount();
        }
        return this.lv;
    }

    private void bS() {
        try {
            if (this.lu == null || this.lu.getIdentifierQuoteString() == null || this.lu.getIdentifierQuoteString().length() == 0) {
                ((Database)this.lx).scanIdentifierQuoteString(this);
                BaseUtils.info("IdentifierQuoteString: >" + this.lx.getConfiguration().getIdentifierQuoteString() + "<");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Properties bT() {
        String string;
        String string2;
        Properties properties = new Properties();
        String[] stringArray = this.lu.getDriverSpecificProperties();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            string2 = stringArray[i2];
            string = this.lu.getProperty(string2);
            properties.put(string2, string);
        }
        String string3 = this.getUsername();
        if (string3 != null && !string3.isEmpty()) {
            properties.put("user", string3);
        }
        if ((string2 = this.getPassword()) != null && !string2.isEmpty()) {
            properties.put("password", string2);
        }
        if ((string = this.getCatalog()) != null && string.length() > 0) {
            properties.put("catalog", string);
        }
        return properties;
    }

    private void bU() throws ReportException {
        String string;
        if (!((Boolean)ls.get()).booleanValue() && !DataSourceConfigurationManager.exists(string = this.getDataSourceConfigurationName())) {
            if (this.lu != null && this.lu.getScope() == -1) {
                return;
            }
            if (this.lx instanceof DatabaseReportData || this.lx instanceof DatabaseCore) {
                return;
            }
            throw ReportExceptionFactory.createReportException(ReportErrorCode.AccessDeniedUnknownDatasource, string);
        }
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="admin configured SQL")
    private PoolConnection bV() throws ReportException {
        if (EventQueue.isDispatchThread()) {
            BaseUtils.printStackTrace(new Throwable("WARNING: connecting to the DB on the event dispatch thread!"));
        }
        this.lz.cq();
        this.bU();
        try {
            String string;
            Map.Entry<Object, Object> entry;
            if (this.lx instanceof JdbcConnectionFactory) {
                Connection connection = ((JdbcConnectionFactory)((Object)this.lx)).getConnection(this);
                return new PoolConnection(connection);
            }
            String string2 = this.getUrl();
            Properties properties = this.bT();
            string2 = Datasource.a(string2, properties, this);
            Object object = properties.entrySet().iterator();
            while (object.hasNext()) {
                entry = object.next();
                string = (String)entry.getValue();
                if (string != null && !string.isEmpty()) continue;
                object.remove();
            }
            BaseUtils.info("try connection: " + this.lu.getConfigurationName() + " / " + string2);
            properties.remove("initSQL");
            object = PoolManager.getDefault().getConnection(this.lu.getDriverClassname(), string2, properties);
            if (BaseUtils.isInfo()) {
                BaseUtils.info("creating connection:" + String.valueOf(object) + " for engine: " + this.lz.bB.gz);
            }
            entry = this.lu.getProperty("initSQL");
            string = "initSQL";
            if (((String)((Object)entry)).isEmpty()) {
                entry = this.lu.getValidationQuery();
                string = "validationQuery";
            }
            if (entry != null && !((String)((Object)entry)).isEmpty()) {
                try {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("executing " + string + " command: " + (String)((Object)entry));
                    }
                    ((PoolConnection)object).createStatement().execute((String)((Object)entry));
                }
                catch (SQLException sQLException) {
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("executing " + string + " failed");
                        BaseUtils.debug(sQLException);
                    }
                    ((PoolConnection)object).closeNativeConnection();
                    object = this.bV();
                }
            }
            return object;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    private static String a(String object, Properties properties, Datasource datasource) {
        int n2 = 0;
        while (((String)object).indexOf(123, n2) != -1) {
            int n3;
            int n4;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. " + (String)object);
            }
            if ((n4 = ((String)object).indexOf(123, n2)) > (n3 = ((String)object).indexOf(125, n2))) break;
            String string = ((String)object).substring(n4 + 1, n3);
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                try {
                    int n5 = Integer.parseInt(string);
                    switch (n5) {
                        case 0: {
                            string2 = datasource.getHost();
                            break;
                        }
                        case 1: {
                            string2 = datasource.getCatalog();
                            break;
                        }
                        case 2: {
                            string2 = datasource.getUsername();
                            break;
                        }
                        case 3: {
                            string2 = datasource.getPassword();
                            break;
                        }
                        case 4: {
                            string2 = datasource.getSchema();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("[DataSourceConfiguration] adapt driver URL. replace \"{" + string + "}\" with \"" + string2 + "\"");
                }
                properties.remove(string);
                object = ((String)object).substring(0, n4) + string2 + ((String)object).substring(n3 + 1, ((String)object).length());
                continue;
            }
            n2 = n3 + 1;
        }
        return object;
    }

    public void closeConnection() {
        if (this.lw) {
            return;
        }
        PoolConnection poolConnection = this.lv;
        this.lv = null;
        if (poolConnection != null) {
            poolConnection.closeAll();
        }
    }

    public boolean hasValidConnection() {
        if (this.lv != null) {
            if (this.lv.isClosed()) {
                this.lv = null;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setConnection(@Nonnull Connection newConnection) {
        block4: {
            try {
                if (this.hasValidConnection() && this.lv != newConnection && this.lv.unwrap(Connection.class) != newConnection) {
                    this.lv.close();
                }
            }
            catch (SQLException sQLException) {
                if (!BaseUtils.isDebug()) break block4;
                BaseUtils.debug(sQLException);
            }
        }
        this.lv = newConnection instanceof PoolConnection ? (PoolConnection)newConnection : new PoolConnection(newConnection);
        this.lv.incUseCount();
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "] Used connection " + String.valueOf(this.lv) + "  is valid:" + this.hasValidConnection());
        }
        this.bW();
        this.bS();
    }

    private void bW() {
        Database database = DatabaseFactory.getInstance().createDatabaseClass(this.lv);
        if (this.lx == null || database != null && this.lx.getClass() != database.getClass()) {
            this.lx = database;
            DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
            if (dataSourceConfiguration != null) {
                this.lx.setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
        }
        this.lC = false;
    }

    public String getCatalog() {
        String string = this.lt.getProperty("datasource_catalog", "");
        if (string.length() == 0 && this.lu != null && (string = this.lu.getProperty("datasource_catalog")).length() == 0) {
            string = this.lu.getCatalog();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setCatalog(String dsCatalog) {
        this.u(dsCatalog);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setCatalog " + this.getCatalog());
        }
        this.lA = true;
    }

    void u(String string) {
        if (string == null) {
            string = "";
        }
        this.lt.put("datasource_catalog", string);
    }

    public DataSourceConfiguration getDataSourceConfiguration() {
        if (DataSourceConfigurationManager.exists(this.getDataSourceConfigurationName())) {
            return DataSourceConfigurationManager.getDataSourceConfiguration(this.getDataSourceConfigurationName(), 3);
        }
        return this.lu;
    }

    @Nonnull
    public String getDataSourceConfigurationName() {
        String string;
        if (this.lu != null && !(string = this.lu.getConfigurationName()).isEmpty()) {
            return string;
        }
        return this.lt.getProperty("datasource_name", "");
    }

    @Deprecated
    void v(String string) {
        if (string == null) {
            string = "";
        }
        String string2 = this.getUsername();
        String string3 = this.getPassword();
        this.a(string, true);
        this.setUsername(string2);
        this.setPassword(string3);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setDll " + string);
        }
    }

    public String getHost() {
        return this.lt.getProperty("datasource_host", "");
    }

    public void setHost(String dsHost) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setHost " + dsHost);
        }
        if (dsHost == null) {
            dsHost = "";
        }
        this.lt.put("datasource_host", dsHost);
    }

    public String getPassword() {
        String string;
        String string2 = this.lt.getProperty("password");
        if (string2 == null && this.getEngine() != null && (string = this.getEngine().getMetaProperties().getProperty("designer." + this.getDataSourceConfigurationName())) != null) {
            string2 = this.w(string);
        }
        if (string2 == null && this.lu != null) {
            return this.lu.getPassword();
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    @SuppressFBWarnings(value={"CIPHER_INTEGRITY", "HARD_CODE_KEY", "ECB_MODE"}, justification="leagacy code")
    private String w(String string) {
        if (string.startsWith("N")) {
            return string.substring(1);
        }
        try {
            byte[] byArray = Datasource.x(string.substring(1));
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKeySpec secretKeySpec = new SecretKeySpec("KEY_DATA_SOURCE_".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            return new String(cipher.doFinal(byArray));
        }
        catch (Exception exception) {
            if (BaseUtils.isDebug()) {
                BaseUtils.debug(exception);
            }
            return null;
        }
    }

    private static byte[] x(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length(); i2 += 2) {
            byte by2;
            String string2 = string.substring(i2, i2 + 2);
            byArray[i2 / 2] = by2 = (byte)(Integer.parseInt(string2, 16) - 128);
        }
        return byArray;
    }

    public void setPassword(String dsPassword) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setPassword *****");
        }
        if (dsPassword == null) {
            this.lt.remove("password");
        } else {
            this.lt.put("password", dsPassword);
        }
    }

    public String getSchema() {
        if (this.lB) {
            return this.lt.getProperty("datasource_schema", "");
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration.getProperty("datasource_schema");
        }
        return this.lt.getProperty("datasource_schema", "");
    }

    public void setSchema(String dsSchema) {
        this.y(dsSchema);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setSchema" + this.getSchema());
        }
        this.lB = true;
    }

    void y(String string) {
        if (string == null) {
            string = "";
        }
        this.lt.put("datasource_schema", string);
    }

    public String getUsername() {
        String string = this.lt.getProperty("user");
        if (string == null && this.lu != null) {
            return this.lu.getUser();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUsername(String dsUsername) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setUserName " + dsUsername);
        }
        if (dsUsername == null) {
            this.lt.remove("user");
        } else {
            this.lt.put("user", dsUsername);
        }
    }

    void b(TableSource tableSource) {
        if (this.ly.contains(tableSource)) {
            return;
        }
        tableSource.setDatasource(this);
        this.ly.addWithRefreshEvent(tableSource);
    }

    public TableSource getTableSource(int idx) {
        return (TableSource)this.ly.get(idx);
    }

    public String getUrl() {
        String string = this.lt.getProperty("datasource_url");
        if (string == null && this.lu != null) {
            return this.lu.getUrl();
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setUrl(String dsUrl) {
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "]setUrl " + dsUrl);
        }
        if (dsUrl == null) {
            dsUrl = "";
        }
        this.lt.put("datasource_url", dsUrl);
    }

    public TableSource getTableSource(String alias) throws ReportException {
        TableSource tableSource = this.getTableSourceIfExist(alias);
        if (tableSource == null) {
            throw new ReportException("There is no table source defined with alias \"" + alias + "\"", -1058);
        }
        return tableSource;
    }

    public TableSource getTableSourceIfExist(String alias) {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            if (!tableSource.toString().equals(alias)) continue;
            return tableSource;
        }
        return null;
    }

    public String[] getAliasList() {
        StringList stringList = new StringList(this.getTableSourceCount());
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            TableSource tableSource = this.getTableSource(i2);
            stringList.addElement(tableSource.getAlias());
        }
        return stringList.toArray();
    }

    public boolean containsOnlyTables() {
        for (int i2 = 0; i2 < this.getTableSourceCount(); ++i2) {
            try {
                if (this.getTableSource(i2).getType() == 1) continue;
                return false;
            }
            catch (ReportException reportException) {
                return false;
            }
        }
        return true;
    }

    public void removeTableSource(TableSource ts) throws ReportException {
        this.c(ts);
        this.ly.removeWithRefreshEvent(ts);
    }

    public TableSource removeTableSourceAt(int idx) throws ReportException {
        TableSource tableSource = (TableSource)this.ly.get(idx);
        this.removeTableSource(tableSource);
        return tableSource;
    }

    void a(TableSource tableSource, Datasource datasource) {
        this.ly.removeWithRefreshEvent(tableSource);
        datasource.b(tableSource);
    }

    private void c(TableSource tableSource) throws ReportException {
        NodeParser nodeParser;
        int n2;
        int n3;
        Fields fields = this.lz.bB.getFields();
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.canRemoveColumn(tableSource.getColumnName(n3));
        }
        for (n3 = 0; n3 < tableSource.getColumnCount(); ++n3) {
            tableSource.removeColumn(tableSource.getColumnName(n3));
        }
        List<Join> list = this.lz.bB.jc().bN();
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            nodeParser = list.get(n2);
            if (((Join)nodeParser).getSourceTableSource() != tableSource && ((Join)nodeParser).getTargetTableSource() != tableSource) continue;
            list.remove(n2);
        }
        for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
            nodeParser = fields.getPromptField(n2);
            if (((PromptField)nodeParser).za != tableSource) continue;
            ((PromptField)nodeParser).yZ = null;
            ((Field)nodeParser).removeReferenceHolder(tableSource);
            ((PromptField)nodeParser).za = null;
            if (((Field)nodeParser).getRealReferenceCount() != 0) continue;
            fields.removePromptField(n2);
            --n2;
        }
        for (n2 = 0; n2 < fields.getDatabaseFieldsCount(); ++n2) {
            nodeParser = fields.getDatabaseField(n2);
            if (((DatabaseField)nodeParser).kU != tableSource) continue;
            fields.removeDatabaseField(n2);
            --n2;
        }
        tableSource.resetReferences();
        this.lz.bB.getFields().a((Field)null, 3);
    }

    public int getTableSourceCount() {
        return this.ly.size();
    }

    public DataFactory getDataFactory() {
        return this.k(true);
    }

    DataFactory k(boolean bl2) {
        if (bl2) {
            try {
                Connection connection;
                if (this.lz.cD() == 2 && this.cc() && (connection = this.getConnection()) != null) {
                    connection.close();
                }
            }
            catch (ReportException reportException) {
            }
            catch (SQLException sQLException) {
                BaseUtils.printStackTrace(sQLException);
            }
        }
        if (this.lx == null) {
            this.lx = new Database();
        }
        return this.lx;
    }

    public void setDataFactory(DataFactory newFactory) {
        this.lx = newFactory;
        this.lC = false;
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Datasource#" + this.cb() + "] used DataFactory " + String.valueOf(newFactory));
        }
    }

    TablesourceList bX() {
        return this.ly;
    }

    void d(StringBuilder stringBuilder, int n2) {
        if (this.lu != null || this.ly.size() > 0 || this.getDataSourceConfigurationName().length() > 0) {
            this.bY();
            stringBuilder.append(BaseUtils.getIndent(n2));
            stringBuilder.append("<").append("Datasource").append(">\n").append("\n");
            ++n2;
            if (this.lu != null && this.lz.bB.getReportProperties().isSaveDatasource()) {
                DataSourceConfigurationXMLFileStore.saveToReportXMLFile(this.lu, stringBuilder, n2);
            } else {
                String string = this.getDataSourceConfigurationName();
                if (string.length() > 0) {
                    stringBuilder.append(BaseUtils.getIndent(n2));
                    stringBuilder.append("<").append("DataSourceConfiguration").append(k.l("name", string)).append(">\n").append("\n");
                    stringBuilder.append(BaseUtils.getIndent(n2));
                    stringBuilder.append("<").append("/").append("DataSourceConfiguration").append(">\n").append("\n");
                }
            }
            for (int i2 = 0; i2 < this.ly.size(); ++i2) {
                ((TableSource)this.ly.get(i2)).d(stringBuilder, n2);
            }
            stringBuilder.append(BaseUtils.getIndent(--n2));
            stringBuilder.append("<").append("/").append("Datasource").append(">\n").append("\n");
        }
    }

    void bY() {
        block33: {
            if (!this.lD || this.lu == null) {
                return;
            }
            String string = Datasource.z(this.getHost());
            String string2 = this.getCatalog();
            String string3 = this.getUsername();
            String string4 = this.getPassword();
            boolean bl2 = this.lz.bB.jc().isSavePassword();
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = this.getDataSourceConfigurationName();
            if ("pdsodbc.dll".equals(string5)) {
                stringBuilder.append(string);
                if (string3.length() > 0) {
                    stringBuilder.append('(').append(Datasource.z(string3)).append(')');
                }
            } else if ("pdssql.dll".equals(string5)) {
                stringBuilder.append("MS SQL(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.z(string2)).append(',');
                stringBuilder.append(Datasource.z(string3)).append(')');
            } else if ("pdsora7.dll".equals(string5)) {
                stringBuilder.append("Oracle(");
                stringBuilder.append(string).append(',');
                stringBuilder.append(Datasource.z(string3)).append(')');
            } else if ("core.dll".equals(string5)) {
                stringBuilder.append("Core");
            } else {
                if (string5.endsWith(".dll")) {
                    string5 = string5.substring(0, string5.length() - 4);
                    string5 = Datasource.z(string5);
                }
                stringBuilder.append(string5).append('(');
                stringBuilder.append(string).append(',');
                stringBuilder.append(string2).append(',');
                stringBuilder.append(string3).append(')');
            }
            if (stringBuilder.length() > 80) {
                stringBuilder.setLength(80);
            }
            String string6 = stringBuilder.toString();
            try {
                DataSourceConfiguration dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string6, 3);
                if (dataSourceConfiguration == null) {
                    dataSourceConfiguration = DataSourceConfigurationManager.createDataSourceConfiguration(string6, 4);
                    dataSourceConfiguration.addProperties(this.lu.getProperties());
                    Properties properties = this.bT();
                    String string7 = this.getUrl();
                    String string8 = this.lu.getDriverClassname();
                    if ("sun.jdbc.odbc.JdbcOdbcDriver".equals(string8) && "jdbc:odbc:{0}".equals(string7)) {
                        string7 = "jdbc:odbc:{datasource}";
                        dataSourceConfiguration.addProperty("datasource", string);
                    } else if ("com.inet.tds.TdsDriver".equals(string8) && "jdbc:inetdae7:{0}?database={1}".equals(string7)) {
                        string7 = "jdbc:inetdae7";
                        dataSourceConfiguration.addProperty("host", string);
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("com.inet.ora.OraDriver".equals(string8) && "jdbc:inetora:{0}".equals(string7)) {
                        string7 = "jdbc:inetora";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("sid", stringTokenizer.nextToken());
                        }
                    } else if ("com.mysql.jdbc.Driver".equals(string8) && "jdbc:mysql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:mysql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else if ("org.postgresql.Driver".equals(string8) && "jdbc:postgresql://{0}/{1}".equals(string7)) {
                        string7 = "jdbc:postgresql://{host}:{port}/{database}";
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("host", stringTokenizer.nextToken());
                        }
                        if (stringTokenizer.hasMoreTokens()) {
                            dataSourceConfiguration.addProperty("port", stringTokenizer.nextToken());
                        }
                        dataSourceConfiguration.addProperty("database", string2);
                    } else {
                        string7 = Datasource.a(string7, properties, this);
                    }
                    dataSourceConfiguration.setUrl(string7);
                    dataSourceConfiguration.setCatalog(string2);
                    dataSourceConfiguration.setUser(string3);
                    dataSourceConfiguration.setPassword(string4);
                    dataSourceConfiguration.setSavePassword(bl2);
                    dataSourceConfiguration.save();
                }
                boolean bl3 = this.lC;
                this.a(dataSourceConfiguration, false);
                this.lC = bl3;
                this.lD = false;
                if (!bl2) {
                    this.setPassword(string4);
                }
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isWarning()) break block33;
                BaseUtils.warning(throwable);
            }
        }
    }

    private static String z(String string) {
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public TableSource createTableSource(String databaseIdentifier, String aliasName) throws ReportException {
        if (aliasName == null) {
            return this.createTableSource(databaseIdentifier);
        }
        TableSource tableSource = new TableSource(databaseIdentifier, aliasName, this.lz, this);
        if (this.ly.contains(tableSource)) {
            return this.getTableSource(aliasName);
        }
        this.b(tableSource);
        return tableSource;
    }

    public TableSource createTableSourceCommand(String aliasName, String sql) throws ReportException {
        return this.createTableSourceCommand(aliasName, sql, true);
    }

    public TableSource createTableSourceCommand(String aliasName, String sql, boolean quoteStringPrompts) throws ReportException {
        if (this.lz.bB.jc().s(aliasName)) {
            throw new ReportException("There already exists a TableSource with the alias name >" + aliasName + "<", 1111);
        }
        TableSource tableSource = new TableSource(aliasName, aliasName, this.lz, this);
        tableSource.setSql(sql);
        tableSource.setQuoteStringPrompts(quoteStringPrompts);
        tableSource.setDatasource(this);
        try {
            tableSource.refresh();
        }
        catch (ReportException reportException) {
            tableSource.resetReferences();
            throw reportException;
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        this.b(tableSource);
        return tableSource;
    }

    @Nonnull
    public TableSource createTableSource(String databaseIdentifier) throws ReportException {
        String string = this.lz.bB.jc().a(databaseIdentifier, this.getDataFactory());
        if (DatabaseUtils.useJdbcDriver(this.lx)) {
            return this.createTableSource(databaseIdentifier, string);
        }
        TableSource tableSource = new TableSource(this.lz, this);
        tableSource.setDatabaseIdentifierName(databaseIdentifier);
        tableSource.at(string);
        if (this.ly.contains(tableSource)) {
            return this.getTableSource(string);
        }
        this.b(tableSource);
        return tableSource;
    }

    TableSource m(String string, String string2) {
        TableSource tableSource;
        try {
            tableSource = this.getTableSource(string2);
            if (tableSource != null) {
                return tableSource;
            }
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        tableSource = new TableSource(this.lz, this);
        tableSource.av(string);
        tableSource.at(string2);
        this.b(tableSource);
        return tableSource;
    }

    boolean bZ() {
        if (this.lB) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_schema").length() > 0;
    }

    boolean ca() {
        if (this.lA) {
            return true;
        }
        DataSourceConfiguration dataSourceConfiguration = this.getDataSourceConfiguration();
        return dataSourceConfiguration != null && dataSourceConfiguration.getProperty("datasource_catalog").length() > 0;
    }

    public List<String> getSql(boolean keepPromptNames) throws ReportException, SQLException {
        return new b(this.lz.bM()).aA(keepPromptNames).h(this);
    }

    int cb() {
        DatabaseTables databaseTables = this.lz.bB.jc();
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (databaseTables.getDatasource(i2) != this) continue;
            return i2;
        }
        return 0;
    }

    boolean cc() {
        if (this.lx == null) {
            this.lC = true;
        }
        return this.lC;
    }

    public void addConnectionProperty(String property, String value) {
        this.lt.put(property, value);
    }

    public void removeConnectionProperty(String property) {
        this.lt.remove(property);
    }

    public Properties getConnectionProperties() {
        return (Properties)this.lt.clone();
    }

    public void setDataSourceConfigurationName(String dataSourceConfigurationName) {
        this.a(dataSourceConfigurationName, false);
    }

    private void a(String string, boolean bl2) {
        if (string == null) {
            string = "";
        }
        if (DataSourceConfigurationManager.exists(string)) {
            this.a(DataSourceConfigurationManager.getDataSourceConfiguration(string, 3), bl2);
        } else {
            this.lu = null;
        }
        this.lt.put("datasource_name", string);
    }

    public void setDataSourceConfiguration(DataSourceConfiguration dsc) {
        this.a(dsc, false);
    }

    private void a(DataSourceConfiguration dataSourceConfiguration, boolean bl2) {
        block13: {
            String string;
            block12: {
                if (!bl2) {
                    this.lD = false;
                    this.lA = false;
                    this.lB = false;
                    this.lt.clear();
                }
                string = dataSourceConfiguration.getDatabaseClassname();
                String string2 = dataSourceConfiguration.getDriverClassname();
                try {
                    if (string2 != null && string2.trim().length() > 0) {
                        LoaderUtils.classForName((String)string2, (Object)this);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ClassNotFoundException && throwable.getMessage() != null && throwable.getMessage().endsWith("com.inet.designer.layout.jdbc.LayoutDriver")) break block12;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug("load Driver class from DataSourceConfiguration failed.");
                    }
                    if (!BaseUtils.isDebug()) break block12;
                    BaseUtils.debug(throwable);
                }
            }
            try {
                this.lx = null;
                this.lC = true;
                if (string.length() > 0) {
                    if (lr == null) {
                        lr = ServerPluginManager.getInstance().get(DataFactory.class);
                    }
                    for (DataFactory dataFactory : lr) {
                        if (!dataFactory.getClass().getName().equals(string)) continue;
                        this.lx = dataFactory;
                        this.lC = false;
                        break;
                    }
                    if (this.lx == null) {
                        Class clazz = LoaderUtils.classForName((String)string, (Object)this);
                        this.lx = (DataFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        this.lC = false;
                    }
                }
                if (this.lC) {
                    this.lx = new Database();
                }
                this.lx.setConfiguration(dataSourceConfiguration.getDatabaseConfiguration());
            }
            catch (Throwable throwable) {
                if (!BaseUtils.isDebug()) break block13;
                BaseUtils.debug("load Database class from DataSourceConfiguration failed.");
                BaseUtils.debug(throwable);
            }
        }
        this.lu = dataSourceConfiguration;
    }

    void l(boolean bl2) {
        this.lA = bl2;
    }

    void m(boolean bl2) {
        this.lB = bl2;
    }

    public boolean isUsed() throws ReportException {
        for (TableSource tableSource : this.ly) {
            if (!tableSource.isUsed()) continue;
            return true;
        }
        Fields fields = this.getEngine().getFields();
        for (int i2 = 0; i2 < fields.getSQLExpressionFieldsCount(); ++i2) {
            SQLField sQLField = fields.getSQLExpressionField(i2);
            if (sQLField.getDatasource() != this) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datasource datasource = (Datasource)obj;
        if (this.lt.equals(datasource.lt)) {
            if (this.lu == null) {
                return datasource.lu == null;
            }
            return this.lu.equals(datasource.lu);
        }
        return false;
    }

    static {
        ls = new ConfigValue(ConfigKey.PERMISSION_ALLOW_UNKNOWN_DATASOURCE);
    }
}

