/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.annotations.InternalApi;
import com.inet.font.layout.FontContext;
import com.inet.font.layout.FontLayout;
import com.inet.lib.util.ColorUtils;
import com.inet.report.BaseUtils;
import com.inet.report.renderer.doc.Adornment;
import com.inet.report.renderer.doc.CellAdornment;
import com.inet.report.renderer.html.HtmlDocumentWriter;
import com.inet.report.renderer.html.HtmlUtils;
import com.inet.report.renderer.html.b;
import com.inet.report.renderer.html.c;
import com.inet.report.renderer.html.k;
import com.inet.report.renderer.html.l;
import com.inet.shared.utils.MemoryStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class HtmlStyleWriter {
    private static final byte[] aLI = BaseUtils.getBytes("pt");
    private static final String[] aLJ = new String[]{"none", "solid", "double", "dashed", "dotted"};
    private static final String[] aLK = new String[]{"none", "left", "center", "right", "justify"};

    private static void a(int n2, int n3, int n4, int n5, int n6, MemoryStream memoryStream) {
        if (n2 != 0 && n2 < aLJ.length) {
            HtmlStyleWriter.a("border-left-style", aLJ[n2], memoryStream);
        }
        if (n3 != 0 && n3 < aLJ.length) {
            HtmlStyleWriter.a("border-right-style", aLJ[n3], memoryStream);
        }
        if (n4 != 0 && n4 < aLJ.length) {
            HtmlStyleWriter.a("border-top-style", aLJ[n4], memoryStream);
        }
        if (n5 != 0 && n5 < aLJ.length) {
            HtmlStyleWriter.a("border-bottom-style", aLJ[n5], memoryStream);
        }
        if (n6 != -1) {
            String string = HtmlStyleWriter.fL(n6);
            HtmlStyleWriter.a("background-color", string, memoryStream);
        }
    }

    public static void writeAllAdornmentAttributes(Adornment adornment, MemoryStream stream) {
        Object object;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        int n6 = adornment.getLeftStyle();
        int n7 = adornment.getRightStyle();
        int n8 = adornment.getTopStyle();
        int n9 = adornment.getBottomStyle();
        int n10 = adornment.getBackColor();
        HtmlStyleWriter.a(n6, n7, n8, n9, n10, stream);
        int n11 = adornment.getBorderColor();
        HtmlStyleWriter.a(adornment.getBorderColor(), "border-color", stream);
        boolean bl3 = bl2 = n6 == n8 && n8 == n7 && n7 == n9;
        if (!bl2 || n6 != 0) {
            n5 = adornment.getLineWidth();
            n4 = HtmlUtils.getBorderWidth(n5, 1);
            n3 = HtmlUtils.twipsToPixel(n4);
            HtmlStyleWriter.a("border-width", n3, true, stream, true);
            if (n6 == 2) {
                HtmlStyleWriter.a("border-left-width", n3 * 3, true, stream, true);
            }
            if (n7 == 2) {
                HtmlStyleWriter.a("border-right-width", n3 * 3, true, stream, true);
            }
            if (n8 == 2) {
                HtmlStyleWriter.a("border-top-width", n3 * 3, true, stream, true);
            }
            if (n9 == 2) {
                HtmlStyleWriter.a("border-bottom-width", n3 * 3, true, stream, true);
            }
        }
        n5 = adornment.getRoundingWidth() / 2;
        n4 = adornment.getRoundingHeight() / 2;
        n3 = adornment.getRoundingPosition();
        if (n3 != 0 && (n5 != 0 || n4 != 0)) {
            if (n5 == n4) {
                n2 = HtmlUtils.twipsToPixel(n5);
                if (n3 == 3) {
                    HtmlStyleWriter.a("-moz-border-radius", n2, true, stream, true);
                    HtmlStyleWriter.a("border-radius", n2, true, stream, true);
                } else {
                    object2 = new int[4];
                    switch (n3) {
                        case 1: {
                            int n12 = n2;
                            object2[1] = n12;
                            object2[0] = n12;
                            break;
                        }
                        case 2: {
                            int n13 = n2;
                            object2[3] = n13;
                            object2[2] = n13;
                        }
                    }
                    HtmlStyleWriter.a("-moz-border-radius", (int[])object2, true, stream, false);
                    HtmlStyleWriter.a("border-radius", (int[])object2, true, stream, false);
                }
            } else {
                n2 = HtmlUtils.twipsToPixel(n5);
                int n14 = HtmlUtils.twipsToPixel(n4);
                if (n3 == 3) {
                    object = new int[]{n2, n14};
                    HtmlStyleWriter.a("-moz-border-radius", (int[])object, true, stream, true);
                    HtmlStyleWriter.a("border-radius", (int[])object, true, stream, true);
                } else {
                    object = new int[4][2];
                    switch (n3) {
                        case 1: {
                            int n15 = n2;
                            object[1][0] = n15;
                            object[0][0] = n15;
                            int n16 = n14;
                            object[1][1] = n16;
                            object[0][1] = n16;
                            break;
                        }
                        case 2: {
                            int n17 = n2;
                            object[3][0] = n17;
                            object[2][0] = n17;
                            int n18 = n14;
                            object[3][1] = n18;
                            object[2][1] = n18;
                        }
                    }
                    HtmlStyleWriter.a("-moz-border-radius", (int[][])object, true, stream);
                    HtmlStyleWriter.a("border-radius", (int[][])object, true, stream);
                }
            }
        }
        if (adornment.isShadow() && !adornment.hasMsoShadows()) {
            n2 = n11;
            object2 = HtmlStyleWriter.fM(n2);
            object = "box-shadow";
            HtmlStyleWriter.a((String)object, 3, 3, 7, -2, (String)object2, adornment.getShadowStyle(), stream);
        }
        n2 = adornment.getLeftPadding();
        int n19 = adornment.getTopPadding();
        int n20 = adornment.getRightPadding();
        int n21 = adornment.getBottomPadding();
        if (n2 == n19 && n19 == n20 && n20 == n21) {
            if (n2 != 0) {
                HtmlStyleWriter.a("padding", n2, true, stream, true);
            }
        } else {
            if (n2 != 0) {
                HtmlStyleWriter.a("padding-left", n2, true, stream, true);
            }
            if (n19 != 0) {
                HtmlStyleWriter.a("padding-top", n19, true, stream, true);
            }
            if (n20 != 0) {
                HtmlStyleWriter.a("padding-right", n20, true, stream, true);
            }
            if (n21 != 0) {
                HtmlStyleWriter.a("padding-bottom", n21, true, stream, true);
            }
        }
    }

    public static void writeAllCellAdornmentAttributes(CellAdornment adornment, MemoryStream stream) {
        int n2 = adornment.getLeftStyle();
        int n3 = adornment.getRightStyle();
        int n4 = adornment.getTopStyle();
        int n5 = adornment.getBottomStyle();
        int n6 = adornment.getBackColor();
        HtmlStyleWriter.a(n2, n3, n4, n5, n6, stream);
        int n7 = adornment.getLeftBorderColor();
        HtmlStyleWriter.a(n7, "border-left-color", stream);
        int n8 = adornment.getTopBorderColor();
        HtmlStyleWriter.a(n8, "border-top-color", stream);
        int n9 = adornment.getRightBorderColor();
        HtmlStyleWriter.a(n9, "border-right-color", stream);
        int n10 = adornment.getBottomBorderColor();
        HtmlStyleWriter.a(n10, "border-bottom-color", stream);
        int n11 = HtmlStyleWriter.fO(adornment.getLeftLineWidth());
        HtmlStyleWriter.a("border-left-width", n11, n2, stream);
        int n12 = HtmlStyleWriter.fO(adornment.getTopLineWidth());
        HtmlStyleWriter.a("border-top-width", n12, n4, stream);
        int n13 = HtmlStyleWriter.fO(adornment.getRightLineWidth());
        HtmlStyleWriter.a("border-right-width", n13, n3, stream);
        int n14 = HtmlStyleWriter.fO(adornment.getBottomLineWidth());
        HtmlStyleWriter.a("border-bottom-width", n14, n5, stream);
        HtmlStyleWriter.a("vertical-align", "top", stream);
    }

    private static void a(String string, int n2, int n3, MemoryStream memoryStream) {
        if (n2 != 0) {
            int n4 = HtmlUtils.twipsToPixel(n2);
            if (n3 == 2) {
                n4 *= 3;
            }
            HtmlStyleWriter.a(string, n4, true, memoryStream, true);
        }
    }

    public static void writeMainSectionPropAsStyle(l prop, MemoryStream stream) {
        int n2 = HtmlUtils.twipsToPixel(prop.getHeight());
        int n3 = HtmlUtils.twipsToPixel(prop.getWidth());
        int n4 = prop.DO();
        HtmlStyleWriter.a("min-height", n2, true, stream, true);
        HtmlStyleWriter.a("width", n3, true, stream, true);
        if (n4 != -1) {
            String string = HtmlStyleWriter.fL(n4);
            HtmlStyleWriter.a("background-color", string, stream);
        }
    }

    public static void writeElementSizeAsStyle(c elemSize, MemoryStream stream) {
        int n2 = elemSize.CM();
        int n3 = elemSize.getWidth();
        int n4 = elemSize.getHeight();
        int n5 = elemSize.CN();
        boolean bl2 = elemSize.CS();
        if (n5 != 0) {
            Object object;
            bl2 = false;
            switch (n5) {
                case 180: {
                    object = "rotate(180deg)";
                    break;
                }
                case 90: 
                case 270: {
                    int n6 = elemSize.CO() + elemSize.CQ();
                    int n7 = elemSize.CP() + elemSize.CR();
                    int n8 = n3 + n6;
                    int n9 = n4 + n7;
                    int n10 = HtmlUtils.twipsToPixel((n8 - n9) / 2);
                    object = "translate(" + n10 + "px," + -n10 + "px)";
                    object = (String)object + " rotate(" + (n5 == 90 ? "-" : "") + "90deg)";
                    int n11 = n4;
                    n4 = n3;
                    n3 = n11;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("rotation on " + n5 + " degrees is not implemented.");
                }
            }
            HtmlStyleWriter.a("transform", (String)object, stream);
        }
        HtmlStyleWriter.a(n2, n3, n4, stream, bl2);
        switch (elemSize.getVerAlign()) {
            case 2: {
                HtmlStyleWriter.a("display", "flex", stream);
                HtmlStyleWriter.a("flex-wrap", "wrap", stream);
                HtmlStyleWriter.a("align-content", "center", stream);
                break;
            }
            case 3: {
                HtmlStyleWriter.a("display", "flex", stream);
                HtmlStyleWriter.a("flex-wrap", "wrap", stream);
                HtmlStyleWriter.a("align-content", "flex-end", stream);
            }
        }
    }

    public static void writePositionAsStyle2(b position, MemoryStream stream) {
        int n2 = position.CL();
        HtmlStyleWriter.e(n2, stream);
    }

    private static void a(String string, String string2, MemoryStream memoryStream) {
        memoryStream.writeASCII(string);
        memoryStream.write(58);
        memoryStream.writeASCII(string2);
        memoryStream.write(59);
        HtmlDocumentWriter.M(memoryStream);
    }

    private static String fL(int n2) {
        int n3 = ColorUtils.getAlpha((int)n2);
        if (n3 == 255) {
            return HtmlStyleWriter.aP(n2, n3);
        }
        return HtmlStyleWriter.aQ(n2, n3);
    }

    private static String aP(int n2, int n3) {
        int n4 = ColorUtils.getBlue((int)n2);
        int n5 = ColorUtils.getGreen((int)n2);
        int n6 = ColorUtils.getRed((int)n2);
        StringBuilder stringBuilder = new StringBuilder(7);
        stringBuilder.append('#');
        if (n3 != 255) {
            HtmlStyleWriter.a(n3, stringBuilder);
        }
        HtmlStyleWriter.a(n6, stringBuilder);
        HtmlStyleWriter.a(n5, stringBuilder);
        HtmlStyleWriter.a(n4, stringBuilder);
        return stringBuilder.toString();
    }

    private static String aQ(int n2, int n3) {
        int n4 = ColorUtils.getBlue((int)n2);
        int n5 = ColorUtils.getGreen((int)n2);
        int n6 = ColorUtils.getRed((int)n2);
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 == 255) {
            stringBuilder.append("rgb(");
        } else {
            stringBuilder.append("rgba(");
        }
        stringBuilder.append(n6);
        stringBuilder.append(',');
        stringBuilder.append(n5);
        stringBuilder.append(',');
        stringBuilder.append(n4);
        if (n3 != 255) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            String string = decimalFormat.format((float)n3 / 255.0f).replaceAll(",", ".");
            stringBuilder.append(',');
            stringBuilder.append(string);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static void a(int n2, StringBuilder stringBuilder) {
        if (n2 > 255) {
            stringBuilder.append("00");
        } else {
            int n3 = n2 >> 4 & 0xF;
            int n4 = n2 & 0xF;
            HtmlStyleWriter.b(n3, stringBuilder);
            HtmlStyleWriter.b(n4, stringBuilder);
        }
    }

    private static void b(int n2, StringBuilder stringBuilder) {
        if (n2 < 10) {
            stringBuilder.append((char)(48 + n2));
        } else {
            stringBuilder.append((char)(n2 + 65 + -10));
        }
    }

    static void a(MemoryStream memoryStream, String string, int n2, int n3, boolean bl2, boolean bl3) {
        memoryStream.writeASCII(string);
        memoryStream.write(58);
        HtmlStyleWriter.a(n2, n3, bl2, memoryStream);
        memoryStream.write(59);
        if (bl3) {
            HtmlDocumentWriter.M(memoryStream);
        }
    }

    static void a(String string, int n2, boolean bl2, MemoryStream memoryStream, boolean bl3) {
        memoryStream.writeASCII(string);
        memoryStream.write(58);
        memoryStream.writeIntAsString(n2);
        if (bl2) {
            memoryStream.write(HtmlUtils.aMM);
        }
        memoryStream.write(59);
        if (bl3) {
            HtmlDocumentWriter.M(memoryStream);
        }
    }

    static void a(String string, int[] nArray, boolean bl2, MemoryStream memoryStream, boolean bl3) {
        memoryStream.writeASCII(string);
        memoryStream.write(58);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (i2 != 0) {
                memoryStream.write(32);
                if (bl3) {
                    memoryStream.write(47);
                }
            }
            memoryStream.writeIntAsString(nArray[i2]);
            if (!bl2) continue;
            memoryStream.write(HtmlUtils.aMM);
        }
        memoryStream.write(59);
        HtmlDocumentWriter.M(memoryStream);
    }

    static void a(String string, int[][] nArray, boolean bl2, MemoryStream memoryStream) {
        int n2;
        memoryStream.writeASCII(string);
        memoryStream.write(58);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 != 0) {
                memoryStream.write(32);
            }
            memoryStream.writeIntAsString(nArray[n2][0]);
            if (!bl2) continue;
            memoryStream.write(HtmlUtils.aMM);
        }
        memoryStream.write(32);
        memoryStream.write(47);
        memoryStream.write(32);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n2 != 0) {
                memoryStream.write(32);
            }
            memoryStream.writeIntAsString(nArray[n2][1]);
            if (!bl2) continue;
            memoryStream.write(HtmlUtils.aMM);
        }
        memoryStream.write(59);
        HtmlDocumentWriter.M(memoryStream);
    }

    private static void a(int n2, int n3, boolean bl2, MemoryStream memoryStream) {
        double d2 = bl2 ? 15.0 : 20.0;
        double d3 = (double)n2 / d2;
        boolean bl3 = true;
        memoryStream.writeDoubleAsString(d3, n3, bl3);
        byte[] byArray = bl2 ? HtmlUtils.aMM : aLI;
        memoryStream.write(byArray);
    }

    static void a(MemoryStream memoryStream, String string, double d2) {
        memoryStream.write(BaseUtils.getBytes(string));
        memoryStream.write(58);
        int n2 = (int)(d2 * 100.0);
        memoryStream.writeIntAsString(n2);
        memoryStream.write(37);
        memoryStream.write(59);
        HtmlDocumentWriter.M(memoryStream);
    }

    private static void a(String string, int n2, int n3, int n4, int n5, String string2, int n6, MemoryStream memoryStream) {
        switch (n6) {
            case 2: {
                n2 = -n2;
                break;
            }
            case 3: {
                n2 = -n2;
                n3 = -n3;
                break;
            }
            case 4: {
                n3 = -n3;
            }
        }
        memoryStream.write(BaseUtils.getBytes(string));
        memoryStream.write(58);
        HtmlStyleWriter.a(n2, n3, n4, string2, memoryStream);
        memoryStream.write(59);
        HtmlDocumentWriter.M(memoryStream);
    }

    private static String fM(int n2) {
        int n3 = ColorUtils.getAlpha((int)n2);
        int n4 = ColorUtils.getBlue((int)n2);
        int n5 = ColorUtils.getGreen((int)n2);
        int n6 = ColorUtils.getRed((int)n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rgba(");
        stringBuilder.append(String.valueOf(n6));
        stringBuilder.append(',');
        stringBuilder.append(String.valueOf(n5));
        stringBuilder.append(',');
        stringBuilder.append(String.valueOf(n4));
        stringBuilder.append(',');
        float f2 = (float)n3 / 255.0f;
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(2);
        String string = numberFormat.format(f2);
        stringBuilder.append(String.valueOf(string));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static String fN(int n2) {
        int n3 = ColorUtils.getBlue((int)n2);
        int n4 = ColorUtils.getGreen((int)n2);
        int n5 = ColorUtils.getRed((int)n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("rgb(");
        stringBuilder.append(String.valueOf(n5));
        stringBuilder.append(',');
        stringBuilder.append(String.valueOf(n4));
        stringBuilder.append(',');
        stringBuilder.append(String.valueOf(n3));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static void writeParagaraphPropertyAsStyle(k pp, MemoryStream stream) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = pp.getFirstLineIndent();
        if (n6 != 0) {
            n5 = HtmlUtils.twipsToPixel(n6);
            HtmlStyleWriter.a("text-indent", n5, true, stream, true);
        }
        if ((n5 = pp.getLeftIndent()) != 0) {
            n4 = HtmlUtils.twipsToPixel(n5);
            HtmlStyleWriter.a("padding-left", n4, true, stream, true);
        }
        if ((n4 = pp.getRightIndent()) != 0) {
            n3 = HtmlUtils.twipsToPixel(n4);
            HtmlStyleWriter.a("padding-right", n3, true, stream, true);
        }
        n3 = pp.DN();
        String string = "line-height";
        switch (n3) {
            case 2: {
                n2 = pp.getLineSpacingAbsolute();
                int n7 = HtmlUtils.twipsToPixel(n2);
                HtmlStyleWriter.a(string, n7, true, stream, true);
                break;
            }
            case 1: {
                double d2 = pp.getLineSpacingRelative();
                if (Math.round(d2) != 1L) {
                    d2 = pp.getLineSpacingRelative() * 1.2;
                }
                HtmlStyleWriter.a(stream, string, d2);
            }
        }
        n2 = pp.DM();
        if (n2 != 0) {
            HtmlStyleWriter.a("text-align", aLK[n2], stream);
        }
    }

    public static void writeTextPropertyAsStyle(FontContext fc, MemoryStream pageStream) {
        FontLayout fontLayout = fc.getFontLayout();
        String string = fontLayout.getName();
        HtmlStyleWriter.a("font-family", string, pageStream);
        int n2 = fontLayout.getSizeTwips();
        int n3 = 1;
        boolean bl2 = false;
        HtmlStyleWriter.a(pageStream, "font-size", n2, n3, bl2, true);
        if (fc.isBold()) {
            HtmlStyleWriter.a("font-weight", "bold", pageStream);
        }
        if (fc.isItalic()) {
            HtmlStyleWriter.a("font-style", "italic", pageStream);
        }
        if (fc.isUnderline()) {
            if (fc.isStrikethrough()) {
                HtmlStyleWriter.a("text-decoration", "underline line-through", pageStream);
            } else {
                HtmlStyleWriter.a("text-decoration", "underline", pageStream);
            }
        } else if (fc.isStrikethrough()) {
            HtmlStyleWriter.a("text-decoration", "line-through", pageStream);
        }
        int n4 = fc.getColor();
        HtmlStyleWriter.a("color", HtmlStyleWriter.fN(n4), pageStream);
    }

    static void a(int n2, int n3, int n4, MemoryStream memoryStream, boolean bl2) {
        HtmlStyleWriter.a("margin-left", HtmlUtils.twipsToPixel(n2), true, memoryStream, true);
        HtmlStyleWriter.a("width", HtmlUtils.twipsToPixel(n3), true, memoryStream, true);
        HtmlStyleWriter.a(n4, memoryStream, bl2);
    }

    static void e(int n2, MemoryStream memoryStream) {
        int n3 = HtmlUtils.twipsToPixel(n2);
        HtmlStyleWriter.a("margin-top", n3, true, memoryStream, true);
    }

    private static void a(int n2, String string, MemoryStream memoryStream) {
        if (n2 != -1) {
            String string2 = HtmlStyleWriter.fL(n2);
            HtmlStyleWriter.a(string, string2, memoryStream);
        } else {
            HtmlStyleWriter.a(string, "transparent", memoryStream);
        }
    }

    public static void writeHeightAsStyle(int heightTwips, MemoryStream stream, boolean canGrow) {
        int n2 = HtmlUtils.twipsToPixel(heightTwips);
        HtmlStyleWriter.a("height", n2, true, stream, true);
    }

    private static int fO(int n2) {
        if (n2 != 0 && n2 < 15) {
            n2 = 15;
        }
        return n2;
    }

    public static void writeGlyphPropertyAsStyle(int width, int height, int glyphRotation, MemoryStream stream) {
        stream.writeASCII("display:inline-block;");
        HtmlDocumentWriter.M(stream);
        HtmlStyleWriter.a("width", HtmlUtils.twipsToPixel(width), true, stream, true);
        HtmlStyleWriter.a("height", HtmlUtils.twipsToPixel(height), true, stream, true);
        String string = switch (glyphRotation) {
            case 90 -> "(-90deg)";
            case 180 -> "(180deg)";
            case -90, 270 -> "(90deg)";
            default -> null;
        };
        if (string != null) {
            HtmlStyleWriter.a("transform", "rotate" + string, stream);
        }
        stream.writeASCII("text-align:center;");
    }

    private static void a(int n2, int n3, int n4, String string, MemoryStream memoryStream) {
        memoryStream.write(32);
        memoryStream.writeIntAsString(n2);
        memoryStream.write(HtmlUtils.aMM);
        memoryStream.write(32);
        memoryStream.writeIntAsString(n3);
        memoryStream.write(HtmlUtils.aMM);
        memoryStream.write(32);
        memoryStream.writeIntAsString(n4);
        memoryStream.write(HtmlUtils.aMM);
        memoryStream.write(32);
        memoryStream.writeASCII(string);
    }

    static void a(int n2, MemoryStream memoryStream, boolean bl2) {
        if (bl2) {
            HtmlStyleWriter.a("min-height", HtmlUtils.twipsToPixel(n2), true, memoryStream, true);
        } else {
            HtmlStyleWriter.a("height", HtmlUtils.twipsToPixel(n2), true, memoryStream, true);
            HtmlStyleWriter.a("overflow", "hidden", memoryStream);
        }
    }

    public static void writeClassID(@Nullable String mainSelector, @Nonnull String subSelector, @Nonnull MemoryStream pageStream) {
        HtmlStyleWriter.writeClassID(null, mainSelector, subSelector, pageStream);
    }

    public static void writeClassID(@Nullable String typeSelector, @Nullable String mainSelector, @Nonnull String subSelector, @Nonnull MemoryStream pageStream) {
        HtmlDocumentWriter.M(pageStream);
        if (typeSelector != null) {
            pageStream.writeASCII(typeSelector);
        }
        if (mainSelector != null) {
            pageStream.write(46);
            pageStream.writeASCII(mainSelector);
        }
        pageStream.write(46);
        pageStream.writeASCII(subSelector);
        pageStream.write(123);
        HtmlDocumentWriter.M(pageStream);
    }
}

