/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.BaseAxis;
import com.inet.report.chart.axis.NumberRange;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DiscreteNumberAxis
extends BaseAxis {
    private NumberRange WW = new NumberRange();
    private Double D;
    private FormulaField WX;
    private Integer WY;
    private FormulaField WZ;

    public NumberRange getRange() {
        return this.WW;
    }

    public void setRange(NumberRange range) {
        if (range == null) {
            throw i.d("range");
        }
        this.WW = range;
    }

    public Double getStepWidth() {
        return this.D;
    }

    public void setStepWidth(Double stepWidth) {
        if (stepWidth != null && stepWidth < 0.0) {
            throw new IllegalArgumentException("Parameter 'stepWidth' less than 0.");
        }
        this.D = stepWidth;
    }

    public Integer getNumberOfDivisions() {
        return this.WY;
    }

    public void setNumberOfDivisions(Integer numberOfDivisions) {
        if (numberOfDivisions != null && numberOfDivisions.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Parameter 'numberOfDivisions' less or equal 0.");
        }
        this.WY = numberOfDivisions;
    }

    @Override
    protected StringBuilder cs(int n2) {
        StringBuilder stringBuilder = super.cs(n2);
        this.getRange().saveProperties(stringBuilder, n2);
        if (this.WY != null) {
            f.b(stringBuilder, n2, "NumberOfDivisions", this.WY.toString());
        }
        if (this.D != null) {
            f.b(stringBuilder, n2, "StepWidth", this.D.toString());
        }
        if (this.WZ != null) {
            j.a(stringBuilder, n2, this.WZ, "chartAxisNumberOfDivisions");
        }
        if (this.WX != null) {
            j.a(stringBuilder, n2, this.WX, "chartAxisStepsize");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        Object object;
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Number number;
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            object = (Element)nodeList.item(i2);
            if (object.getNodeName().equals("RangeNumber")) {
                this.getRange().readProperties((Element)object);
                continue;
            }
            if (object.getNodeName().equals("NumberOfDivisions")) {
                string = object.getAttribute("value");
                if (string.length() <= 0 || (number = Integer.valueOf(string)) == null || !(((Integer)number).doubleValue() >= 0.0)) continue;
                this.setNumberOfDivisions((Integer)number);
                continue;
            }
            if (!object.getNodeName().equals("StepWidth") || (string = object.getAttribute("value")).length() <= 0 || (number = Double.valueOf(string)) == null || !((Double)number >= 0.0)) continue;
            this.setStepWidth((Double)number);
        }
        FormulaField formulaField = j.a(nodeList, chart, "chartAxisNumberOfDivisions");
        if (formulaField != null) {
            this.setNumberOfDivisionsFormula(formulaField);
            chart.updateReferences();
        }
        if ((object = j.a(nodeList, chart, "chartAxisStepsize")) != null) {
            this.setStepWidthFormula((FormulaField)object);
            chart.updateReferences();
        }
    }

    public FormulaField getNumberOfDivisionsFormula() {
        return this.WZ;
    }

    public void setNumberOfDivisionsFormula(FormulaField numberOfDivisionsFormula) {
        if (this.WZ != null) {
            this.WZ.resetReferences();
        }
        this.WZ = numberOfDivisionsFormula;
    }

    public FormulaField getStepWidthFormula() {
        return this.WX;
    }

    public void setStepWidthFormula(FormulaField stepWidthFormula) {
        if (this.WX != null) {
            this.WX.resetReferences();
        }
        this.WX = stepWidthFormula;
    }

    @Override
    public List<Object> getReferencedObjects() {
        List<Object> list = super.getReferencedObjects();
        if (this.WX != null) {
            list.add(this.WX);
        }
        if (this.WZ != null) {
            list.add(this.WZ);
        }
        return list;
    }
}

