/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.error.HasErrorCode;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.PromptRequestWarning;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.by;
import com.inet.report.cache.Cache;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.report.util.b;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

@PublicApi
public class EngineRenderData
implements RenderData {
    private final Properties hj = new Properties();
    private Properties hm;
    private final Hashtable oL = new Hashtable();
    private String url = null;
    private boolean hq;
    protected boolean isRefresh = true;
    private String hn;
    private int hp = 1;
    private PropertiesChecker oM;
    private ZipOutputStream oN;
    private a oO;

    public EngineRenderData(String props) {
        by.kE();
        this.setReportLocation(props);
        this.oM = new PropertiesChecker(){

            @Override
            public void checkProperties(Properties prop, Object req) throws ReportException {
            }

            @Override
            public void checkProperties(Engine engine, Properties prop, Object req) throws ReportException {
            }
        };
    }

    @Override
    public void setReportLocation(String location) {
        this.hj.clear();
        this.hj.put("export_fmt", "java");
        by.b(location, this.hj, false);
        try {
            ReportKeyFactory.decodeProps(this.hj);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = location;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    public void clearEngineCache() {
        this.oL.clear();
    }

    protected Engine createEngine(Properties props) throws ReportException {
        Engine engine = new Engine(props.getProperty("export_fmt"));
        this.setEngineParams(engine, props);
        return engine;
    }

    protected String getKey(Properties props) throws ReportException {
        if (this.isRefresh && this.isPromptOnRefresh()) {
            this.isRefresh = false;
            props.put("promptonrefresh", "1");
        } else {
            props.put("promptonrefresh", "0");
        }
        this.oM.checkProperties(props, null);
        return ReportKeyFactory.a(props).toString();
    }

    protected Engine getEngine(String key) {
        return (Engine)this.oL.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine checkEngine(Properties props) throws ReportException {
        Hashtable hashtable = this.oL;
        synchronized (hashtable) {
            boolean bl2 = this.isRefresh;
            String string = this.getKey(props);
            Engine engine = (Engine)this.oL.get(string);
            if (engine != null) {
                return engine;
            }
            BaseUtils.info("new engine: " + string);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("props: " + String.valueOf(props));
            }
            engine = this.createEngine(props);
            if (bl2) {
                by.j(engine).gN().deleteCacheReportKey();
            }
            engine.execute();
            this.oL.put(string, engine);
            return engine;
        }
    }

    protected Engine setEngineParams(Engine engine, Properties props) {
        return this.setEngineParams(engine, props, false);
    }

    protected Engine setEngineParams(Engine engine, Properties props, boolean rdc) {
        try {
            props = (Properties)props.clone();
            by.a(null, engine, props, this.oM, null, rdc);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ReportException && ((ReportException)throwable).getErrorCode() == ReportErrorCode.FeatureForbidden.getErrorCodeNumber()) {
                throw this.a(throwable, props);
            }
            BaseUtils.printStackTrace(throwable);
            try {
                if (engine.getArea(0) == null) {
                    throw this.a(throwable, props);
                }
            }
            catch (ReportException reportException) {
                BaseUtils.printStackTrace(reportException);
            }
            Properties properties = new Properties();
            for (String string : props.keySet()) {
                if (string.startsWith("prompt") && !string.equalsIgnoreCase("promptonrefresh")) continue;
                properties.put(string, props.get(string));
            }
            try {
                engine.getArea(0);
                by.a(null, engine, properties, this.oM, null, true);
            }
            catch (Throwable throwable2) {
                BaseUtils.printStackTrace(throwable2);
                throw this.a("Could not set engine properties, please check URL.\n" + throwable2.getMessage(), throwable2, props);
            }
        }
        return engine;
    }

    public void setPropertiesChecker(PropertiesChecker propChecker) {
        if (propChecker == null) {
            throw new IllegalArgumentException();
        }
        this.oM = propChecker;
    }

    public PropertiesChecker getPropertiesChecker() {
        return this.oM;
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hj);
            return engine.getPageData(page);
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hj);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hj);
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hj);
        }
    }

    @Override
    public boolean isPageLimitExceeded() throws ViewerException {
        try {
            Engine engine = this.getEngine(this.getKey(this.hj));
            return engine != null && engine.isPageLimitExceeded();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hj);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string;
            Engine engine = this.checkEngine(this.hm);
            switch (string = this.hm.getProperty("export_fmt")) {
                case "svg": {
                    if (this.hp == 0) {
                        ++this.hp;
                        String string2 = this.hm.getProperty("file");
                        string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                        int n2 = SVGUtils.getAutoRefresh(this.hm);
                        return SVGUtils.getSvgViewerPackage(engine.nQ.getPageCount(), true, string2, n2);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    RenderDataUtils.writeFileData(byteArrayOutputStream, this.hp + ".svg", engine.getPageData(this.hp++));
                    return byteArrayOutputStream.toByteArray();
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    if (this.oO == null) break;
                    int n3 = engine.getPageCount();
                    while (this.oO.cH() == 0 && this.hp <= n3) {
                        ZipEntry zipEntry = new ZipEntry(this.hp + "." + string);
                        this.oN.putNextEntry(zipEntry);
                        this.oN.write(engine.getPageData(this.hp++));
                        this.oN.closeEntry();
                    }
                    if (this.hp > n3 && this.oN != null) {
                        this.oN.close();
                        this.oN = null;
                    }
                    return this.oO.cI();
                }
            }
            if (this.hp > 0) {
                return engine.getPageData(this.hp++);
            }
            if (this.hp == 0) {
                ++this.hp;
                return engine.getGroupTree();
            }
            ++this.hp;
            if (string.startsWith("htm")) {
                String string3 = this.hm.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hm);
        }
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        try {
            this.hm = by.a(this.hj, expProps);
            Engine engine = this.checkEngine(this.hm);
            String string = expProps.getProperty("export_fmt");
            Objects.requireNonNull(string);
            switch (string) {
                case "svg": {
                    this.hp = 0;
                    return engine.getPageCount() + 1;
                }
                case "htm": 
                case "htm.zip": 
                case "html": {
                    this.hp = -1;
                    return engine.getPageCount() + 2;
                }
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "bmp": {
                    int n2 = engine.getPageCount();
                    if (n2 > 1) {
                        this.hp = 1;
                        this.oO = new a();
                        this.oN = new ZipOutputStream(new BufferedOutputStream(this.oO, 4096));
                        return 0;
                    }
                    this.oO = null;
                }
            }
            this.hp = 1;
            return engine.getPageCount();
        }
        catch (Throwable throwable) {
            throw this.a(throwable, this.hm);
        }
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        try {
            Engine engine = this.checkEngine(this.hj);
            return engine.getGroupTree();
        }
        catch (Exception exception) {
            throw this.a(exception, this.hj);
        }
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        this.isRefresh = true;
        this.oL.clear();
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.hj.remove(key);
        } else {
            this.hj.setProperty(key, value);
        }
    }

    @Override
    public final String getReportProperty(String key) {
        return this.hj.getProperty(key);
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hq = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hq;
    }

    private ViewerException a(Throwable throwable, Properties properties) {
        return this.a(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable), throwable, properties);
    }

    private ViewerException a(String string, Throwable throwable, Properties properties) {
        int n2;
        if (throwable instanceof PromptRequestWarning) {
            Prompt[] promptArray = ((PromptRequestWarning)throwable).getPrompts();
            PromptData[] promptDataArray = new PromptData[promptArray.length];
            for (int i2 = 0; i2 < promptArray.length; ++i2) {
                Prompt prompt = promptArray[i2];
                promptDataArray[i2] = promptArray[i2].isNotUsed() ? new PromptData(true) : new PromptData(prompt.getName(), prompt.getDisplayName(), prompt.getSubreportName(), prompt.getPromptText(), prompt.getDefaultValues(), prompt.getDescs(), prompt.getValueTypeNewProt(), prompt.isDiscrete(), prompt.isRange(), prompt.isMulti(), prompt.isEditable(), prompt.isOnlyDescs(), prompt.isInformixPrompt(), prompt.getEditMask(), prompt.getMinValue(), prompt.getMaxValue());
                promptDataArray[i2].setCascadingParent(prompt.getCascadingParent());
            }
            return new ViewerException(promptDataArray);
        }
        if (throwable instanceof ViewerException) {
            return (ViewerException)throwable;
        }
        int n3 = 0;
        Cache cache = Cache.getCache();
        int n4 = n2 = cache != null ? cache.getType() : -1;
        if (throwable instanceof HasErrorCode) {
            n3 = ((HasErrorCode)throwable).getErrorCode();
        }
        return new ViewerException(n3, string, properties.getProperty("export_fmt"), Engine.getVersion(), System.getProperty("java.version", "") + "; " + System.getProperty("java.vm.name", "") + "; " + System.getProperty("java.vendor"), System.getProperty("os.name", "") + " " + System.getProperty("os.version", ""), n2, "2.1", throwable, b.getSupportEmail());
    }

    @Override
    public void setReportTitle(String title) {
        this.hn = title;
    }

    @Override
    public String getReportTitle() {
        return this.hn;
    }

    @Override
    public RenderData getCopy() {
        EngineRenderData engineRenderData = new EngineRenderData(this.url);
        engineRenderData.getProperties().putAll((Map<?, ?>)this.getProperties());
        engineRenderData.isRefresh = this.isRefresh;
        return engineRenderData;
    }

    @Override
    public Properties getProperties() {
        return this.hj;
    }

    @Override
    public void stop() {
        Enumeration enumeration = this.oL.elements();
        while (enumeration.hasMoreElements()) {
            Engine engine = (Engine)enumeration.nextElement();
            if (engine == null) continue;
            engine.stop("API call EngineRenderData.stop()");
        }
        this.oL.clear();
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.hj);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            Engine engine = this.checkEngine(this.hj);
            return engine.getFontData(fontID);
        }
        catch (ReportException reportException) {
            return e.getErrorData(reportException, this.hj);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        throw new ViewerException("resetting does not work for EngineRenderData. You should not see this error.");
    }

    private static class a
    extends OutputStream {
        private final ArrayList<byte[]> oQ = new ArrayList();

        private a() {
        }

        @Override
        public void write(int b2) throws IOException {
            this.oQ.add(new byte[]{(byte)b2});
        }

        @Override
        public void write(byte[] b2, int off, int len) throws IOException {
            byte[] byArray = new byte[len];
            System.arraycopy(b2, off, byArray, 0, len);
            this.oQ.add(byArray);
        }

        int cH() {
            return this.oQ.size();
        }

        byte[] cI() {
            if (this.oQ.size() > 0) {
                return this.oQ.remove(0);
            }
            return null;
        }
    }
}

