/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Field;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.SimpleResultSet;
import java.sql.Connection;
import java.sql.ResultSet;

public class DatabaseDB2
extends Database {
    @Override
    public String getAddOp() {
        return " concat ";
    }

    @Override
    public String sqlConcat(Object leftOperant, Object rightOperant) {
        if (leftOperant instanceof String || rightOperant instanceof String) {
            return String.valueOf(leftOperant) + " concat " + String.valueOf(rightOperant);
        }
        return super.sqlConcat(leftOperant, rightOperant);
    }

    @Override
    public String convertToString(String parameter) {
        return "char(" + parameter + ")";
    }

    @Override
    public String convertToInt(String parameter) {
        return "int( " + parameter + ")";
    }

    @Override
    public String convertToDouble(String parameter) {
        return "double( " + parameter + ")";
    }

    @Override
    public String convertToDate(String date) throws ReportException {
        return "date( " + date + " )";
    }

    @Override
    public String convertToDate(String year, String month, String day) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToTime(String time) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) {
        return "timestamp(char(" + year + ") concat '-' concat char(" + month + ") concat '-' concat char(" + day + ") concat '-' concat char(" + hour + ") concat '.' concat char(" + minute + ") concat '.' concat char(" + sec + "))";
    }

    @Override
    public int getMaxAliasNameLength() {
        return 128;
    }

    @Override
    protected void findColumnLabels(TableSource ts) {
        block15: {
            try (Connection connection = ts.getDatasource().getConnection();){
                if (ts.getType() != 1) {
                    return;
                }
                String string = ts.getDatabaseIdentifier();
                String string2 = "";
                if (string.indexOf(46) != -1) {
                    string2 = string.substring(0, string.indexOf(46));
                    string = string.substring(string.lastIndexOf(46) + 1, string.length());
                }
                if (string2.length() == 0) {
                    string2 = ts.getDatasource().getUsername();
                }
                ResultSet resultSet = DatabaseUtils.executeQuery(connection.createStatement(), "SELECT TABNAME,COLNAME,REMARKS FROM SYSCAT.COLUMNS WHERE TABNAME =  '" + string + "'", null);
                SimpleResultSet simpleResultSet = new SimpleResultSet(resultSet);
                if (BaseUtils.isDebug()) {
                    BaseUtils.debug("search column labels TABNAME\t\tCOLUMN_NAME\t\tCOMMENTS");
                }
                while (simpleResultSet.next()) {
                    DatabaseField databaseField;
                    if (BaseUtils.isDebug()) {
                        BaseUtils.debug(simpleResultSet.getString(1) + "\t\t" + simpleResultSet.getString(2) + "\t\t" + simpleResultSet.getString(3));
                    }
                    if ((databaseField = ts.getDatabaseField(simpleResultSet.getString(2))) == null) continue;
                    databaseField.setColumnLabel(simpleResultSet.getString(3));
                }
            }
            catch (Exception exception) {
                if (!BaseUtils.isDebug()) break block15;
                BaseUtils.debug(exception);
            }
        }
    }

    @Override
    protected String getColumnName(String colName, String alias, int driverVersion, TableSource ts, int colIdx) {
        if (driverVersion >= 4 && !StringFunctions.isEmpty((String)alias)) {
            return alias;
        }
        return colName;
    }

    @Override
    public String toSQL92(String function, Field field) throws ReportException {
        if ("DAYOFMONTH".equals(function)) {
            function = "DAY";
        }
        return super.toSQL92(function, field);
    }
}

