/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.exportwebui;

import com.inet.http.ClientMessageException;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.remote.gui.angular.filechooser.FileSystemService;
import com.inet.report.BaseUtils;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.exportwebui.SaveExportOnServerRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nonnull;

public class c
extends ServiceMethod<SaveExportOnServerRequest, Void> {
    public Void a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, SaveExportOnServerRequest saveExportOnServerRequest) throws IOException {
        Properties properties = saveExportOnServerRequest.getParameters();
        String string = saveExportOnServerRequest.getSaveTarget();
        Cache cache = Cache.getCache();
        try {
            ReportCacheKey reportCacheKey = cache.createKey(properties, Cache.getPropertiesChecker(), httpServletRequest);
            Throwable throwable = cache.getFailureCause(reportCacheKey);
            if (throwable != null) {
                throw throwable;
            }
            for (FileSystemService fileSystemService : ServerPluginManager.getInstance().get(FileSystemService.class)) {
                if (!fileSystemService.isResponsible(string)) continue;
                URL uRL = IOFunctions.getURLFromString((String)string);
                try (OutputStream outputStream = fileSystemService.getOutputStream(uRL);){
                    int n2 = cache.getPageCountAndWait(reportCacheKey, 3000);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        byte[] byArray = cache.getPageAndWait(reportCacheKey, i2 + 1, 1000);
                        outputStream.write(byArray);
                    }
                }
                return null;
            }
            throw new ClientMessageException("Not supported export target: " + string);
        }
        catch (ClientMessageException | AccessDeniedException throwable) {
            throw throwable;
        }
        catch (Throwable throwable) {
            BaseUtils.error(throwable);
            throw new ClientMessageException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable));
        }
    }

    public String getMethodName() {
        return "reportexport.saveonserver";
    }

    public short getMethodType() {
        return 1;
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (SaveExportOnServerRequest)object);
    }
}

