(function(){

    clearreportsApp.run( [ '$rootScope', 'driveModel', 'driveFactory', 'actionservice', function( $rootScope, driveModel, driveFactory, actionservice ) {

        var renderEntry = function( entry ){
            var driveURL = driveFactory.getEntryURL( entry.id );
            var roothref = $('base').attr("roothref");
            var fileName = (entry.pluginMetaData || {}).REPORTNAMEBASE + '.html'; // replace
            var url = roothref + 'htmzipviewer/' + btoa( driveURL ) + '/' + encodeURIComponent( fileName );
            var newWin = window.open( url, '_blank');
            return newWin;  
        }

        var checkEnabledSingle = function( entry ) {
            return entry.type == "CONTENT" && ((entry.pluginMetaData || {}).REPORTISVALIDHTML) == "true";
        };
    
        var actionPDFViewer = {
            key: "handler.reports.html.zip",
            icon: "icon-cr-render",
            name: $rootScope.getMsg("reporting.drive.htmlzip.action.render"),
            single:{
                tooltip: "",
                action: function( entry ){
                    var newWin = renderEntry( entry );
                    if (newWin != undefined) {
                        newWin.focus();
                    }
                },
                checkEnabled: checkEnabledSingle,
            },
            multi:{
                tooltip: function(){
                    return $rootScope.getMsg("reporting.drive.htmlzip.action");
                },
                action: function(){
                    var entries = driveModel.getSelectedEntries();
                    var newWin;
                    for( var i=0; i<entries.length; i++ ) {
                        newWin = renderEntry( entries[i] );
                        if (newWin != undefined) {
                            newWin.focus();
                        }
                    }
                },
                checkEnabled: function(){ 
                    if( driveModel.selectedIDs.size == 0 ) {
                        return false;
                    }
                    var entries = driveModel.getSelectedEntries();
                    for( var i=0; i<entries.length; i++ ) {
                        var entry =  entries[i];
                        if ( !checkEnabledSingle( entry ) ) {
                            return false;
                        }
                    }
                    return true;
                },
            },
        }
        actionservice.registerAction( actionPDFViewer, actionservice.ACTION_TYPE.MIME );

    } ] );

})();
