/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula.parser;

import com.inet.report.ReportException;
import com.inet.report.formula.FormulaException;
import com.inet.report.formula.parser.Token;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FormulaParserException
extends FormulaException
implements Iterable<ReportException> {
    private Token aow;
    private boolean aox = false;
    private ArrayList<ReportException> aoy;
    private String aoz;

    private FormulaParserException(String msg, int messageId, Token token, boolean insertMarker) {
        super(msg + (String)(token != null ? " Line:" + (token.getRow() + 1) + " Column:" + (token.tn() + 1) : ""), messageId);
        this.aow = token;
        this.aox = insertMarker;
        this.aoz = msg;
    }

    public static FormulaParserException create(ReportErrorCode reportErrorCode, boolean insertMarker, Token token, Object ... msgParameter) {
        String string = Msg.getMsg(reportErrorCode.name(), msgParameter);
        int n2 = reportErrorCode.getErrorCodeNumber();
        return new FormulaParserException(string, n2, token, insertMarker);
    }

    public static FormulaParserException create(ReportException e2, Token errorToken) {
        if (e2 instanceof FormulaParserException) {
            FormulaParserException formulaParserException = (FormulaParserException)e2;
            if (formulaParserException.getToken() == null) {
                FormulaParserException formulaParserException2 = new FormulaParserException(formulaParserException.aoz, formulaParserException.getErrorCode(), errorToken, formulaParserException.aox);
                formulaParserException2.initCause(e2);
                e2 = formulaParserException2;
            }
            return (FormulaParserException)e2;
        }
        if (e2.getErrorCode() == 0) {
            return FormulaParserException.create(e2.getMessage(), false, errorToken, 0);
        }
        return FormulaParserException.create(e2.getMessage(), false, errorToken, e2.getErrorCode());
    }

    public static FormulaParserException create(String message, boolean insertMarker, Token token, int id) {
        if (token != null) {
            message = (String)message + " Token:" + token.to() + " Line:" + token.getRow() + " Col:" + token.tn() + " starts at char nr.:" + token.cb();
        }
        return new FormulaParserException((String)message, id, token, insertMarker);
    }

    public void addRecoverableException(ReportException exception) {
        if (exception != null) {
            if (this.aoy == null) {
                this.aoy = new ArrayList();
            }
            this.aoy.add(exception);
        }
    }

    public void addRecoverableExceptionList(List<ReportException> exceptionList) {
        if (exceptionList != null && exceptionList.size() > 0) {
            if (this.aoy == null) {
                this.aoy = new ArrayList();
            }
            this.aoy.addAll(exceptionList);
        }
    }

    public int countInnerExceptions() {
        if (this.aoy != null) {
            return this.aoy.size();
        }
        return 0;
    }

    @Override
    public Iterator<ReportException> iterator() {
        if (this.aoy != null) {
            return this.aoy.iterator();
        }
        return new ArrayList().iterator();
    }

    public Token getToken() {
        return this.aow;
    }

    public void setToken(Token token) {
        this.aow = token;
    }

    @Override
    public int getRow() {
        if (this.aow != null) {
            return this.aow.getPosition().getLine();
        }
        return super.getRow();
    }

    @Override
    public int getColumn() {
        if (this.aow != null) {
            return this.aow.getPosition().getColumn();
        }
        return super.getColumn();
    }

    @Override
    public int getEndRow() {
        if (this.aow != null) {
            if (this.aox) {
                return this.aow.getRow();
            }
            return this.aow.getPosition().rj();
        }
        return super.getEndRow();
    }

    @Override
    public int getEndColumn() {
        if (this.aow != null) {
            if (this.aox) {
                return this.aow.tn();
            }
            return this.aow.getPosition().getEndColumn();
        }
        return super.getEndColumn();
    }

    @Override
    public int getStartIndex() {
        if (this.aow != null) {
            return this.aow.cb();
        }
        return super.getStartIndex();
    }

    @Override
    public int getLength() {
        if (this.aow != null) {
            if (this.aox) {
                return 0;
            }
            return this.aow.getLength();
        }
        return super.getLength();
    }

    @Override
    protected void qY() {
        this.aow = null;
    }
}

