/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.report.BaseUtils;
import com.inet.report.encode.AbstractDecoder;
import com.inet.report.encode.Decoder;
import com.inet.report.encode.DecoderFactory;
import com.inet.report.encode.ErrDecoder;
import com.inet.report.i18n.Msg;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;

public class OLEDecoder
extends AbstractDecoder {
    private String format;
    private int vV;

    public OLEDecoder() {
    }

    public OLEDecoder(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    @Override
    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Override
    public BufferedImage decodeImage(int w2, int h2) {
        Decoder decoder;
        this.vV = this.offset;
        this.vV += 2;
        int n2 = this.kL();
        int n3 = this.vV + n2;
        this.vV += 4;
        int n4 = this.kL();
        int n5 = this.kL();
        this.vV += 8;
        String string = this.bT(n4);
        String string2 = this.bT(n5);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("oleType:" + string);
            BaseUtils.debug("oleClass:" + string2);
        }
        this.vV = n3;
        this.vV += 4;
        n5 = this.kL();
        this.vV += 2;
        String string3 = this.bT(n5);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("oleProgId:" + string3);
        }
        this.vV += 8;
        n2 = this.readInt();
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("OLE format: length=" + this.length + " ,idx=" + this.vV + " ,blocksize=" + n2);
        }
        if (n2 + this.vV > this.length) {
            throw new RuntimeException("Error in OLE format: length=" + this.length + " ,idx=" + this.vV + " ,blocksize=" + n2);
        }
        if ("Objekt-Manager-Shellobjekt".equals(string)) {
            int n6 = this.cZ(this.vV);
            n6 = this.cZ(n6 + 1);
            n6 = this.cZ(n6 + 1);
            n6 = this.cZ(n6 + 9);
            n2 += this.vV - (n6 += 5);
            this.vV = n6;
        }
        if ((decoder = DecoderFactory.getDecoder(this.buffer, this.vV, n2)) == null || decoder instanceof ErrDecoder) {
            String string4 = Msg.getMsg("UnknownOleType", string, string2, string3);
            BaseUtils.info(string4);
            return new ErrDecoder(string4).getImage(w2, h2);
        }
        this.format = decoder.getFormat();
        return decoder.getImage(w2, h2);
    }

    private int kL() {
        int n2 = (this.buffer[this.vV] & 0xFF) + (this.buffer[this.vV + 1] << 8);
        this.vV += 2;
        return n2;
    }

    private int readInt() {
        int n2 = (this.buffer[this.vV] & 0xFF) + ((this.buffer[this.vV + 1] & 0xFF) << 8) + ((this.buffer[this.vV + 2] & 0xFF) << 16) + (this.buffer[this.vV + 3] << 24);
        this.vV += 4;
        return n2;
    }

    private String bT(int n2) {
        String string = new String(this.buffer, this.vV, n2 - 1);
        this.vV += n2;
        return string;
    }

    private int cZ(int n2) {
        if (n2 < 0) {
            return -1;
        }
        while (n2 < this.length) {
            if (this.buffer[n2] == 0) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

