/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config.datasource;

import com.inet.annotations.PublicApi;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.lib.util.Encryption;
import com.inet.lib.util.PreferencesUtils;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.by;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.config.datasource.DataSourceConfigurationChangeListener;
import com.inet.report.config.datasource.DataSourceConfigurationXMLFileStore;
import com.inet.report.config.datasource.DataSourceSynchronizer;
import com.inet.report.y;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@PublicApi
public class DataSourceConfigurationManager {
    private static ArrayList<DataSourceConfigurationChangeListener> ZT;
    public static final int NO_STORE_UNSAFE = -1;
    public static final int NO_STORE = 0;
    public static final int SYSTEM_PREFERENCES = 1;
    public static final int USER_PREFERENCES = 2;
    @Deprecated
    public static final int ALL_PREFERENCES = 3;
    public static final int TEMPORARY_PREFERENCES = 4;
    public static final int USER_SESSION = 6;
    public static final int APPLICATION = 7;
    private static Map<String, DataSourceConfiguration> ZU;
    private static Map<String, DataSourceConfiguration> ZV;
    private static Map<String, DataSourceConfiguration> ZW;
    private static Map<String, DataSourceConfiguration[]> ZX;
    private static long[] ZY;
    private static long[] ZZ;
    private static DataSourceConfigurationManager aaa;

    private DataSourceConfigurationManager() {
    }

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data are save")
    private static Map<String, DataSourceConfiguration> cz(int n2) {
        DataSourceConfigurationManager.cC(n2);
        switch (n2) {
            case 1: {
                return ZU;
            }
            case 2: {
                return ZV;
            }
            case 3: {
                HashMap<String, DataSourceConfiguration> hashMap = new HashMap<String, DataSourceConfiguration>();
                hashMap.putAll(ZU);
                hashMap.putAll(ZV);
                hashMap.putAll(ZW);
                hashMap.putAll(DataSourceConfigurationManager.cz(7));
                try {
                    HttpSession httpSession = SessionStore.getHttpSession((boolean)false);
                    if (httpSession != null) {
                        Map map;
                        try {
                            map = (Map)httpSession.getAttribute("/com/inet/report/config/datasource");
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (BaseUtils.isDebug()) {
                                BaseUtils.debug("Can't use session datasources: " + illegalStateException.getMessage());
                            }
                            map = null;
                        }
                        if (map != null && map.size() > 0) {
                            hashMap.putAll(map);
                        }
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                return hashMap;
            }
            case 4: {
                return ZW;
            }
            case 6: {
                try {
                    HttpSession httpSession = SessionStore.getHttpSession();
                    if (httpSession == null) {
                        throw new IllegalStateException("No HttpSession avialable. You use the scope USER_SESSION outside of a servlet call.");
                    }
                    ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)httpSession.getAttribute("/com/inet/report/config/datasource");
                    if (concurrentHashMap == null) {
                        concurrentHashMap = new ConcurrentHashMap();
                        httpSession.setAttribute("/com/inet/report/config/datasource", concurrentHashMap);
                    }
                    return concurrentHashMap;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    throw new IllegalStateException("No HttpSession avialable. You use the scope USER_SESSION outside of a servlet call.");
                }
            }
            case 7: {
                HashMap<String, DataSourceConfiguration> hashMap = new HashMap<String, DataSourceConfiguration>();
                UserGroupManager userGroupManager = UserGroupManager.getInstance();
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                block14: for (Map.Entry<String, DataSourceConfiguration[]> entry : ZX.entrySet()) {
                    DataSourceConfiguration[] dataSourceConfigurationArray;
                    for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray = entry.getValue()) {
                        Set<GUID> set = dataSourceConfiguration.getAllowedUserGroups();
                        for (GUID gUID : set) {
                            if (!UsersAndGroups.GROUPID_ALLUSERS.equals((Object)gUID) && (userAccount == null || userGroupManager.getGroup(gUID) == null || !userGroupManager.getGroup(gUID).isActive() || !userGroupManager.getGroup(gUID).hasMember(userAccount.getID()))) continue;
                            hashMap.put(entry.getKey(), dataSourceConfiguration);
                            continue block14;
                        }
                    }
                }
                return hashMap;
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(n2));
    }

    public static String getUniqueName(String configurationName, int preferenceScope) {
        int n2 = 1;
        String string = configurationName;
        if (string.length() > 80) {
            string = string.substring(0, 80);
        }
        string = string.trim();
        Object object = string;
        while (DataSourceConfigurationManager.getDataSourceConfiguration((String)object, preferenceScope) != null) {
            String string2 = " (" + n2 + ")";
            if (string.length() + string2.length() > 80) {
                string = string.substring(0, 80 - string2.length());
            }
            object = string + string2;
            ++n2;
        }
        return object;
    }

    public static String[] getDataSourceConfigurationNames() {
        return DataSourceConfigurationManager.cA(3);
    }

    public static String[] getDataSourceConfigurationNames(int preferenceScope) {
        return DataSourceConfigurationManager.cA(preferenceScope);
    }

    private static String[] cA(int n2) {
        Map<String, DataSourceConfiguration> map = DataSourceConfigurationManager.cz(n2);
        String[] stringArray = new String[map.size()];
        map.keySet().toArray(stringArray);
        return stringArray;
    }

    public static DataSourceConfiguration[] getDataSourceConfigurations(int scope) {
        DataSourceConfiguration[] dataSourceConfigurationArray;
        Collection<Object> collection;
        if (scope == 7) {
            collection = new ArrayList();
            dataSourceConfigurationArray = ZX.values().iterator();
            while (dataSourceConfigurationArray.hasNext()) {
                DataSourceConfiguration[] dataSourceConfigurationArray2;
                for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray2 = (DataSourceConfiguration[])dataSourceConfigurationArray.next()) {
                    collection.add(dataSourceConfiguration);
                }
            }
        } else {
            collection = DataSourceConfigurationManager.cz(scope).values();
        }
        dataSourceConfigurationArray = new DataSourceConfiguration[collection.size()];
        collection.toArray(dataSourceConfigurationArray);
        return dataSourceConfigurationArray;
    }

    public static DataSourceConfiguration getDataSourceConfiguration(String configurationName, int preferenceScope) {
        Map<String, DataSourceConfiguration> map = DataSourceConfigurationManager.cz(preferenceScope);
        return map.get(configurationName);
    }

    public static boolean exists(String configurationName) {
        return DataSourceConfigurationManager.getDataSource(configurationName) != null;
    }

    public static boolean isWriteable(int preferenceScope) {
        return DataSourceConfigurationManager.z(preferenceScope, "/com/inet/report/config/datasource");
    }

    private static boolean z(int n2, String string) {
        switch (n2) {
            case 1: {
                return PreferencesUtils.isSystemWriteable((String)string);
            }
            case 2: {
                return PreferencesUtils.isUserWriteable((String)string);
            }
            case 4: {
                return true;
            }
            case 3: {
                return false;
            }
            case 6: {
                try {
                    return DataSourceConfigurationManager.cz(n2) != null;
                }
                catch (IllegalStateException illegalStateException) {
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(n2));
    }

    public static boolean isReadable(int preferenceScope) {
        switch (preferenceScope) {
            case 1: {
                return PreferencesUtils.isSystemReadable((String)"/com/inet/report/config/datasource");
            }
            case 2: {
                return PreferencesUtils.isUserReadable((String)"/com/inet/report/config/datasource");
            }
            case 4: {
                return true;
            }
            case 3: {
                return PreferencesUtils.isSystemReadable((String)"/com/inet/report/config/datasource") && PreferencesUtils.isUserReadable((String)"/com/inet/report/config/datasource");
            }
            case 6: {
                try {
                    return DataSourceConfigurationManager.cz(preferenceScope) != null;
                }
                catch (IllegalStateException illegalStateException) {
                    return false;
                }
            }
        }
        throw new IllegalArgumentException("Invalid value for scope: " + String.valueOf(preferenceScope));
    }

    public static boolean exists(String configurationName, int preferenceScope) {
        if (preferenceScope == 7) {
            return ZX.containsKey(configurationName);
        }
        return DataSourceConfigurationManager.getDataSourceConfiguration(configurationName, preferenceScope) != null;
    }

    private static void a(DataSourceConfiguration[] dataSourceConfigurationArray, int n2, boolean bl2) throws SecurityException {
        for (int i2 = 0; i2 < dataSourceConfigurationArray.length; ++i2) {
            if (n2 != 7 && DataSourceConfigurationManager.exists(dataSourceConfigurationArray[i2].getConfigurationName(), n2)) {
                if (bl2) continue;
                DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(DataSourceConfigurationManager.getUniqueName(dataSourceConfigurationArray[i2].getConfigurationName(), n2), n2);
                dataSourceConfiguration.addProperties(dataSourceConfigurationArray[i2].getProperties());
                dataSourceConfigurationArray[i2] = dataSourceConfiguration;
            }
            DataSourceConfigurationManager.a(dataSourceConfigurationArray[i2], n2);
            if (ZT == null) continue;
            for (int i3 = 0; i3 < ZT.size(); ++i3) {
                ZT.get(i3).addedDataSourceConfiguration(dataSourceConfigurationArray[i2]);
            }
        }
    }

    static void a(@Nonnull DataSourceConfiguration dataSourceConfiguration, int n2) throws SecurityException {
        switch (n2) {
            case 1: 
            case 2: {
                DataSourceConfigurationManager.b(dataSourceConfiguration, n2);
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 7: {
                int n3;
                StringBuilder stringBuilder = new StringBuilder();
                DataSourceConfigurationXMLFileStore.saveToReportXMLFile(dataSourceConfiguration, stringBuilder, 0);
                Persistence.getRecoveryEnabledInstance().resolve("datasources").resolve(dataSourceConfiguration.getUID().toString()).setString(stringBuilder.toString());
                DataSourceSynchronizer.np();
                DataSourceConfiguration[] dataSourceConfigurationArray = ZX.getOrDefault(dataSourceConfiguration.getConfigurationName(), new DataSourceConfiguration[0]);
                for (n3 = 0; n3 < dataSourceConfigurationArray.length; ++n3) {
                    DataSourceConfiguration dataSourceConfiguration2 = dataSourceConfigurationArray[n3];
                    if (!dataSourceConfiguration.getUID().equals((Object)dataSourceConfiguration2.getUID())) continue;
                    dataSourceConfigurationArray[n3] = dataSourceConfiguration;
                    return;
                }
                n3 = dataSourceConfigurationArray.length;
                dataSourceConfigurationArray = Arrays.copyOf(dataSourceConfigurationArray, n3 + 1);
                dataSourceConfigurationArray[n3] = dataSourceConfiguration;
                ZX.put(dataSourceConfiguration.getConfigurationName(), dataSourceConfigurationArray);
                return;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for parameter 'scope': " + n2);
            }
        }
        Map<String, DataSourceConfiguration> map = DataSourceConfigurationManager.cz(n2);
        if (!map.containsValue(dataSourceConfiguration)) {
            map.put(dataSourceConfiguration.getConfigurationName(), dataSourceConfiguration);
        }
    }

    private static void b(@Nonnull DataSourceConfiguration dataSourceConfiguration, int n2) {
        block8: {
            if (!DataSourceConfigurationManager.isWriteable(n2) || !DataSourceConfigurationManager.z(n2, "/com/inet/report/config/datasource/" + dataSourceConfiguration.getConfigurationName())) {
                throw new SecurityException("Preferences node for data source '" + dataSourceConfiguration.getConfigurationName() + "' was write protected!");
            }
            Preferences preferences = DataSourceConfigurationManager.s(n2, true);
            if (preferences != null) {
                Preferences preferences2 = preferences.node(dataSourceConfiguration.getConfigurationName());
                Properties properties = dataSourceConfiguration.getProperties();
                boolean bl2 = dataSourceConfiguration.isSavePassword();
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    if (string.equals("password")) {
                        if (bl2) {
                            string2 = Encryption.encrypt((String)string2);
                        } else {
                            preferences2.remove(string);
                            continue;
                        }
                    }
                    if (string.length() <= 0) continue;
                    preferences2.put(string, string2);
                }
                preferences.put("timestamp", String.valueOf(System.currentTimeMillis()));
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    if (!BaseUtils.isError()) break block8;
                    BaseUtils.error("[DataSourceConfigurationManager] save configuration failed");
                }
            }
        }
    }

    @Nonnull
    public static DataSourceConfiguration createDataSourceConfiguration(String configurationName, int scope) throws SecurityException {
        DataSourceConfiguration dataSourceConfiguration;
        if (scope == 0 || scope == -1) {
            return new DataSourceConfiguration(configurationName, scope);
        }
        if (configurationName == null) {
            throw new NullPointerException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] The parameter 'configurationName' must not be  null.");
        }
        if ((configurationName = configurationName.trim()).length() == 0) {
            throw new IllegalArgumentException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] The parameter 'configurationName' must not be empty.");
        }
        if (scope == 3) {
            throw new IllegalArgumentException("[DataSourceConfigurationManager - createDataSourceConfiguration(String, int)] Invalid value for parameter 'preferenceScope'");
        }
        if (scope == 7) {
            dataSourceConfiguration = new DataSourceConfiguration(configurationName, scope);
        } else {
            dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(configurationName, scope);
            if (dataSourceConfiguration != null) {
                configurationName = DataSourceConfigurationManager.getUniqueName(configurationName, scope);
            }
            dataSourceConfiguration = new DataSourceConfiguration(configurationName, scope);
        }
        DataSourceConfigurationManager.a(dataSourceConfiguration, scope);
        if (ZT != null) {
            for (int i2 = 0; i2 < ZT.size(); ++i2) {
                ZT.get(i2).addedDataSourceConfiguration(dataSourceConfiguration);
            }
        }
        return dataSourceConfiguration;
    }

    public static void removeDatasourceConfigurations(DataSourceConfiguration[] configs, int preferenceScope) {
        for (int i2 = 0; i2 < configs.length; ++i2) {
            DataSourceConfigurationManager.removeDatasourceConfiguration(configs[i2].getConfigurationName(), preferenceScope);
        }
    }

    @Deprecated
    public static void removeDatasourceConfiguration(String configurationName, int preferenceScope) throws IllegalArgumentException, SecurityException {
        DataSourceConfigurationManager.i(configurationName, preferenceScope);
    }

    public static void removeDatasourceConfiguration(DataSourceConfiguration dsc) throws IllegalArgumentException, SecurityException {
        if (dsc == null) {
            throw new IllegalArgumentException("[DataSourceConfigurationManager - removeDatasourceConfiguration(DatasourceConfiguration)] The parameter 'dsc' must not be null");
        }
        if (dsc.getScope() == 7) {
            DataSourceConfigurationManager.a(dsc);
        } else {
            DataSourceConfigurationManager.i(dsc.getConfigurationName(), dsc.getScope());
        }
    }

    private static void a(DataSourceConfiguration dataSourceConfiguration) {
        String string = dataSourceConfiguration.getConfigurationName();
        if (string != null) {
            DataSourceConfiguration[] dataSourceConfigurationArray = ZX.getOrDefault(string, new DataSourceConfiguration[0]);
            List<DataSourceConfiguration> list = Arrays.asList(dataSourceConfigurationArray);
            DataSourceConfiguration[] dataSourceConfigurationArray2 = (DataSourceConfiguration[])list.stream().filter(dataSourceConfiguration2 -> !dataSourceConfiguration2.getUID().equals((Object)dataSourceConfiguration.getUID())).toArray(DataSourceConfiguration[]::new);
            ZX.put(string, dataSourceConfigurationArray2);
        }
        Persistence.getRecoveryEnabledInstance().resolve("datasources").resolve(dataSourceConfiguration.getUID().toString()).deleteValue();
        DataSourceSynchronizer.np();
    }

    private static void i(String string, int n2) throws IllegalArgumentException, SecurityException {
        Map<String, DataSourceConfiguration> map;
        DataSourceConfiguration dataSourceConfiguration;
        block10: {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("[DataSourceConfigurationManager - removeDatasourceConfiguration(String, int)] The parameter 'configurationName' must not be empty or null");
            }
            dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(string, n2);
            if (dataSourceConfiguration == null) {
                return;
            }
            if (n2 == 3) {
                throw new IllegalArgumentException("Invalid value for parameter 'preferenceScope'");
            }
            if (!DataSourceConfigurationManager.isWriteable(n2) || !DataSourceConfigurationManager.z(n2, "/com/inet/report/config/datasource/" + dataSourceConfiguration.getConfigurationName())) {
                throw new SecurityException("Preferences node for data source '" + dataSourceConfiguration.getConfigurationName() + "' was write protected!");
            }
            map = DataSourceConfigurationManager.cz(n2);
            Preferences preferences = DataSourceConfigurationManager.s(n2, true);
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DataSourceConfigurationManager] remove configuration \"" + string + "\"");
            }
            if (preferences != null) {
                try {
                    Preferences preferences2 = preferences.node(dataSourceConfiguration.getConfigurationName());
                    preferences2.removeNode();
                    preferences.put("timestamp", String.valueOf(System.currentTimeMillis()));
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    if (!BaseUtils.isError()) break block10;
                    BaseUtils.error("[DataSourceConfigurationManager] remove configuration failed");
                }
            }
        }
        map.remove(dataSourceConfiguration.getConfigurationName());
        if (ZT != null) {
            for (int i2 = 0; i2 < ZT.size(); ++i2) {
                if (ZT.get(i2) == null) continue;
                ZT.get(i2).removedDataSourceConfiguration(dataSourceConfiguration);
            }
        }
    }

    public static void forceImportDataSourceConfigurations(int preferenceScope, File fileToImport) throws ReportException, SecurityException {
        try {
            DataSourceConfiguration[] dataSourceConfigurationArray;
            DataSourceConfigurationXMLFileStore dataSourceConfigurationXMLFileStore = new DataSourceConfigurationXMLFileStore();
            for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray = dataSourceConfigurationXMLFileStore.readDataSourceConfigurationFromXML(new FileInputStream(fileToImport), preferenceScope)) {
                DataSourceConfiguration dataSourceConfiguration2;
                while ((dataSourceConfiguration2 = DataSourceConfigurationManager.getDataSourceConfiguration(dataSourceConfiguration.getConfigurationName(), preferenceScope)) != null) {
                    DataSourceConfigurationManager.removeDatasourceConfiguration(dataSourceConfiguration2);
                }
            }
            DataSourceConfigurationManager.a(dataSourceConfigurationArray, preferenceScope, true);
        }
        catch (Exception exception) {
            ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    public static void importDataSourceConfigurations(int preferenceScope, File importFile) throws ReportException {
        DataSourceConfigurationManager.importDataSourceConfigurations(preferenceScope, importFile, false);
    }

    public static void importDataSourceConfigurations(int preferenceScope, File importFile, boolean ignoreIfExist) throws ReportException, SecurityException {
        try {
            DataSourceConfigurationManager.importDataSourceConfigurations(preferenceScope, new FileInputStream(importFile), ignoreIfExist);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException);
        }
    }

    public static DataSourceConfiguration[] importDataSourceConfigurations(int preferenceScope, InputStream importStream) throws ReportException {
        return DataSourceConfigurationManager.importDataSourceConfigurations(preferenceScope, importStream, false);
    }

    public static DataSourceConfiguration[] importDataSourceConfigurations(int preferenceScope, InputStream importStream, boolean ignoreIfExist) throws ReportException, SecurityException {
        DataSourceConfigurationXMLFileStore dataSourceConfigurationXMLFileStore = new DataSourceConfigurationXMLFileStore();
        DataSourceConfiguration[] dataSourceConfigurationArray = dataSourceConfigurationXMLFileStore.readDataSourceConfigurationFromXML(importStream, preferenceScope);
        DataSourceConfigurationManager.a(dataSourceConfigurationArray, preferenceScope, ignoreIfExist);
        return dataSourceConfigurationArray;
    }

    public static void exportDataSourceConfigurations(DataSourceConfiguration[] configs, File exportFile) throws ReportException {
        try {
            DataSourceConfigurationManager.exportDataSourceConfigurations(configs, new FileOutputStream(exportFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportExceptionFactory.createReportExceptionWithCause(fileNotFoundException);
        }
    }

    public static void exportDataSourceConfigurations(DataSourceConfiguration[] configs, OutputStream stream) throws ReportException {
        DataSourceConfigurationXMLFileStore dataSourceConfigurationXMLFileStore = new DataSourceConfigurationXMLFileStore();
        dataSourceConfigurationXMLFileStore.saveDataSourceConfigurationToXML(configs, stream);
    }

    private static Preferences s(int n2, boolean bl2) throws IllegalArgumentException {
        switch (n2) {
            case 1: {
                return PreferencesUtils.systemRoot().node("/com/inet/report/config/datasource");
            }
            case 2: {
                return PreferencesUtils.userRoot().node("/com/inet/report/config/datasource");
            }
            case 4: 
            case 6: {
                if (!bl2) break;
                return null;
            }
        }
        throw y.a(n2, "preferenceScope", null);
    }

    private static Map<String, DataSourceConfiguration> cB(int n2) {
        ConcurrentHashMap<String, DataSourceConfiguration> concurrentHashMap;
        block12: {
            concurrentHashMap = new ConcurrentHashMap<String, DataSourceConfiguration>();
            if (!DataSourceConfigurationManager.isReadable(n2)) {
                BaseUtils.warning("can not read from Preferences to get datasource info!");
                return concurrentHashMap;
            }
            Preferences preferences = DataSourceConfigurationManager.s(n2, false);
            try {
                String[] stringArray = preferences.childrenNames();
                if (stringArray.length > 0) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        String string = stringArray[i2];
                        Preferences preferences2 = preferences.node(string);
                        preferences2.sync();
                        String[] stringArray2 = preferences2.keys();
                        if (stringArray2.length == 0) {
                            try {
                                preferences2.removeNode();
                                preferences2.flush();
                            }
                            catch (Throwable throwable) {
                                BaseUtils.printStackTrace(throwable);
                            }
                            continue;
                        }
                        DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(string, n2);
                        dataSourceConfiguration.setQuiet(true);
                        concurrentHashMap.put(string, dataSourceConfiguration);
                        for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                            String string2 = preferences2.get(stringArray2[i3], "");
                            if (stringArray2[i3].equals("password")) {
                                string2 = Encryption.decrypt((String)string2);
                            }
                            dataSourceConfiguration.addProperty(stringArray2[i3], string2);
                        }
                        dataSourceConfiguration.setQuiet(false);
                    }
                } else if (BaseUtils.isDebug()) {
                    String string = n2 == 1 ? " system " : " user ";
                    BaseUtils.debug("no datasource configuration for" + string + "scope");
                }
            }
            catch (BackingStoreException backingStoreException) {
                if (!BaseUtils.isError()) break block12;
                BaseUtils.error("[DataSourceConfigurationManager] - load configuration failed");
            }
        }
        return concurrentHashMap;
    }

    private static void cC(int n2) throws IllegalArgumentException {
        int n3;
        switch (n2) {
            case 1: {
                n3 = 0;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
            case 3: {
                DataSourceConfigurationManager.cC(1);
                DataSourceConfigurationManager.cC(2);
                return;
            }
            case 4: 
            case 6: {
                return;
            }
            case 7: {
                if (ZX == null) {
                    ZX = new ConcurrentHashMap<String, DataSourceConfiguration[]>();
                    DataSourceConfigurationManager.nn();
                }
                return;
            }
            default: {
                throw y.a(n2, "preferenceScope", null);
            }
        }
        if (ZZ[n3] + 30000L < System.currentTimeMillis()) {
            DataSourceConfigurationManager.ZZ[n3] = System.currentTimeMillis();
            if (!DataSourceConfigurationManager.isReadable(n2)) {
                DataSourceConfigurationManager.a(n2, new ConcurrentHashMap<String, DataSourceConfiguration>());
                return;
            }
            Preferences preferences = DataSourceConfigurationManager.s(n2, false);
            try {
                preferences.sync();
            }
            catch (SecurityException | BackingStoreException exception) {
                BaseUtils.warning(exception);
            }
            String string = preferences.get("timestamp", "-1");
            long l2 = Long.parseLong(string);
            if (ZY[n3] != l2) {
                Map<String, DataSourceConfiguration> map;
                DataSourceConfigurationManager.ZY[n3] = l2;
                try {
                    map = DataSourceConfigurationManager.cB(n2);
                }
                catch (Throwable throwable) {
                    if (BaseUtils.isWarning()) {
                        BaseUtils.warning(throwable);
                    }
                    map = new ConcurrentHashMap<String, DataSourceConfiguration>();
                    DataSourceConfigurationManager.ZZ[n3] = 9223372036854475807L;
                }
                DataSourceConfigurationManager.a(n2, map);
            }
        }
    }

    static void nn() {
        AccessController.doPrivileged(() -> {
            try {
                DataSourceConfiguration[] dataSourceConfigurationArray;
                Object object;
                HashMap<String, ArrayList<DataSourceConfiguration>> hashMap = new HashMap<String, ArrayList<DataSourceConfiguration>>();
                PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("datasources");
                for (PersistenceEntry object2 : persistenceEntry.getChildren()) {
                    InputStream inputStream;
                    object = object2.getName();
                    try {
                        dataSourceConfigurationArray = GUID.valueOf((String)object);
                    }
                    catch (Exception exception) {
                        dataSourceConfigurationArray = null;
                    }
                    if ((inputStream = object2.getInputStream()) == null) continue;
                    try {
                        DataSourceConfiguration dataSourceConfiguration = new DataSourceConfigurationXMLFileStore().a(inputStream, 7, (GUID)dataSourceConfigurationArray);
                        String string = dataSourceConfiguration.getConfigurationName();
                        ArrayList<DataSourceConfiguration> arrayList = (ArrayList<DataSourceConfiguration>)hashMap.get(string);
                        if (arrayList == null) {
                            arrayList = new ArrayList<DataSourceConfiguration>();
                            hashMap.put(string, arrayList);
                        }
                        arrayList.add(dataSourceConfiguration);
                    }
                    catch (ReportException reportException) {
                        BaseUtils.printStackTrace(reportException);
                    }
                }
                for (String string : ZX.keySet()) {
                    if (hashMap.containsKey(string)) continue;
                    ZX.remove(string);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    object = (ArrayList)entry.getValue();
                    dataSourceConfigurationArray = ((ArrayList)object).toArray(new DataSourceConfiguration[((ArrayList)object).size()]);
                    ZX.put((String)entry.getKey(), dataSourceConfigurationArray);
                }
            }
            catch (SecurityException securityException) {
                BaseUtils.error(securityException);
            }
            return null;
        });
    }

    private static void a(int n2, Map<String, DataSourceConfiguration> map) {
        switch (n2) {
            case 1: {
                ZU = map;
                break;
            }
            case 2: {
                ZV = map;
            }
        }
    }

    public static void addDataSourceConfigurationListener(DataSourceConfigurationChangeListener dscl) {
        if (ZT == null) {
            ZT = new ArrayList();
        }
        ZT.add(dscl);
    }

    public static DataSourceConfigurationChangeListener[] getDataSourceConfigurationListeners() {
        return ZT.toArray(new DataSourceConfigurationChangeListener[ZT.size()]);
    }

    public static void removeDataSourceConfigurationListener(DataSourceConfigurationChangeListener dscl) {
        if (ZT == null) {
            return;
        }
        ZT.remove(dscl);
    }

    static void a(DataSourceConfiguration dataSourceConfiguration, String string, String string2, String string3) {
        if (!(ZW != null && ZW.containsValue(dataSourceConfiguration) || ZV != null && ZV.containsValue(dataSourceConfiguration) || ZU != null && ZU.containsValue(dataSourceConfiguration) || ZX != null && ZX.containsKey(dataSourceConfiguration.getConfigurationName()))) {
            return;
        }
        if (ZX != null && ZX.containsKey(dataSourceConfiguration.getConfigurationName())) {
            DataSourceConfiguration[] dataSourceConfigurationArray = ZX.get(dataSourceConfiguration.getConfigurationName());
            boolean bl2 = false;
            for (int i2 = 0; i2 < dataSourceConfigurationArray.length; ++i2) {
                DataSourceConfiguration dataSourceConfiguration2 = dataSourceConfigurationArray[i2];
                if (!dataSourceConfiguration2.equals(dataSourceConfiguration)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (ZT != null && !string2.equals(string3)) {
            for (int i3 = 0; i3 < ZT.size(); ++i3) {
                ZT.get(i3).propertyChanged(dataSourceConfiguration, string, string2, string3);
            }
        }
    }

    public static DataSourceConfiguration getDataSource(String name) {
        DataSourceConfiguration dataSourceConfiguration;
        block7: {
            if (ServerPluginManager.IS_SERVLET_API && SessionStore.getHttpSession((boolean)false) != null) {
                try {
                    dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(name, 6);
                    if (dataSourceConfiguration != null) {
                        return dataSourceConfiguration;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (!BaseUtils.isDebug()) break block7;
                    BaseUtils.debug(illegalStateException);
                }
            }
        }
        if ((dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(name, 4)) != null) {
            return dataSourceConfiguration;
        }
        dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(name, 7);
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration;
        }
        dataSourceConfiguration = DataSourceConfigurationManager.getDataSourceConfiguration(name, 2);
        if (dataSourceConfiguration != null) {
            return dataSourceConfiguration;
        }
        return DataSourceConfigurationManager.getDataSourceConfiguration(name, 1);
    }

    public static DataSourceConfiguration getDataSource(GUID uid) {
        if (uid == null) {
            return null;
        }
        Collection[] collectionArray = new Collection[]{ZW.values(), ZV.values(), ZU.values()};
        for (Collection collection : collectionArray) {
            for (DataSourceConfiguration dataSourceConfiguration : collection) {
                if (!uid.equals((Object)dataSourceConfiguration.getUID())) continue;
                return dataSourceConfiguration;
            }
        }
        Iterator<DataSourceConfiguration[]> iterator = ZX.values().iterator();
        while (iterator.hasNext()) {
            DataSourceConfiguration[] dataSourceConfigurationArray;
            for (DataSourceConfiguration dataSourceConfiguration : dataSourceConfigurationArray = (DataSourceConfiguration[])iterator.next()) {
                if (!uid.equals((Object)dataSourceConfiguration.getUID())) continue;
                return dataSourceConfiguration;
            }
        }
        return null;
    }

    static {
        ZY = new long[2];
        ZZ = new long[2];
        ZW = new ConcurrentHashMap<String, DataSourceConfiguration>();
        DataSourceConfigurationManager.cC(1);
        DataSourceConfigurationManager.cC(2);
        by.kE();
        DataSourceConfigurationManager.cC(7);
        Persistence.getRecoveryEnabledInstance().registerListener((PersistenceListener)new DataSourceSynchronizer());
        aaa = new DataSourceConfigurationManager();
    }
}

