/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.viewer.MultiPromptValue;
import com.inet.viewer.PromptValue;
import com.inet.viewer.Range;
import com.inet.viewer.RangePromptValue;
import com.inet.viewer.SinglePromptValue;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.i18n.a;
import java.io.Serializable;
import java.sql.Time;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

@JsonData
@PublicApi
public class PromptData
implements Serializable {
    private static final long serialVersionUID = 1414195392625930L;
    private static final String PREFIX_FORMULA = "formula:";
    private static final String SUBREPORT_PROMPT_PATTERN = "^#(\\d+)#(.*)";
    private static final String STRING_EMPTY = "";
    public static final int UNKNOWN = -1;
    public static final int NUMBER = 6;
    public static final int CURRENCY = 7;
    public static final int BOOLEAN = 8;
    public static final int DATE = 9;
    public static final int TIME = 10;
    public static final int STRING = 11;
    public static final int DATETIME = 15;
    public static final int BINARY = 14;
    public static final int RANGE = 128;
    public static final int ARRAY = 256;
    private String description;
    String name;
    private String displayName;
    boolean isRange;
    boolean isDiscrete;
    boolean multipleAllowed;
    private boolean changeable;
    boolean descOnly;
    transient Icon icon;
    int type;
    private Vector defaultValues = new Vector();
    PromptValue setValues;
    private String editMask;
    PromptValue minValue;
    PromptValue maxValue;
    String[] defaultDescs;
    boolean skipThisPrompt;
    boolean informix;
    private String cascadingParent;

    public PromptData(boolean skipThis) {
        this.skipThisPrompt = skipThis;
    }

    public PromptData(String name, String subreportName, String description, String[] defaultValues, String[] defaultDescs, int type, boolean discrete, boolean range, boolean multi, boolean changeable, boolean descOnly, boolean informixSP, String editMask, String minValue, String maxValue) {
        this(name, name, subreportName, description, defaultValues, defaultDescs, type, discrete, range, multi, changeable, descOnly, informixSP, editMask, minValue, maxValue);
    }

    public PromptData(String name, String displayName, String subreportName, String description, String[] defaultValues, String[] defaultDescs, int type, boolean discrete, boolean range, boolean multi, boolean changeable, boolean descOnly, boolean informixSP, String editMask, String minValue, String maxValue) {
        Serializable serializable;
        Matcher matcher;
        this.name = name;
        if (subreportName != null && subreportName.length() > 0 && (matcher = ((Pattern)(serializable = Pattern.compile(SUBREPORT_PROMPT_PATTERN))).matcher(name)).find()) {
            displayName = matcher.group(2) + " (" + subreportName + ")";
        }
        this.setDisplayName((String)displayName);
        this.setDescription(description);
        this.defaultDescs = defaultDescs;
        this.type = type;
        this.isDiscrete = discrete;
        this.isRange = range;
        this.multipleAllowed = multi;
        this.setChangeable(changeable);
        this.descOnly = descOnly;
        this.informix = informixSP;
        this.setEditMask(editMask);
        if (minValue != null) {
            this.minValue = this.extractValueFromString(minValue, STRING_EMPTY);
        }
        if (maxValue != null) {
            this.maxValue = this.extractValueFromString(maxValue, STRING_EMPTY);
            if (this.type == 9) {
                serializable = (Calendar)this.maxValue.getValue();
                ((Calendar)serializable).add(5, 1);
            }
        }
        this.icon = ViewerUtils.getImageIcon(this.getIconName());
        if (type == 14 || !changeable && !this.multipleAllowed && defaultValues != null && defaultValues.length == 1) {
            this.skipThisPrompt = true;
        }
        try {
            this.extractValuesFromDefault(defaultValues, defaultDescs);
        }
        catch (Exception exception) {
            ViewerUtils.printStackTrace(exception);
        }
        if (this.getDefaultValuesField().size() == 0) {
            this.setChangeable(true);
        }
    }

    public PromptData(PromptData data) {
        this.skipThisPrompt = data.skipThisPrompt;
        this.name = data.name;
        this.setDisplayName(data.getDisplayName());
        this.setDescription(data.getDescription());
        this.type = data.type;
        this.isRange = data.isRange;
        this.isDiscrete = data.isDiscrete;
        this.multipleAllowed = data.multipleAllowed;
        this.setChangeable(data.isChangeable());
        this.descOnly = data.descOnly;
        this.setEditMask(data.getEditMask());
        this.minValue = data.minValue;
        this.maxValue = data.maxValue;
        this.setValues = data.setValues;
        if (data.getDefaultValuesField() != null) {
            this.setDefaultValuesField((Vector)data.getDefaultValuesField().clone());
        }
        this.defaultDescs = data.defaultDescs;
        this.cascadingParent = data.cascadingParent;
    }

    private void extractValuesFromDefault(String[] values, String[] descr) {
        if (values.length == 0) {
            this.initializeSetValueAccordingToType();
            return;
        }
        this.getDefaultValuesField().clear();
        for (int i2 = 0; i2 < values.length; ++i2) {
            Iterator iterator = values[i2];
            Object object = STRING_EMPTY;
            if (descr != null && descr.length >= values.length && descr[i2] != null) {
                object = descr[i2];
            }
            try {
                PromptValue promptValue = this.extractValueFromString((String)((Object)iterator), (String)object);
                if (this.getDefaultValuesField().contains(promptValue)) continue;
                this.getDefaultValuesField().add(promptValue);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ViewerUtils.error(illegalArgumentException.toString());
                ViewerUtils.error("ignoring this default value: " + (String)((Object)iterator));
            }
        }
        Vector vector = (Vector)this.getDefaultValuesField().clone();
        if (this.isMultipleAllowed()) {
            this.setValues = null;
        } else if (vector.size() > 0) {
            if (this.isDiscrete()) {
                for (Object object : vector) {
                    if (!(object instanceof SinglePromptValue)) continue;
                    this.setValues = object;
                    break;
                }
            } else if (this.isRange()) {
                for (Object object : vector) {
                    if (!(object instanceof RangePromptValue)) continue;
                    this.setValues = object;
                    break;
                }
            }
        } else {
            this.initializeSetValueAccordingToType();
        }
    }

    private void initializeSetValueAccordingToType() {
        this.setValues = this.multipleAllowed ? null : (this.isDiscrete ? new SinglePromptValue(this.type) : (this.isRange ? (this.type == 9 || this.type == 15 ? null : new RangePromptValue(this.type)) : new MultiPromptValue(this.type)));
    }

    PromptValue extractValueFromString(String values, String descr) {
        if (values == null || values.length() == 0 || values.equalsIgnoreCase("null")) {
            if (this.multipleAllowed) {
                return null;
            }
            if (this.isDiscrete) {
                SinglePromptValue singlePromptValue = new SinglePromptValue(null, descr, this.type);
                singlePromptValue.setOnlyDescription(this.descOnly);
                return singlePromptValue;
            }
            if (this.isRange) {
                if (this.type == 9 || this.type == 15) {
                    return null;
                }
                RangePromptValue rangePromptValue = new RangePromptValue(this.type);
                rangePromptValue.setOnlyDescription(this.descOnly);
                return rangePromptValue;
            }
            MultiPromptValue multiPromptValue = new MultiPromptValue(this.type);
            multiPromptValue.setOnlyDescription(this.descOnly);
            return multiPromptValue;
        }
        if (this.isRange) {
            int n2;
            if (this.type == 11 && values.indexOf("to") != -1) {
                StringTokenizer stringTokenizer = new StringTokenizer(values, "\"' _", true);
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                Object object = STRING_EMPTY;
                RangePromptValue rangePromptValue = null;
                String string = STRING_EMPTY;
                try {
                    while (stringTokenizer.hasMoreTokens()) {
                        if (string.length() == 0) {
                            string = stringTokenizer.nextToken();
                            continue;
                        }
                        if (!bl2 && !bl3) {
                            if (string.equals("\"")) {
                                bl2 = true;
                                string = STRING_EMPTY;
                                continue;
                            }
                            if (string.equals("'")) {
                                bl3 = true;
                                string = STRING_EMPTY;
                                continue;
                            }
                            if (string.equals("_")) {
                                bl4 = true;
                                string = STRING_EMPTY;
                                continue;
                            }
                            if (string.equals("to")) {
                                string = stringTokenizer.nextToken();
                                rangePromptValue = new RangePromptValue(this.type);
                                rangePromptValue.setIncludeLow(!bl4);
                                rangePromptValue.setIncludeHigh(!string.equals("_"));
                                rangePromptValue.setStartValue(new SinglePromptValue(object, STRING_EMPTY, this.type));
                                object = STRING_EMPTY;
                                continue;
                            }
                            string = STRING_EMPTY;
                            continue;
                        }
                        if (bl2 && string.equals("\"")) {
                            string = stringTokenizer.nextToken();
                            if (!string.equals("\"")) {
                                bl2 = false;
                                continue;
                            }
                        } else if (bl3 && string.equals("'") && !(string = stringTokenizer.nextToken()).equals("'")) {
                            bl3 = false;
                            continue;
                        }
                        object = (String)object + string;
                        string = STRING_EMPTY;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    ViewerUtils.error(noSuchElementException.toString());
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    ViewerUtils.error(stringIndexOutOfBoundsException.toString());
                }
                if (rangePromptValue != null) {
                    rangePromptValue.setEndValue(new SinglePromptValue(object, STRING_EMPTY, this.type));
                    if (descr != null) {
                        rangePromptValue.setDescription(descr);
                    }
                    return rangePromptValue;
                }
            } else if (this.type != 14 && this.type != 8 && (n2 = values.indexOf("to")) != -1) {
                RangePromptValue rangePromptValue = new RangePromptValue(this.type);
                if (descr != null) {
                    rangePromptValue.setDescription(descr);
                }
                rangePromptValue.setOnlyDescription(this.descOnly);
                rangePromptValue.setIncludeLow(values.charAt(n2 - 1) != '_');
                rangePromptValue.setIncludeHigh(values.charAt(n2 + 2) != '_');
                rangePromptValue.setStartValue((SinglePromptValue)this.extractValueFromString(values.substring(0, n2 - (rangePromptValue.isIncludeLow() ? 0 : 1)), STRING_EMPTY));
                rangePromptValue.setEndValue((SinglePromptValue)this.extractValueFromString(values.substring(n2 + (rangePromptValue.isIncludeHigh() ? 2 : 3)), STRING_EMPTY));
                return rangePromptValue;
            }
        }
        SinglePromptValue singlePromptValue = new SinglePromptValue(this.type);
        switch (this.type) {
            case 6: 
            case 7: {
                if (this.isRange) {
                    if (values.trim().equals("'<'")) {
                        singlePromptValue = new SinglePromptValue(new Double(Double.POSITIVE_INFINITY), descr, this.type);
                        break;
                    }
                    if (values.trim().equals("'>'")) {
                        singlePromptValue = new SinglePromptValue(new Double(Double.NEGATIVE_INFINITY), descr, this.type);
                        break;
                    }
                }
                singlePromptValue = new SinglePromptValue(new Double(values.trim()), descr, this.type);
                break;
            }
            case 8: {
                singlePromptValue = new SinglePromptValue(Boolean.valueOf(values), descr, this.type);
                break;
            }
            case 9: {
                int[] nArray = this.extractDateAndOrTime(values, "DATE", 3);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(nArray[0], nArray[1] - 1, nArray[2]);
                singlePromptValue = new SinglePromptValue(calendar, descr, this.type);
                break;
            }
            case 10: {
                int[] nArray = this.extractDateAndOrTime(values, "TIME", 3);
                singlePromptValue = new SinglePromptValue(new Time(nArray[0], nArray[1], nArray[2]), descr, this.type);
                break;
            }
            case 15: {
                int[] nArray = this.extractDateAndOrTime(values, "DATETIME", 6);
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(nArray[0], nArray[1] - 1, nArray[2], nArray[3], nArray[4], nArray[5]);
                singlePromptValue = new SinglePromptValue(calendar, descr, this.type);
                break;
            }
            case 11: {
                Object object = values;
                if (values.charAt(0) == '\'' && values.charAt(values.length() - 1) == '\'') {
                    object = ((String)object).substring(1, ((String)object).length() - 1);
                    int n3 = ((String)object).indexOf("''", 0);
                    while (n3 != -1) {
                        object = ((String)object).substring(0, n3) + ((String)object).substring(n3 + 1);
                        n3 = ((String)object).indexOf("''", n3 + 1);
                    }
                }
                singlePromptValue = new SinglePromptValue(object, descr, this.type);
                break;
            }
            case 14: {
                singlePromptValue = new SinglePromptValue(values, descr, this.type);
            }
        }
        singlePromptValue.setOnlyDescription(this.descOnly);
        return singlePromptValue;
    }

    private int[] extractDateAndOrTime(String values, String tokenToSkip, int howManyParams) {
        StringTokenizer stringTokenizer = new StringTokenizer(values, "(,) ", false);
        int[] nArray = new int[howManyParams];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < howManyParams) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase(tokenToSkip)) continue;
            nArray[n2++] = Integer.parseInt(string);
        }
        return nArray;
    }

    PromptValue getPromptValueObject() {
        return this.setValues;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public boolean isDiscrete() {
        return this.isDiscrete;
    }

    public boolean isMultipleAllowed() {
        return this.multipleAllowed;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    void setValues(PromptValue values) {
        this.setValues = values;
    }

    public void setChosenValues(Object values) {
        if (values instanceof Vector) {
            Vector vector = (Vector)values;
            Iterator iterator = vector.iterator();
            Vector<PromptValue> vector2 = new Vector<PromptValue>();
            while (iterator.hasNext()) {
                vector2.add(this.decodeValue(iterator.next()));
            }
            this.setValues = new MultiPromptValue(vector2, this.getDescription(), this.type);
        } else {
            this.setValues = this.decodeValue(values);
        }
    }

    private PromptValue decodeValue(Object values) {
        if (values instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)values);
            values = calendar;
        }
        if (values instanceof RangePromptValue) {
            return (RangePromptValue)values;
        }
        if (values instanceof Range) {
            return new RangePromptValue((Range)values, this.type);
        }
        return new SinglePromptValue(values, this.getDescription(), this.type);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    private String getIconName() {
        switch (this.type) {
            case 6: {
                return "col_n.gif";
            }
            case 7: {
                return "col_cur.gif";
            }
            case 8: {
                return "col_b.gif";
            }
            case 9: {
                return "col_d.gif";
            }
            case 10: {
                return "col_t.gif";
            }
            case 15: {
                return "col_dt.gif";
            }
            case 11: {
                return "col_s.gif";
            }
            case 14: {
                return "col_bin.gif";
            }
        }
        return "col_unknown.gif";
    }

    public Object getChosenValue() {
        PromptValue promptValue = this.getPromptValueObject();
        if (promptValue == null) {
            return null;
        }
        return promptValue.getSQLTypedValue();
    }

    public Vector getDefaultValues() {
        Vector<Object> vector = new Vector<Object>();
        for (PromptValue promptValue : this.getDefaultValuesField()) {
            if (promptValue != null) {
                vector.add(promptValue.getSQLTypedValue());
                continue;
            }
            vector.add(promptValue);
        }
        return vector;
    }

    private static boolean stringArraysEqual(String[] s1, String[] s2) {
        if (s1 == null) {
            s1 = new String[]{};
        }
        if (s2 == null) {
            s2 = new String[]{};
        }
        if (s1.length != s2.length) {
            return false;
        }
        for (int i2 = 0; i2 < s1.length; ++i2) {
            if (s1[i2].equals(s2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PromptData)) {
            return false;
        }
        PromptData promptData = (PromptData)obj;
        return !(promptData.isChangeable() != this.isChangeable() || promptData.descOnly != this.descOnly || promptData.isDiscrete != this.isDiscrete || promptData.isRange != this.isRange || promptData.multipleAllowed != this.multipleAllowed || promptData.skipThisPrompt != this.skipThisPrompt || !PromptData.stringArraysEqual(this.defaultDescs, promptData.defaultDescs) || !this.getDefaultValuesField().equals(promptData.getDefaultValuesField()) || promptData.getDescription() != this.getDescription() && !promptData.getDescription().equals(this.getDescription()) || promptData.getEditMask() != this.getEditMask() && !promptData.getEditMask().equals(this.getEditMask()) || promptData.maxValue != this.maxValue && !promptData.maxValue.equals(this.maxValue) || promptData.minValue != this.minValue && !promptData.minValue.equals(this.minValue) || promptData.name != this.name && !promptData.name.equals(this.name) || promptData.type != this.type);
    }

    public int hashCode() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getDefaultValuesField() != null) {
            object = this.getDefaultValuesField().iterator();
            while (object.hasNext()) {
                String string = object.next().toString();
                stringBuffer.append(string);
            }
        }
        object = new StringBuffer();
        if (this.defaultDescs != null) {
            for (int i2 = 0; i2 < this.defaultDescs.length; ++i2) {
                String string = this.defaultDescs[i2];
                ((StringBuffer)object).append(string);
            }
        }
        String string = this.name + this.type + String.valueOf(this.minValue) + String.valueOf(this.maxValue) + this.getEditMask() + this.getDescription() + stringBuffer.toString() + ((StringBuffer)object).toString() + this.multipleAllowed + this.skipThisPrompt + this.isRange + this.isDiscrete + this.descOnly + this.isChangeable();
        return string.hashCode();
    }

    boolean withinLimits(PromptValue value) {
        if (value instanceof RangePromptValue) {
            return this.withinLimits(((RangePromptValue)value).getStartValue()) && this.withinLimits(((RangePromptValue)value).getEndValue());
        }
        if (value instanceof MultiPromptValue && value.getValue() != null) {
            boolean bl2 = true;
            Vector vector = (Vector)value.getValue();
            Iterator iterator = vector.iterator();
            while (bl2 && iterator.hasNext()) {
                PromptValue promptValue = (PromptValue)iterator.next();
                bl2 = bl2 && this.withinLimits(promptValue);
            }
            return bl2;
        }
        if (value == null || value.getValue() == null) {
            if (this.multipleAllowed) {
                return true;
            }
            return this.minValue == null && this.maxValue == null;
        }
        switch (this.type) {
            case 6: 
            case 7: {
                double d2 = ((Number)value.getValue()).doubleValue();
                double d3 = this.minValue != null ? ((Number)this.minValue.getValue()).doubleValue() : Double.NEGATIVE_INFINITY;
                double d4 = this.maxValue != null ? ((Number)this.maxValue.getValue()).doubleValue() : Double.POSITIVE_INFINITY;
                return d3 <= d2 && d2 <= d4;
            }
            case 9: 
            case 15: {
                Calendar calendar = (Calendar)value.getValue();
                Calendar calendar2 = null;
                if (this.minValue != null) {
                    calendar2 = (Calendar)this.minValue.getValue();
                }
                Calendar calendar3 = null;
                if (this.maxValue != null) {
                    calendar3 = (Calendar)this.maxValue.getValue();
                }
                return !(calendar2 != null && !calendar2.before(calendar) && !calendar2.equals(calendar) || calendar3 != null && !calendar3.after(calendar) && !calendar3.equals(calendar));
            }
            case 10: {
                Time time = (Time)value.getValue();
                Time time2 = null;
                if (this.minValue != null) {
                    time2 = (Time)this.minValue.getValue();
                }
                Time time3 = null;
                if (this.maxValue != null) {
                    time3 = (Time)this.maxValue.getValue();
                }
                return !(time2 != null && !time2.before(time) && !time2.equals(time) || time3 != null && !time3.after(time) && !time3.equals(time));
            }
            case 8: 
            case 14: {
                return true;
            }
            case 11: {
                String string = (String)value.getValue();
                double d5 = this.minValue != null ? Double.parseDouble((String)this.minValue.getValue()) : Double.NEGATIVE_INFINITY;
                double d6 = this.maxValue != null ? Double.parseDouble((String)this.maxValue.getValue()) : Double.POSITIVE_INFINITY;
                return d5 <= (double)string.length() && (double)string.length() <= d6;
            }
        }
        return true;
    }

    String getRangeExplanationMsg() {
        if (this.type == 11) {
            String string = PromptValue.getValueString(this.minValue);
            String string2 = PromptValue.getValueString(this.maxValue);
            try {
                string = String.valueOf(PromptValue.NUMBERFORMAT_ENGLISH.parse(string).intValue());
                string2 = String.valueOf(PromptValue.NUMBERFORMAT_ENGLISH.parse(string2).intValue());
            }
            catch (ParseException parseException) {
                ViewerUtils.printStackTrace(parseException);
            }
            return "\n" + a.getMsg("prompt.minString") + ": " + string + "\n" + a.getMsg("prompt.maxString") + ": " + string2;
        }
        return "\n" + a.getMsg("min") + ": " + PromptValue.getValueString(this.minValue) + "  " + a.getMsg("max") + ": " + PromptValue.getValueString(this.maxValue);
    }

    public String getCascadingParent() {
        return this.cascadingParent;
    }

    public void setCascadingParent(String cascadingParent) {
        if (cascadingParent != null) {
            this.skipThisPrompt = false;
        }
        this.cascadingParent = cascadingParent;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    void setEditMask(String editMask) {
        this.editMask = editMask;
    }

    String getEditMask() {
        return this.editMask;
    }

    void setDefaultValuesField(Vector defaultValues) {
        this.defaultValues = defaultValues;
    }

    Vector getDefaultValuesField() {
        return this.defaultValues;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void setChangeable(boolean changeable) {
        this.changeable = changeable;
    }

    boolean isChangeable() {
        return this.changeable;
    }

    PromptValue createFromURLPropertyValue(String value) {
        if (value.trim().startsWith(PREFIX_FORMULA)) {
            value = value.trim().substring(PREFIX_FORMULA.length());
        }
        if (value.trim().equals("[]")) {
            return new MultiPromptValue(new Vector(), null, this.type);
        }
        if (value.trim().startsWith("[")) {
            return this.extractMultiPromptValueFromString(value);
        }
        try {
            return this.extractValueFromString(value, null);
        }
        catch (Exception exception) {
            ViewerUtils.debug("setting prompt value " + value + " caused a problem:");
            exception.printStackTrace(ViewerUtils.getLogStream());
            ViewerUtils.debug("...defaulting to no set value.");
            return null;
        }
    }

    private MultiPromptValue extractMultiPromptValueFromString(String value) {
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        Vector<PromptValue> vector = new Vector<PromptValue>();
        StringTokenizer stringTokenizer = new StringTokenizer(value, "[],'\"()", true);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            stringBuffer.append(string);
            if (!bl2 && !bl3) {
                if (string.equals("\"")) {
                    bl2 = true;
                    continue;
                }
                if (string.equals("'")) {
                    bl3 = true;
                    continue;
                }
                if (string.equals("(")) {
                    bl4 = true;
                    continue;
                }
                if (!bl4) {
                    if (string.equals("]") || string.equals(",")) {
                        vector.add(this.extractValueFromString(stringBuffer.substring(0, stringBuffer.length() - 1), null));
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                } else {
                    if (!string.equals(")")) continue;
                    bl4 = false;
                    continue;
                }
            }
            if (bl2 && string.equals("\"")) {
                bl2 = false;
                continue;
            }
            if (!bl3 || !string.equals("'")) continue;
            bl3 = false;
        }
        return new MultiPromptValue(vector, null, this.type);
    }
}

