/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.by;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.KeyNotFoundException;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.renderer.java.e;
import com.inet.report.svg.SVGUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.viewer.RenderData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.archive.search.SearchHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

@PublicApi
public class CacheRenderData
implements RenderData {
    private final Cache hi;
    private final Properties hj = new Properties();
    private final PropertiesChecker hk;
    private final Object hl;
    private Properties hm = new Properties();
    private String hn;
    private String url;
    private ReportCacheKey ho;
    private int hp = 1;
    private boolean hq;

    public CacheRenderData(String url, PropertiesChecker checker, Object req) {
        this.hi = Cache.getCache();
        this.setReportLocation(url);
        this.hk = checker;
        this.hl = req;
    }

    public CacheRenderData(Properties props, PropertiesChecker checker, Object req) {
        this.hi = Cache.getCache();
        this.hj.putAll((Map<?, ?>)props);
        this.hk = checker;
        this.hl = req;
    }

    @Override
    public void setReportTitle(String title) {
        this.hn = title;
    }

    @Override
    public String getReportTitle() {
        return this.hn;
    }

    @Override
    public void setReportLocation(String name) {
        this.hj.clear();
        by.b(name, this.hj, false);
        try {
            ReportKeyFactory.decodeProps(this.hj);
        }
        catch (Throwable throwable) {
            BaseUtils.error("cannot decode props " + String.valueOf(throwable));
        }
        this.url = name;
    }

    @Override
    public String getReportLocation() {
        return this.url;
    }

    private void al() throws ViewerException {
        this.hj.put("export_fmt", "java");
        try {
            this.ho = this.getKey(this.hj);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
    }

    protected ReportCacheKey getKey(Properties props) throws ReportException {
        return this.hi.getKey(props, this.hk, this.getEngineFactory(), this.hl);
    }

    @Override
    public byte[] getPageData(int page) throws ViewerException {
        this.al();
        try {
            return this.hi.getPageAndWait(this.ho, page, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public int getPageCount() throws ViewerException {
        this.al();
        try {
            return this.hi.getPageCountAndWait(this.ho, 600000);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public boolean isPageLimitExceeded() {
        this.al();
        try {
            return this.hi.isPageLimitExceeded(this.ho);
        }
        catch (Exception exception) {
            throw new ViewerException("problem with getting page count", exception);
        }
    }

    @Override
    public byte[] getNextExportChunk() throws ViewerException {
        try {
            String string = this.hm.getProperty("export_fmt");
            if (string.equals("svg")) {
                if (this.hp == 0) {
                    ++this.hp;
                    String string2 = this.hm.getProperty("file");
                    string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.lastIndexOf("."));
                    int n2 = SVGUtils.getAutoRefresh(this.hm);
                    return SVGUtils.getSvgViewerPackage(-1, true, string2, n2);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, this.hp + ".svg", this.hi.getPageAndWait(this.ho, this.hp++, 600000));
                return byteArrayOutputStream.toByteArray();
            }
            if (this.hp >= 0) {
                return this.hi.getPageAndWait(this.ho, this.hp++, 600000);
            }
            ++this.hp;
            if (string.startsWith("htm")) {
                String string3 = this.hm.getProperty("file");
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                RenderDataUtils.writeFileData(byteArrayOutputStream, string3, RenderDataUtils.getHtmlViewerData());
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            BaseUtils.error("Chunk " + this.hp + " out of range...");
            BaseUtils.printStackTrace(pageOutOfRangeException);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            BaseUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
        }
        catch (IOException iOException) {
            BaseUtils.printStackTrace(iOException);
        }
        return null;
    }

    @Override
    public int getExportChunkCount(Properties expProps) throws ViewerException {
        this.hm = by.a(this.hj, expProps);
        try {
            this.ho = this.getKey(this.hm);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        try {
            int n2;
            String string = expProps.getProperty("export_fmt");
            if (string.equals("svg")) {
                this.hp = 0;
                n2 = this.hi.getPageCountAndWait(this.ho, 600000) + 1;
            } else if (string.startsWith("htm")) {
                this.hp = -1;
                n2 = this.hi.getPageCountAndWait(this.ho, 600000) + 2;
            } else {
                this.hp = 1;
                n2 = this.hi.getPageCountAndWait(this.ho, 600000);
            }
            Throwable throwable = this.hi.getFailureCause(this.ho);
            if (throwable != null) {
                throw ViewerException.createViewerException(throwable);
            }
            return n2;
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return -1;
    }

    protected EngineFactory getEngineFactory() {
        return Cache.getEngineFactory();
    }

    @Override
    public byte[] getGroupTree() throws ViewerException {
        this.al();
        try {
            return this.hi.getGroupTreeAndWait(this.ho, -1, 3, 600000);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            ViewerUtils.printStackTrace(keyNotFoundException);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
        }
        return null;
    }

    @Override
    public byte[] refreshPageData(int page) throws ViewerException {
        if (this.hq) {
            this.hj.put("promptonrefresh", "1");
        }
        return this.getPageData(page);
    }

    @Override
    public void setReportProperty(String key, String value) {
        if (value == null) {
            this.hj.remove(key);
        } else {
            this.hj.setProperty(key, value);
        }
    }

    @Override
    public String getReportProperty(String propertyKey) {
        return this.hj.getProperty(propertyKey);
    }

    @Override
    public Properties getProperties() {
        return this.hj;
    }

    @Override
    public void setPromptOnRefresh(boolean promptOnRefresh) {
        this.hq = promptOnRefresh;
    }

    @Override
    public boolean isPromptOnRefresh() {
        return this.hq;
    }

    @Override
    public RenderData getCopy() {
        return new CacheRenderData(this.url, this.hk, this.hl);
    }

    @Override
    public void stop() {
    }

    @Override
    public byte[] search(String phrase, int startPage, int flags) {
        try {
            return new SearchHandler(this).search(phrase, startPage, flags);
        }
        catch (ViewerException viewerException) {
            return e.getErrorData(viewerException, this.hj);
        }
    }

    @Override
    public byte[] getFontData(int fontID) {
        try {
            return this.hi.getPageAndWait(this.ho, -fontID, 600000);
        }
        catch (PageOutOfRangeException pageOutOfRangeException) {
            return null;
        }
        catch (ReportException reportException) {
            throw ViewerException.createViewerException(reportException);
        }
    }

    @Override
    public void resetServerCacheTimeout() {
        Properties properties = (Properties)this.hj.clone();
        try {
            this.ho = this.hi.createKey(properties, this.hk, this.hl);
        }
        catch (ReportException reportException) {
            ViewerUtils.printStackTrace(reportException);
            throw new ViewerException("Problem while creating key... ", reportException);
        }
        if (!this.hi.exists(this.ho)) {
            throw new ViewerException("report is no longer in the cache. You should not see this error.");
        }
        this.hi.resetCacheTimeout(this.ho);
    }
}

