/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.Encryption;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;

@InternalApi
public class ReportKeyUtils {
    private static final Comparator<Object> bxV = new a();
    private static final HashSet<String> bxW = new HashSet(25);

    public static boolean isNotInKeys(String property) {
        return bxW.contains(property);
    }

    public static String getRelevantParams(Properties props, boolean useForKey, boolean useForRedirect) {
        GUID gUID;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[props.size()];
        int n2 = 0;
        for (String string : props.stringPropertyNames()) {
            if (bxW.contains(string) && !useForRedirect) continue;
            stringArray[n2++] = string;
        }
        if (useForKey) {
            Arrays.sort(stringArray, 0, n2, bxV);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            string = stringArray[i2];
            String string2 = props.getProperty(string, "");
            if ("password".equalsIgnoreCase(string)) {
                string2 = Encryption.decrypt((String)string2);
                String string3 = string2 = useForKey ? ReportKeyUtils.dV(string2) : Encryption.encrypt((String)string2);
            }
            if (i2 != 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(useForKey ? string : EncodingFunctions.encodeUrlParameter((String)string));
            stringBuilder.append("=");
            stringBuilder.append(EncodingFunctions.encodeUrlParameter((String)string2));
        }
        if (useForKey && (gUID = UserManager.getInstance().getCurrentUserAccountID()) != null) {
            stringBuilder.append("&");
            stringBuilder.append(gUID.toString());
        }
        return stringBuilder.toString();
    }

    public static void addAllowedKeyParameter(String parameter, boolean allowed) {
        if (allowed) {
            bxW.remove(parameter);
        } else {
            bxW.add(parameter);
        }
    }

    private static String dV(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = new char[string.length()];
        int n2 = 69;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            n2 = (char)(n2 ^ c2);
        }
        return new String(cArray);
    }

    static {
        bxW.add("context");
        bxW.add("grouptree");
        bxW.add("cmd");
        bxW.add("init");
        bxW.add("vgen");
        bxW.add("locale");
        bxW.add("vfmt");
        bxW.add("page");
        bxW.add("viewer");
        bxW.add("pversion");
        bxW.add("promptonrefresh");
        bxW.add("incomplete_page");
        bxW.add("incomplete_page_count");
        bxW.add("ttl_info");
        bxW.add("content");
        bxW.add("http_server");
        bxW.add("http_server_port");
        bxW.add("http_server_base");
        bxW.add("application_context");
        bxW.add("selectprompt");
        bxW.add("http_method");
        bxW.add("http_url");
        bxW.add("cookie");
        bxW.add("getscheduleinprocessreport");
        bxW.add("PropertyChecker");
        bxW.add("disposition");
        bxW.add("filename");
    }

    static class a
    implements Comparator<Object> {
        a() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.hashCode() < o2.hashCode()) {
                return 1;
            }
            if (o1.hashCode() == o2.hashCode()) {
                return 0;
            }
            return -1;
        }
    }
}

