/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.chart.f;
import java.io.Serializable;
import org.w3c.dom.Element;

@PublicApi
public class NumberRange
implements Serializable {
    private Double Xo;
    private Double Xp;
    private boolean vz;

    public NumberRange() {
        this.vz = true;
    }

    public NumberRange(double lower, double upper) {
        if (lower > upper) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.vz = false;
        this.Xo = new Double(lower);
        this.Xp = new Double(upper);
    }

    public boolean isAutoRange() {
        return this.vz;
    }

    public void setAutoRange(boolean autoRange) {
        this.vz = autoRange;
    }

    public Double getLowerBound() {
        if (this.Xo == null) {
            return null;
        }
        return this.Xo;
    }

    public void setLowerBound(Double lower) {
        if (this.Xp != null && lower > this.Xp) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.Xo = lower;
    }

    public Double getUpperBound() {
        if (this.Xp == null) {
            return null;
        }
        return this.Xp;
    }

    public void setUpperBound(Double upper) {
        if (this.Xo != null && upper < this.Xo) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.Xp = upper;
    }

    boolean mV() {
        return this.getUpperBound() != null && this.getLowerBound() != null;
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeNumber");
            buffer.append(' ');
            if (this.Xo != null) {
                f.b(buffer, "lowerBound", this.Xo.toString());
            }
            if (this.Xp != null) {
                f.b(buffer, "upperBound", this.Xp.toString());
            }
            buffer.append("/");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element) {
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            this.setLowerBound(new Double(string));
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            this.setUpperBound(new Double(string));
        }
    }
}

