/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.PairList;
import com.inet.report.BaseUtils;
import com.inet.report.Datasource;
import com.inet.report.DefaultValue;
import com.inet.report.DynamicValueProvider;
import com.inet.report.ReportException;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.rowsource.l;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.function.Function;
import org.w3c.dom.Node;

@PublicApi
public abstract class SQLValueProvider
implements DynamicValueProvider,
NodeParser {
    public static final int MAX_RECORDS = 1000;

    SQLValueProvider() {
    }

    @Override
    public void getDefaultValues(Function<DefaultValue, Boolean> func) {
        Datasource datasource = this.getDatasource();
        try (Connection connection = datasource.getConnection();){
            if (connection == null) {
                throw new IllegalStateException("Connection for datasource " + datasource.getDataSourceConfigurationName() + " could not be established");
            }
            String string = this.getSQL();
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("[DynamicPrompt] " + this.getClass().getName() + " is fetching the default values with the query: ");
            }
            int n2 = 0;
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = DatabaseUtils.executeQuery(statement, string, null);){
                String string2;
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n3 = resultSetMetaData.getColumnCount();
                if (n3 == 0 || n3 > 2) {
                    throw new IllegalStateException("Query for default values returned either 0 columns or more than 2");
                }
                int n4 = 1;
                int n5 = 2;
                if (n3 == 2) {
                    String string3 = resultSetMetaData.getColumnName(1);
                    string2 = resultSetMetaData.getColumnName(2);
                    if ("description".equalsIgnoreCase(string3) && "value".equalsIgnoreCase(string2)) {
                        n4 = 2;
                        n5 = 1;
                    }
                }
                int n6 = resultSetMetaData.getColumnType(n4);
                string2 = new PairList();
                String string4 = null;
                while (resultSet.next()) {
                    ++n2;
                    Object object = l.a(n6, resultSet, n4);
                    if (object != null && object.toString().length() > 10000) {
                        throw new IllegalStateException("Query for default values returned a value which was longer than 10000 characters");
                    }
                    if (n3 == 2 && (string4 = resultSet.getString(n5)) != null && string4.length() > 10000) {
                        throw new IllegalStateException("Query for default values returned a description which was longer than 10000 characters");
                    }
                    if (string2.contains(object, (Object)string4)) continue;
                    string2.add(object, (Object)string4);
                    DefaultValue defaultValue = new DefaultValue(object, string4);
                    if (func.apply(defaultValue).booleanValue()) continue;
                    break;
                }
            }
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("number of records from query: " + n2);
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
    }

    public abstract String getSQL() throws ReportException, SQLException;

    public abstract Datasource getDatasource();

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }
}

