/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigValues;
import com.inet.config.ConfigurationManager;
import com.inet.config.ConfigurationMigrator;
import com.inet.error.HasErrorCode;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogLevel;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.logging.StaticLogger;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.br;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.bn;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class BaseUtils {
    private static final String gA;
    private static Logger gB;
    private static final ConfigValue<String> gC;
    private static final String[] gD;
    public static final Class UTILS_CLASS;
    public static final int FILE_INVALID = 0;
    public static final int FILE_CRYSTAL_REPORTS = 1;
    public static final int FILE_CLEAR_REPORTS = 2;
    public static final int FILE_XML = 4;
    public static final int FILE_DIRECTORY = 5;
    private static a gE;
    private static final ConfigValues gF;

    public static String getVersion() {
        return gA;
    }

    static void a(a a2) {
        gE = a2;
    }

    public static boolean isParanoid() {
        return gB.isDebug();
    }

    public static boolean isDebug() {
        return gB.isDebug();
    }

    public static boolean isInfo() {
        return gB.isInfo();
    }

    public static boolean isWarning() {
        return gB.isWarning();
    }

    public static boolean isError() {
        return gB.isError();
    }

    public static void fatal(Object reason) {
        gB.fatal(reason);
    }

    public static void error(Object reason) {
        if (gE != null) {
            gE.error(reason);
        }
        gB.error(reason);
    }

    public static void warning(Object reason) {
        gB.warn(reason);
    }

    public static void info(Object reason) {
        gB.info(reason);
    }

    public static void debug(Object reason) {
        gB.debug(reason);
    }

    public static void paranoid(Object reason) {
        BaseUtils.debug(reason);
    }

    public static boolean canLog() {
        return LogManager.getLogStream() != null;
    }

    public static void status(Object s2) {
        gB.status(s2);
    }

    public static void printStackTrace(Throwable t2) {
        if (t2 instanceof HasErrorCode && ((HasErrorCode)t2).getErrorCode() < 0) {
            gB.warn((Object)t2);
        } else {
            if (gE != null) {
                gE.error(t2);
            }
            gB.error(t2);
        }
    }

    public static void setLogLevel(int level) {
        gB.setLogLevel(level);
    }

    public static PrintStream getLogStream() {
        return LogManager.getLogStream();
    }

    public static int getLogLevel() {
        return gB.getLogLevel();
    }

    public static void setLogStream(PrintStream stream) {
        LogManager.setLogStream((PrintStream)stream);
        try {
            ViewerUtils.setLogStream(stream);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            BaseUtils.warning(ReportExceptionFactory.createReportExceptionWithCause(noClassDefFoundError, ReportErrorCode.MissingViewer, new Object[0]));
        }
    }

    public static byte[] getBytes(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    public static byte[] getBytesUTF8(String string) {
        return bn.getBytesUTF8(string);
    }

    public static String getStringUTF8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String getStringUTF8(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String getIndent(int depth) {
        if (depth >= 0 && depth < gD.length) {
            return gD[depth];
        }
        return BaseUtils.f(depth);
    }

    private static String f(int n2) {
        n2 = Math.max(0, n2);
        char[] cArray = new char[n2 * 2];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    public static List<Object> getParams(String values, String separator) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (values == null) {
            return arrayList;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String[] stringArray = values.split("\"", -1);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (i2 % 2 == 0) {
                String string2;
                int n2;
                int n3 = string.length();
                int n4 = 0;
                char[] cArray = string.toCharArray();
                for (n2 = 0; n2 < n3 && cArray[n4 + n2] <= ','; ++n2) {
                }
                while (n2 < n3 && cArray[n4 + n3 - 1] <= ',') {
                    --n3;
                }
                String string3 = string2 = n2 > 0 || n3 < string.length() ? string.substring(n2, n3) : string;
                if (string2.isEmpty()) continue;
                arrayList2.addAll(Arrays.asList(string2.split(separator)));
                continue;
            }
            arrayList2.add(string);
        }
        for (String string : arrayList2) {
            string = string.trim();
            try {
                arrayList.add(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    arrayList.add(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException2) {
                    if (string.equalsIgnoreCase("true")) {
                        arrayList.add(Boolean.TRUE);
                        continue;
                    }
                    if (string.equalsIgnoreCase("false")) {
                        arrayList.add(Boolean.FALSE);
                        continue;
                    }
                    if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                        arrayList.add(string.substring(1, string.length() - 1));
                        continue;
                    }
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                        simpleDateFormat.setLenient(false);
                        Date date = simpleDateFormat.parse(string);
                        if (date != null) {
                            arrayList.add(date);
                            continue;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    public static String validateKeyStore(String keyStoreType, String keyStorePathOrUrl, String keyStorePassword, String keyNameSetInConfig, String keyPasswordSetInConfig) {
        Object object;
        Object object2 = null;
        KeyStore keyStore = null;
        if (keyStoreType == null || keyStoreType.trim().length() == 0) {
            object2 = "key store type not defined";
        } else if (keyStorePathOrUrl == null || keyStorePathOrUrl.trim().length() == 0) {
            object2 = "key store path not defined";
        } else if (keyStorePassword == null || keyStorePassword.trim().length() == 0) {
            object2 = "key store password not defined";
        } else {
            char[] cArray = keyStorePassword.toCharArray();
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
            }
            catch (KeyStoreException keyStoreException) {
                object2 = keyStoreException.getMessage();
            }
            if (keyStore != null) {
                try {
                    object = IOFunctions.getURLFromString((String)keyStorePathOrUrl).openStream();
                    try {
                        keyStore.load((InputStream)object, cArray);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    object2 = "file " + keyStorePathOrUrl + " not found";
                }
                catch (IOException iOException) {
                    String string = iOException.getMessage();
                    if (string == null) {
                        string = iOException.getClass().getSimpleName();
                    }
                    if (string.indexOf("password") == -1) {
                        String string2 = BaseUtils.c(keyStorePathOrUrl);
                        if (string2 != null) {
                            if (!string2.equalsIgnoreCase(keyStoreType)) {
                                object2 = "Incorrect keystore format. Please try to take " + string2 + " format";
                            } else if (keyStoreType.equalsIgnoreCase("PKCS12")) {
                                int n2 = string.indexOf(58);
                                if (n2 != -1 && n2 < string.length() - 1) {
                                    string = string.substring(0, n2);
                                }
                                object2 = "Keystore was tampered with, or password was incorrect: " + string;
                            } else {
                                object2 = string;
                            }
                        } else {
                            object2 = "Unknown format of key store";
                        }
                    } else {
                        object2 = string;
                    }
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    object2 = noSuchAlgorithmException.getMessage();
                }
                catch (CertificateException certificateException) {
                    object2 = certificateException.getMessage();
                }
            }
        }
        if (keyStore != null && object2 == null) {
            try {
                BaseUtils.getSignatureData(keyStore, keyStorePassword, keyNameSetInConfig, keyPasswordSetInConfig, keyStorePathOrUrl, keyStoreType, true);
            }
            catch (RuntimeException runtimeException) {
                object2 = runtimeException.getMessage();
            }
            catch (Throwable throwable) {
                int n3;
                object = throwable.getLocalizedMessage();
                if (keyStoreType.equalsIgnoreCase("PKCS12") && (n3 = ((String)object).indexOf(58)) != -1 && n3 < ((String)object).length() - 1) {
                    object = ((String)object).substring(0, n3);
                }
                object2 = "incorrect key password: " + (String)object;
            }
        }
        return object2;
    }

    @Nonnull
    public static br getSignatureData(@Nonnull KeyStore keystore, @Nonnull String keystorePassword, @Nullable String keyNameInConfig, @Nullable String keyPasswordInConfig, @Nonnull String keyStorePath, @Nonnull String keyStoreType, boolean isShortMessage) throws RuntimeException {
        PrivateKey privateKey = null;
        Certificate certificate = null;
        Certificate[] certificateArray = null;
        String string = keyNameInConfig;
        String string2 = keyPasswordInConfig;
        if (string2 == null || string2.length() == 0) {
            string2 = keystorePassword;
        }
        try {
            char[] cArray = string2.toCharArray();
            if (string != null && string.length() != 0) {
                privateKey = (PrivateKey)keystore.getKey(string, cArray);
            } else {
                Enumeration<String> enumeration = keystore.aliases();
                while (privateKey == null && enumeration.hasMoreElements()) {
                    string = enumeration.nextElement();
                    privateKey = (PrivateKey)keystore.getKey(string, cArray);
                }
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            if (keyPasswordInConfig != null && keyPasswordInConfig.length() != 0) {
                BaseUtils.a("Key error: key password may be wrong", unrecoverableKeyException, "Key password may be wrong", isShortMessage);
            }
            BaseUtils.a("Read key from " + keyStorePath + " failed:" + unrecoverableKeyException.getMessage(), unrecoverableKeyException, "Read key failed: " + unrecoverableKeyException.getMessage(), isShortMessage);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            BaseUtils.a("Getting private key from " + keyStorePath + " failed because the algorithm for this key is not available: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException, "Algorithm is not available: " + noSuchAlgorithmException.getMessage(), isShortMessage);
        }
        catch (KeyStoreException keyStoreException) {
            BaseUtils.a("Cannot access keys in " + keyStorePath + ": " + keyStoreException.getMessage(), keyStoreException, "Cannot access key " + keyStoreException.getMessage(), isShortMessage);
        }
        catch (Throwable throwable) {
            int n2;
            String string3 = throwable.getLocalizedMessage();
            if (keyStoreType.equalsIgnoreCase("PKCS12") && (n2 = string3.indexOf(58)) != -1 && n2 < string3.length() - 1) {
                string3 = string3.substring(0, n2);
            }
            throw new RuntimeException("Loading key error: " + string3, throwable);
        }
        if (privateKey == null) {
            if (keyNameInConfig != null && keyNameInConfig.length() != 0) {
                BaseUtils.a("Key error: key name may be wrong", null, "Key name may be wrong", isShortMessage);
            } else {
                BaseUtils.a("Key error: No key has been found in key store", null, "No key has been found", isShortMessage);
            }
        }
        try {
            certificate = keystore.getCertificate(string);
            certificateArray = keystore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            BaseUtils.a("Reading of certificate from " + keyStorePath + " failed: " + keyStoreException.getMessage(), keyStoreException, "Reading of certificate failed: " + keyStoreException.getMessage(), isShortMessage);
        }
        if (certificate == null) {
            BaseUtils.a("Certificate from " + keyStorePath + " is null", null, "certificate is not defined", isShortMessage);
        }
        if (certificateArray == null && BaseUtils.isDebug()) {
            BaseUtils.debug("Certificate chain not found");
        }
        return new br(privateKey, certificate, certificateArray);
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check it")
    private static String c(String string) {
        String string2 = null;
        try (InputStream inputStream = IOFunctions.getURLFromString((String)string).openStream();){
            byte[] byArray = new byte[4];
            inputStream.read(byArray);
            if (byArray[0] == 48 && byArray[1] == -126) {
                string2 = "PKCS12";
            } else if (byArray[0] == -2 && byArray[1] == -19 && byArray[2] == -2 && byArray[3] == -19) {
                string2 = "JKS";
            } else if (byArray[0] == -50 && byArray[1] == -50 && byArray[2] == -50 && byArray[3] == -50) {
                string2 = "JCEKS";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string2;
    }

    public static int checkSig(byte[] puffer) {
        if (puffer == null || puffer.length == 0) {
            return 0;
        }
        if (puffer.length >= 512 && puffer[0] == -48 && puffer[1] == -49 && puffer[2] == 17 && puffer[3] == -32 && puffer[4] == -95 && puffer[5] == -79 && puffer[6] == 26 && puffer[7] == -31) {
            return 1;
        }
        if (puffer.length > 2 && puffer[0] == 80 && puffer[1] == 75) {
            return 4;
        }
        int n2 = 0;
        while ((puffer[n2] & 0xFF) != 60) {
            if (++n2 < puffer.length) continue;
            return 0;
        }
        if (puffer.length > n2 + 60 && puffer[n2] == 60 && puffer[n2 + 1] == 63 && (puffer[n2 + 2] | 0x20) == 120 && (puffer[n2 + 3] | 0x20) == 109 && (puffer[n2 + 4] | 0x20) == 108) {
            n2 += 4;
            while (++n2 < puffer.length) {
                if (puffer[n2] != 60 || puffer[n2 + 1] == 38 || puffer[n2 + 1] == 63 || puffer[n2 + 1] == 37 || puffer[n2 + 1] == 33) continue;
                if (n2 + 6 < puffer.length) {
                    if (puffer[n2 + 1] == 105 && puffer[n2 + 2] == 110 && puffer[n2 + 3] == 101 && puffer[n2 + 4] == 116) {
                        return 2;
                    }
                    return 0;
                }
                return 0;
            }
        }
        return 0;
    }

    public static int checkSig(InputStream in) throws IOException {
        int n2;
        byte[] byArray = new byte[512];
        for (int i2 = 0; i2 < 512 && (n2 = in.read(byArray, i2, 512 - i2)) >= 0; i2 += n2) {
        }
        return BaseUtils.checkSig(byArray);
    }

    public static void debugMemory(String debugPoint) {
        if (BaseUtils.isParanoid()) {
            Runtime runtime = Runtime.getRuntime();
            long l2 = runtime.totalMemory();
            long l3 = runtime.freeMemory();
            long l4 = runtime.maxMemory();
            l2 = l2 / 1024L / 1024L;
            l3 = l3 / 1024L / 1024L;
            l4 = l4 / 1024L / 1024L;
            long l5 = l2 - l3;
            BaseUtils.paranoid("Memory at \"" + debugPoint + "\": max=" + l4 + " MB\ttotal=" + l2 + " MB\tfree=" + l3 + " MB\tused=" + l5 + " MB");
        }
    }

    private static void a(String string, @Nullable Exception exception, String string2, boolean bl2) {
        if (bl2) {
            throw new RuntimeException(string2);
        }
        throw new RuntimeException(string, exception);
    }

    static {
        String string;
        try {
            string = System.getProperty("test.versionOverride");
        }
        catch (Throwable throwable) {
            string = null;
        }
        if (string == null) {
            string = "25.10.219 (2025-10-22)";
        }
        gA = string;
        gB = new StaticLogger("Reporting"){

            protected void log(LogLevel level, String prefix, Object message) {
                if (message instanceof Throwable) {
                    ((Throwable)message).printStackTrace();
                } else if (level.getValue() <= 1) {
                    System.out.println(message);
                }
            }
        };
        gB = LogManager.getLogger((String)"Reporting");
        ConfigurationManager.getInstance().addConfigurationMigrator((ConfigurationMigrator)new com.inet.logging.impl.a());
        ForkJoinPool.commonPool().execute(() -> LoaderUtils.getUpdateableClassLoader());
        gC = new ConfigValue<String>(ConfigKey.LOG_LEVELS){

            protected void setValue(String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                ViewerUtils.setDebug(gB.getLogLevel() >= 4);
            }
        };
        gD = new String[]{BaseUtils.f(0), BaseUtils.f(1), BaseUtils.f(2), BaseUtils.f(3), BaseUtils.f(4), BaseUtils.f(5), BaseUtils.f(6), BaseUtils.f(7), BaseUtils.f(8), BaseUtils.f(9), BaseUtils.f(10)};
        UTILS_CLASS = BaseUtils.class;
        gF = new ConfigValues(new ConfigKey[]{ConfigKey.LOG_ENGINE, ConfigKey.LOG_DRIVER, ConfigKey.LOG_FILE}){

            protected void changed() {
                try {
                    ViewerUtils.setLogStream(LogManager.getLogStream());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    BaseUtils.warning(ReportExceptionFactory.createReportExceptionWithCause(noClassDefFoundError, ReportErrorCode.MissingViewer, new Object[0]));
                }
            }
        };
    }

    static interface a {
        public void error(Object var1);
    }
}

