/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.renderer.AbstractRenderer;
import com.inet.jfree.chart.renderer.GradientPainter;
import com.inet.jfree.chart.renderer.category.AreaRenderer;
import com.inet.jfree.chart.renderer.category.Face;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.jfree.ui.RectangleEdge;

public class StandardAreaPainter {
    private GradientPainter painter = new GradientPainter();

    public void paintArea(Graphics2D g2, AbstractRenderer renderer, int rowCount, int column, Shape[] areas, GeneralPath[] separators, RectangleEdge location, boolean drawOutline, boolean drawLastOutline) {
        for (int i = 0; i < rowCount; ++i) {
            Paint itemPaint = renderer.getItemPaint(i, column);
            if (!(itemPaint instanceof Color)) {
                throw new IllegalStateException("Item paint is not a color: " + String.valueOf(itemPaint));
            }
            Color color = (Color)itemPaint;
            boolean success = this.painter.paintColor(g2, color, areas[i]);
            if (!success) continue;
            this.painter.drawOutline(g2, renderer, i, column, separators[i], drawOutline);
        }
        if (drawLastOutline && drawOutline) {
            this.painter.drawOutline(g2, renderer, rowCount, column, separators[rowCount], true);
        }
    }

    public void paintSide(Graphics2D g2, AreaRenderer renderer, int row, int column, Shape shape, Paint itemPaint, RectangleEdge location, Face face) {
        if (!(itemPaint instanceof Color)) {
            throw new IllegalStateException("Item paint is not a color: " + String.valueOf(itemPaint));
        }
        Color itemColor = (Color)itemPaint;
        if (face != Face.Front) {
            itemColor = itemColor.darker();
        }
        g2.setPaint(itemColor);
        g2.fill(shape);
        if (renderer.isOutline()) {
            g2.setStroke(renderer.getItemOutlineStroke(row, column));
            g2.setPaint(renderer.getItemOutlinePaint(row, column));
            g2.draw(shape);
        }
    }
}

