/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.report.BaseUtils;
import com.inet.report.encode.AbstractDecoder;
import java.awt.image.BufferedImage;

public final class RawDecoder
extends AbstractDecoder {
    static final byte[] agl = "raw".getBytes();
    private int width;
    private int jk;
    private int vV;
    private byte agm;

    @Override
    public void setBuffer(byte[] buffer, int offset, int length) {
        super.setBuffer(buffer, offset, length);
        this.vV = offset;
    }

    @Override
    protected BufferedImage decodeImage(int w2, int h2) {
        BufferedImage bufferedImage = null;
        byte[] byArray = new byte[]{this.buffer[this.pV()], this.buffer[this.pV()], this.buffer[this.pV()]};
        if (byArray[0] != agl[0] || byArray[1] != agl[1] || byArray[2] != agl[2]) {
            BaseUtils.info("wrong image type: " + (char)byArray[0] + (char)byArray[1] + (char)byArray[2]);
        }
        this.agm = this.buffer[this.pV()];
        this.width = this.readInt();
        this.jk = this.readInt();
        int[] nArray = new int[this.width * this.jk];
        switch (this.agm) {
            case 32: {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray[i2] = this.pW();
                }
                bufferedImage = new BufferedImage(this.width, this.jk, 2);
                bufferedImage.setRGB(0, 0, this.width, this.jk, nArray, 0, this.width);
                break;
            }
            default: {
                BaseUtils.info("Invalid raw bpp: " + this.agm);
                return null;
            }
        }
        return bufferedImage;
    }

    private int pV() {
        return this.vV++;
    }

    private int readInt() {
        return ((this.buffer[this.pV()] & 0xFF) << 24) + ((this.buffer[this.pV()] & 0xFF) << 16) + ((this.buffer[this.pV()] & 0xFF) << 8) + (this.buffer[this.pV()] & 0xFF);
    }

    private int pW() {
        int n2 = this.buffer[this.pV()] & 0xFF;
        int n3 = this.buffer[this.pV()] & 0xFF;
        int n4 = this.buffer[this.pV()] & 0xFF;
        int n5 = this.buffer[this.pV()] & 0xFF;
        return (n2 << 24) + (n5 << 16) + (n4 << 8) + n3;
    }
}

