clearreportsApp.service('reportExportDialog', function ($rootScope, modalservice, locationservice) {
   
    let $this = this;
    
    /**
     * Opens the export options dialog.
     * 
     * exportOptions:
     * {
     *     exportHandlerKey: <String> // key of the service method that is called when export starts. needs to be able to handle json and post multipart/form request,
     *     reportDataProvider: <function> // provider to get the report data to be exported,
     *     format: <String> // e.g. htm, pdf, png, ...
     *     formatDisplayName: <String> // e.g. PDF, HTML-File, ...
     *     filename: <String> // optional file name EXCLUDING the file extension for the export
     *     fileFilters: [<String>] // optional array of file filters, e.g. ['*.jpg', '*.jpeg'],
     *     asyncWithProgress: <boolean> // true if the export is an asynchronous job which supports requesting the status. false if the data will be retrieved instantly,
     *     availableFileChooserProtocols: List<String> // ['file', 'drive', ...] protocols to allow opening a filechooser
     * }
     */
    this.showExportDialog = function(exportOptions) {
        modalservice.showModal({
            exportOptions: exportOptions,
            reportExportDialog: true,
            template: 'weblib/report.exportdialog.html',
            title: $rootScope.getMsg('reportexportdialog.title'),
            titleaddition: '(' + exportOptions.formatDisplayName + ')',
            close: function() {
                locationservice.removePath('reportexport');
            }
        });
    };
    
    /**
     * Closes the current export dialog
     */
    this.closeExportDialog = function() {
        if (modalservice.activemodal != undefined) {
            if (modalservice.activemodal.reportExportDialog) {
                if (typeof modalservice.activemodal.close == 'function') {
                    modalservice.activemodal.close();
                }
            }
        }
    };
    
    /**
     * Registers the "reportexport" location action.
     * 
     * @param optionsResolver: function that gets the format key as paramter, to return the options object with e.g. format display name
     */
    this.registerExportLocationAction = function(optionsResolver) {
        locationservice.registerLocationAction('reportexport', 1, function(format){
            $this.showExportDialog(optionsResolver(format));
        }, function(format) {
            $this.closeExportDialog();
        });
    };
    
});
