/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.viewer.PromptData;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.bp;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.zip.Adler32;

public class ac
implements bp,
Runnable {
    protected byte[] data;
    protected int offset;
    protected int tokenSize;
    protected int oldOffset;

    protected void readTokens() {
        this.offset = 0;
        if (this.data == null || this.data.length < 4 || this.data[this.offset++] != 26 || this.data[this.offset++] != 88 || this.data[this.offset++] != 77 || this.data[this.offset++] != 76) {
            if (this.data == null) {
                this.data = new byte[0];
            }
            Object object = ac.f(this.data, 0, Math.min(this.data.length, 200));
            if (this.data.length > 200) {
                object = (String)object + "\n................";
            } else if (this.data.length == 0) {
                object = "<no data received>";
            }
            throw new ViewerException(0, a.getMsg("error.data_received"), null, null, null, null, 0, (String)object);
        }
        int n2 = this.read4ByteInt();
        if (n2 != this.data.length) {
            throw new ViewerException(0, "The length of the data is different with the received data", null, null, null, null, 0, "Header length:" + n2 + "\nPaket length:" + this.data.length);
        }
        this.offset = this.data.length - 4;
        int n3 = this.read4ByteInt();
        Adler32 adler32 = new Adler32();
        adler32.update(this.data, 0, this.data.length - 4);
        int n4 = (int)adler32.getValue();
        if (n3 != n4) {
            throw new ViewerException(0, "There was an error in the data transmission: checksums differ.", null, null, null, null, 0, "expected: " + n3 + ", got: " + n4);
        }
        this.offset = 8;
        int n5 = this.data.length - 4;
        while (this.offset < n5) {
            int n6 = this.readInt();
            this.tokenSize = this.readInt();
            this.oldOffset = this.offset;
            if (!this.load(n6)) {
                return;
            }
            this.offset = this.oldOffset + this.tokenSize;
        }
    }

    protected boolean load(int token) {
        switch (token) {
            case 0: {
                String string = this.readString();
                ViewerUtils.logServerVersion(string);
                String string2 = this.readString();
                ViewerUtils.setVersionInfo(string2, string);
                try {
                    double d2 = Double.valueOf(string2);
                    ViewerUtils.dd(d2 > 2.1);
                }
                catch (NumberFormatException numberFormatException) {
                    ViewerUtils.printStackTrace(numberFormatException);
                }
                break;
            }
            case 1: {
                ViewerException viewerException = this.readError();
                if (viewerException == null) break;
                throw viewerException;
            }
            case 80: {
                PromptData[] promptDataArray = this.readPrompts();
                if (promptDataArray == null) break;
                throw new ViewerException(promptDataArray);
            }
        }
        return true;
    }

    protected final PromptData[] readPrompts() {
        int n2 = this.readInt();
        if (n2 == 0) {
            return null;
        }
        PromptData[] promptDataArray = new PromptData[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = this.readInt() == 1;
            if (bl2) {
                promptDataArray[i2] = new PromptData(this.readString(), this.readString(), this.readString(), this.readStringArray(), this.readStringArray(), this.readInt(), this.readInt() == 1, this.readInt() == 1, this.readInt() == 1, this.readInt() == 1, this.readInt() == 1, this.readInt() == 1, this.readString(), this.readString(), this.readString());
                promptDataArray[i2].setCascadingParent(this.readString());
                promptDataArray[i2].setDisplayName(this.readString());
                continue;
            }
            promptDataArray[i2] = new PromptData(true);
        }
        return promptDataArray;
    }

    protected ViewerException readError() {
        String string;
        int n2 = this.read4ByteInt();
        String string2 = this.readString();
        String string3 = this.readString();
        String string4 = this.readString();
        String string5 = this.readString();
        String string6 = this.readString();
        int n3 = this.readInt();
        String string7 = this.readString();
        String string8 = string = this.offset < this.oldOffset + this.tokenSize ? this.readString() : null;
        if (n2 >= 0) {
            return new ViewerException(n2, string2, string3, string4, string5, string6, n3, string7, string);
        }
        return null;
    }

    protected final String[] readStringArray() {
        String[] stringArray = new String[this.readInt()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.readString();
        }
        return stringArray;
    }

    protected final float[] readFloatArray() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = this.readFloat();
        }
        return fArray;
    }

    protected final int readInt() {
        int n2;
        int n3;
        if ((n3 = this.data[this.offset++] & 0xFF) == 0) {
            return -1;
        }
        int n4 = 128;
        for (n2 = 1; n2 < 8 && (n3 & n4) != n4; n4 >>= 1, ++n2) {
        }
        if (n2 > 4) {
            n2 -= 4;
            n3 ^= n4;
            n3 -= n4;
        } else {
            n3 ^= n4;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            n3 = n3 << 8 | this.data[this.offset++] & 0xFF;
        }
        return n3;
    }

    protected final boolean readBoolean() {
        return this.readInt() != 0;
    }

    protected final int read4ByteInt() {
        return (this.data[this.offset++] << 24) + ((this.data[this.offset++] & 0xFF) << 16) + ((this.data[this.offset++] & 0xFF) << 8) + (this.data[this.offset++] & 0xFF);
    }

    protected final float readFloat() {
        return Float.intBitsToFloat(this.read4ByteInt());
    }

    protected final long read8ByteLong() {
        return (long)this.read4ByteInt() << 32 | (long)this.read4ByteInt() & 0xFFFFFFFFL;
    }

    protected final double readDouble() {
        return Double.longBitsToDouble(this.read8ByteLong());
    }

    protected String readString() {
        int n2 = this.readInt();
        if (n2 < 0) {
            return null;
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)((this.data[this.offset++] & 0xFF) << 8 | this.data[this.offset++] & 0xFF);
        }
        return new String(cArray);
    }

    protected int readTwip() {
        return this.readInt();
    }

    protected Polygon readPolygon() {
        int n2 = this.readInt();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.readTwip();
            nArray2[i2] = this.readTwip();
        }
        return new Polygon(nArray, nArray2, n2);
    }

    protected Shape readShape() {
        GeneralPath generalPath = new GeneralPath(this.readInt());
        while (true) {
            int n2 = this.readInt();
            switch (n2) {
                case -1: {
                    return generalPath;
                }
                case 0: {
                    generalPath.moveTo(this.readFloat(), this.readFloat());
                    break;
                }
                case 1: {
                    generalPath.lineTo(this.readFloat(), this.readFloat());
                    break;
                }
                case 2: {
                    generalPath.quadTo(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
                    break;
                }
                case 3: {
                    generalPath.curveTo(this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat(), this.readFloat());
                    break;
                }
                case 4: {
                    generalPath.closePath();
                }
            }
        }
    }

    protected GradientPaint readGradientPaint() {
        return new GradientPaint(this.readFloat(), this.readFloat(), new Color(this.read4ByteInt(), true), this.readFloat(), this.readFloat(), new Color(this.read4ByteInt(), true), this.readBoolean());
    }

    protected byte[] readByteArray() {
        int n2 = this.readInt();
        if (n2 < 1 || n2 > this.data.length - this.offset) {
            ViewerUtils.printStackTrace(new Exception("Invalid byte array size: " + n2 + ". Amount of available bytes: " + (this.data.length - this.offset)));
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, this.offset, byArray, 0, n2);
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += byArray[i2];
        }
        return byArray;
    }

    protected AffineTransform readTransform() {
        return new AffineTransform(this.readDouble(), this.readDouble(), this.readDouble(), this.readDouble(), this.readDouble(), this.readDouble());
    }

    static String f(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n3);
        byte[] byArray2 = (byte[])byArray.clone();
        n3 += n2;
        for (int i2 = n2; i2 < n3; i2 += 16) {
            stringBuffer.append(ac.b((byte)(i2 >> 8))).append(ac.b((byte)i2)).append("  ");
            ac.a(byArray2, i2, n3 - i2 > 16 ? 16 : n3 - i2, stringBuffer);
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    static void a(byte[] byArray, int n2, int n3, StringBuffer stringBuffer) {
        int n4;
        for (n4 = n2; n4 < n2 + n3; ++n4) {
            stringBuffer.append(ac.b(byArray[n4])).append(' ');
            if (byArray[n4] >= 32) continue;
            byArray[n4] = 46;
        }
        while (n4 < n2 + 16) {
            stringBuffer.append("   ");
            ++n4;
        }
        stringBuffer.append(' ');
        stringBuffer.append(new String(byArray, n2, n3));
        stringBuffer.append('\n');
    }

    static String b(byte by2) {
        int n2 = (by2 & 0xF0) / 16;
        Object object = n2 < 10 ? String.valueOf(n2) : "" + (char)(55 + n2);
        n2 = by2 & 0xF;
        object = n2 < 10 ? (String)object + String.valueOf(n2) : (String)object + (char)(55 + n2);
        return object;
    }

    @Override
    public void run() {
    }

    protected final double getProtocolVersion() {
        return Double.valueOf(ViewerUtils.getProtocolVersion());
    }
}

