/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.webapi.reporting;

import com.inet.http.ClientMessageException;
import com.inet.http.PluginServlet;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.report.servlets.ReportPluginServlet;
import com.inet.report.webapi.ReportingWebAPIExtension;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Reporting", description="Report rendering operations")
public class c
extends RequestHandler<Void, Void> {
    public c() {
        super(new String[]{"render"});
    }

    public String getHelpPageKey() {
        return "webapi.reporting.report.render";
    }

    @Operation(summary="Render report", description="Renders a report file with the specified parameters. Can be used with GET parameters or JSON payload.", responses={@ApiResponse(responseCode="200", description="Report rendered successfully", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error rendering report")})
    @Parameters(value={@Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report"), @Parameter(description="A list of reports that should be rendered", in=ParameterIn.QUERY, name="reports")})
    public Void c(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl2) throws IOException {
        Optional<@Nonnull PluginServlet> optional = DynamicExtensionManager.getInstance().get(PluginServlet.class).stream().filter(pluginServlet -> pluginServlet.getClass().equals(ReportPluginServlet.class)).findFirst();
        if (!optional.isPresent()) {
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("reportservlet.notAvailable", new Object[0]));
        }
        String string = httpServletRequest.getParameter("report");
        String string2 = httpServletRequest.getParameter("reports");
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) {
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("webapi.reporting.parameterNotDefined", new Object[]{"report"}));
        }
        try {
            optional.get().service(httpServletRequest, httpServletResponse);
        }
        catch (ServletException | IOException throwable) {
            throw new ClientMessageException(throwable.getMessage());
        }
        return null;
    }

    @Operation(summary="Render report", description="Renders a report file with the specified parameters. Can be used with GET parameters or JSON payload.", responses={@ApiResponse(responseCode="200", description="Report rendered successfully", content={@Content(mediaType="application/pdf")}), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error rendering report")})
    @Parameters(value={@Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report"), @Parameter(description="A list of reports that should be rendered", in=ParameterIn.QUERY, name="reports")})
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl2) throws IOException {
        return this.c(httpServletRequest, httpServletResponse, (Void)object, bl2);
    }
}

