/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache.store;

import com.inet.annotations.PublicApi;
import com.inet.cache.StoreMap;
import com.inet.classloader.ObjectStreams;
import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.cache.PageOutOfRangeException;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.cache.store.a;
import com.inet.report.cache.store.b;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;

@PublicApi
public class CachedOutput
implements DocumentOutput,
Comparable<CachedOutput> {
    private final long Vs = System.currentTimeMillis();
    private final ReportCacheKey ho;
    private ReportGenerator Vt;
    private int Vp;
    private int Vu;
    private int Vv;
    private byte Vw;
    private boolean Vx;
    private boolean Vy;
    private long Vz;
    private String VA;

    public CachedOutput(ReportCacheKey key, ReportGenerator engine) {
        this.ho = key;
        this.Vt = engine;
    }

    @Override
    public int getPageCount() {
        return this.Vp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void aF(String string) {
        StoreMap<a, byte[]> storeMap = b.VE;
        synchronized (storeMap) {
            this.stop(string);
            this.mf();
        }
    }

    private void mf() {
        for (int i2 = -this.Vu; i2 <= this.Vp; ++i2) {
            b.VE.remove((Object)new a(this.ho, i2));
        }
        this.Vv = 0;
        this.Vp = 0;
        this.Vu = 0;
        this.Vt = null;
    }

    @Override
    public void clear() {
        this.mf();
        this.Vw = 0;
        this.VA = null;
    }

    @Override
    public byte[] getPageData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.VE.get((Object)new a(this.ho, idx));
        if (byArray == null) {
            this.F(idx, this.Vp);
        }
        return byArray;
    }

    private void F(int n2, int n3) {
        byte[] byArray;
        if (this.Vw == 3 && (byArray = (byte[])b.VE.get((Object)new a(this.ho, 1))) != null) {
            Throwable throwable = null;
            try {
                ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream((InputStream)new ByteArrayInputStream(byArray));
                throwable = (Throwable)cacheObjectInputStream.readObject();
                cacheObjectInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (throwable != null) {
                ErrorCode.throwAny(throwable);
            }
        }
        ErrorCode.throwAny((Throwable)new PageOutOfRangeException(n2, n3, this.VA));
    }

    @Override
    public byte[] getGroupTree() {
        return (byte[])b.VE.get((Object)new a(this.ho, 0));
    }

    @Override
    public void addPage(byte[] page) throws IllegalStateException {
        if (this.a("addPage()", this.Vp + 1, page, 0)) {
            ++this.Vp;
            if (BaseUtils.isDebug()) {
                BaseUtils.debug("addPage:" + this.Vp);
            }
        }
    }

    @Override
    public void setPageData(byte[] page, int idx) throws IllegalStateException {
        this.a("setPageData()", idx, page, 0);
    }

    @Override
    public void setGroupTree(byte[] data) throws IllegalStateException {
        this.a("setGroupTree()", 0, data, 2);
    }

    @Override
    public void setErrorData(byte[] error) throws IllegalStateException {
        this.a("setErrorData()", 1, error, 3);
        if (this.Vp == 0) {
            this.Vp = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(String cause) {
        StoreMap<a, byte[]> storeMap = b.VE;
        synchronized (storeMap) {
            this.VA = cause;
            this.Vw = 1;
            this.Vt = null;
            b.VE.notifyAll();
        }
    }

    @Override
    public void addFontData(byte[] fontData) throws IllegalStateException {
        if (this.a("addFontData()", -1 - this.Vu, fontData, 0)) {
            ++this.Vu;
        }
    }

    @Override
    public void setFontData(byte[] fontData, int idx) throws IllegalStateException {
        this.a("setFontData()", -1 - idx, fontData, 0);
    }

    @Override
    public byte[] getFontData(int idx) throws ArrayIndexOutOfBoundsException {
        byte[] byArray = (byte[])b.VE.get((Object)new a(this.ho, -1 - idx));
        if (byArray == null) {
            this.F(idx, this.Vu);
        }
        return byArray;
    }

    @Override
    public int getFontCount() {
        return this.Vu;
    }

    @Override
    public void setPageLimitExceeded() {
        this.Vx = true;
    }

    @Override
    public boolean isPageLimitExceeded() {
        return this.Vx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUsingTotalPage() {
        StoreMap<a, byte[]> storeMap = b.VE;
        synchronized (storeMap) {
            this.Vy = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, int n2, byte @Nonnull [] byArray, int n3) {
        Object object;
        a a2 = new a(this.ho, n2);
        StoreMap<a, byte[]> storeMap = b.VE;
        synchronized (storeMap) {
            switch (this.Vw) {
                case 1: {
                    object = ": Rendering stopped: " + this.VA;
                    break;
                }
                case 2: {
                    object = ": Rendering finished";
                    break;
                }
                case 3: {
                    object = ": Rendering error";
                    break;
                }
                default: {
                    if (n2 != 0) {
                        byte[] byArray2 = (byte[])b.VE.get((Object)a2);
                        this.Vv += byArray.length;
                        if (byArray2 != null) {
                            this.Vv -= byArray2.length;
                        }
                    }
                    b.VE.put((Object)a2, (Object)byArray);
                    this.Vw = (byte)n3;
                    if (n3 != 0) {
                        this.Vt = null;
                    }
                    b.VE.notifyAll();
                    return true;
                }
            }
        }
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("[Report Cache] Cache already closed: " + string + (String)object);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] G(int n2, int n3) throws ReportException, PageOutOfRangeException, IllegalArgumentException {
        if (n3 < 0) {
            throw new IllegalArgumentException("Illegal timeout value: " + n3);
        }
        a a2 = new a(this.ho, n2);
        long l2 = n3 == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)n3;
        int n4 = 5;
        long l3 = 0L;
        while (true) {
            StoreMap<a, byte[]> storeMap;
            StoreMap<a, byte[]> storeMap2 = storeMap = b.VE;
            synchronized (storeMap2) {
                long l4;
                if (!this.Vy || this.Vw != 0) {
                    byte[] byArray = (byte[])storeMap.get((Object)a2);
                    if (byArray != null) {
                        return byArray;
                    }
                    if (this.Vw != 0) {
                        if (this.Vw == 3 && n2 != 1 && (byArray = (byte[])storeMap.get((Object)new a(this.ho, 1))) != null) {
                            return byArray;
                        }
                        throw new PageOutOfRangeException(n2, this.Vp, this.VA);
                    }
                }
                if (l2 < (l4 = System.currentTimeMillis())) {
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.Timeout, this.ho);
                }
                long l5 = (l4 - this.Vs) / 1000L;
                if (BaseUtils.isDebug() && l5 - l3 > (long)n4) {
                    BaseUtils.debug("[Report Cache] Rendering worker is running or queued since " + l5 + " seconds. Waiting for available of chunk " + n2 + " of report: " + String.valueOf(this.ho));
                    l3 = l5;
                    ++n4;
                }
                try {
                    storeMap.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    ReportExceptionFactory.createReportExceptionWithCause(interruptedException);
                }
            }
        }
    }

    int mg() {
        return this.Vv;
    }

    int mh() {
        return this.Vw;
    }

    public ReportCacheKey getKey() {
        return this.ho;
    }

    public ReportGenerator getEngine() {
        return this.Vt;
    }

    void a(long l2) {
        this.Vz = l2;
    }

    @Override
    public int compareTo(CachedOutput o2) {
        return Long.compare(this.Vz, o2.Vz);
    }
}

