/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;

@PublicApi
public class SummaryInfo
implements Serializable {
    private String hn;
    private String Pa;
    private String Pb;
    private String Pc;
    private String Pd;
    private String Pe;
    private Date Pf;
    private Date Pg;
    private transient BufferedImage Ph;
    private byte[] Pi;

    SummaryInfo() {
    }

    public String getAuthor() {
        return this.Pa;
    }

    public void setAuthor(String author) {
        this.Pa = author;
    }

    public String getKeywords() {
        return this.Pb;
    }

    public void setKeywords(String keywords) {
        this.Pb = keywords;
    }

    public String getComments() {
        return this.Pe;
    }

    public void setComments(String comments) {
        this.Pe = comments;
    }

    public String getReportTitle() {
        return this.hn;
    }

    public void setReportTitle(String title) {
        this.hn = title;
    }

    public String getSubject() {
        return this.Pc;
    }

    public void setSubject(String subject) {
        this.Pc = subject;
    }

    public String getTemplate() {
        return this.Pd;
    }

    public void setTemplate(String template) {
        this.Pd = template;
    }

    public Date getCreated() {
        return this.Pg;
    }

    public void setCreated(Date createTime) {
        this.Pg = createTime;
    }

    public Date getLastSaved() {
        return this.Pf;
    }

    public void setLastSaved(Date lastSave) {
        this.Pf = lastSave;
    }

    public void setThumbnail(Image img) {
        this.Pi = null;
        if (img == null) {
            this.Ph = null;
            return;
        }
        int n2 = img.getWidth(null);
        int n3 = img.getHeight(null);
        int n4 = n2;
        int n5 = n3;
        if (n2 > n3) {
            var6_6 = (double)n2 / 256.0;
            n4 = 256;
            n5 = (int)((double)n5 / var6_6);
        } else {
            var6_6 = (double)n3 / 256.0;
            n5 = 256;
            n4 = (int)((double)n4 / var6_6);
        }
        img = img.getScaledInstance(n4, n5, 4);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(img, 0, 0, Color.WHITE, null);
        graphics.dispose();
        this.Ph = bufferedImage;
        this.getThumbnailData();
    }

    public Image getThumbnail() {
        if (this.Ph == null && this.Pi != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.Pi);
                this.Ph = ImageIO.read(byteArrayInputStream);
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
                this.Pi = null;
            }
        }
        return this.Ph;
    }

    public void setThumbnailData(byte[] data) {
        this.Ph = null;
        this.Pi = data;
    }

    public byte[] getThumbnailData() {
        if (this.Pi == null && this.Ph != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.Ph, "png", byteArrayOutputStream);
                this.Pi = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.Pi;
    }
}

