/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.xy;

import com.inet.jfree.data.DomainInfo;
import com.inet.jfree.data.Range;
import com.inet.jfree.data.RangeInfo;
import com.inet.jfree.data.xy.AbstractXYDataset;
import com.inet.jfree.data.xy.InetSeriesDataset;
import com.inet.jfree.data.xy.XYDataset;
import com.inet.jfree.data.xy.XYSeries;
import com.inet.jfree.data.xy.XYSeriesCollection;

public class ScatterXYDataset
extends AbstractXYDataset
implements InetSeriesDataset,
XYDataset,
DomainInfo,
RangeInfo {
    private XYSeriesCollection data = new XYSeriesCollection();
    private double rangeMin = Double.POSITIVE_INFINITY;
    private double rangeMax = Double.NEGATIVE_INFINITY;

    @Override
    public void addSeries(XYSeries series) {
        this.data.addSeries(series);
        for (int index = 0; index < series.getItemCount(); ++index) {
            Number yValue = series.getY(index);
            if (yValue == null) continue;
            double y = yValue.doubleValue();
            if (y < this.rangeMin) {
                this.rangeMin = y;
            }
            if (!(y > this.rangeMax)) continue;
            this.rangeMax = y;
        }
    }

    @Override
    public void removeSeries(int series) {
        this.data.removeSeries(series);
    }

    @Override
    public int getSeriesCount() {
        return this.data.getSeriesCount();
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.data.getSeriesKey(series);
    }

    @Override
    public int getItemCount(int series) {
        return this.data.getItemCount(series);
    }

    @Override
    public Number getX(int series, int item) {
        return this.data.getX(series, item);
    }

    @Override
    public Number getY(int series, int item) {
        return this.data.getY(series, item);
    }

    @Override
    public Range getDomainBounds(boolean includeInterval) {
        return this.data.getDomainBounds(includeInterval);
    }

    @Override
    public double getDomainLowerBound(boolean includeInterval) {
        return this.data.getDomainLowerBound(includeInterval);
    }

    @Override
    public double getDomainUpperBound(boolean includeInterval) {
        return this.data.getDomainUpperBound(includeInterval);
    }

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        return new Range(this.rangeMin, this.rangeMax);
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        return this.rangeMin;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        return this.rangeMax;
    }
}

