/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.report.DefaultValue;
import com.inet.report.FormulaRange;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;

public class PromptUtils {
    private PromptUtils() {
    }

    public static String[] defaultPromptValues(Object[] values, int dataType) {
        if (values == null) {
            return new String[0];
        }
        String[] stringArray = new String[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            stringArray[i2] = PromptUtils.parsePrompt(values[i2], dataType, true);
        }
        return stringArray;
    }

    public static String setDefaultPrompt(Object value, int dataType) {
        value = "";
        switch (dataType % 128) {
            case 6: 
            case 7: {
                value = new Double(0.0);
                break;
            }
            case 8: {
                value = Boolean.TRUE;
                break;
            }
            case 9: {
                value = new java.sql.Date(System.currentTimeMillis());
                break;
            }
            case 15: {
                value = new Time(System.currentTimeMillis());
                break;
            }
            case 10: {
                value = new Timestamp(System.currentTimeMillis());
                break;
            }
            case 11: {
                value = new String("");
            }
        }
        return PromptUtils.parsePrompt(value, dataType);
    }

    public static String parsePrompt(Object p2, int dataType) {
        return PromptUtils.parsePrompt(p2, dataType, false);
    }

    public static String parsePrompt(Object p2, int dataType, boolean array) {
        if (p2 instanceof DefaultValue) {
            return PromptUtils.parsePrompt(((DefaultValue)p2).getValue(), dataType);
        }
        if (p2 instanceof Date) {
            Object object = "";
            switch (dataType % 128) {
                case 9: 
                case 265: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy, MM, dd");
                    object = "Date(" + simpleDateFormat.format(p2) + ")";
                    break;
                }
                case 10: 
                case 266: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("H, m, s");
                    object = "Time(" + simpleDateFormat.format(p2) + ")";
                    break;
                }
                case 15: 
                case 271: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy, MM, dd, H, m, s");
                    object = "DateTime(" + simpleDateFormat.format(p2) + ")";
                }
            }
            return object;
        }
        if (p2 instanceof Object[]) {
            Object[] objectArray = (Object[])p2;
            StringBuilder stringBuilder = new StringBuilder("[");
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                if (i2 != 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(PromptUtils.parsePrompt(object, dataType, true));
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (p2 instanceof String) {
            String string = (String)p2;
            string = string.replace("'", "''");
            return "'" + string + "'";
        }
        if (p2 instanceof FormulaRange) {
            FormulaRange formulaRange = (FormulaRange)p2;
            if (formulaRange.getFrom() == null) {
                String string = " upto" + (formulaRange.isHighLimitIncluded() ? " " : "_ ");
                string = string + PromptUtils.parsePrompt(formulaRange.getTo(), dataType % 128, array || formulaRange.getTo() instanceof String);
                return string;
            }
            if (formulaRange.getTo() == null) {
                String string = " upfrom" + (formulaRange.isLowLimitIncluded() ? " " : "_ ");
                string = string + PromptUtils.parsePrompt(formulaRange.getFrom(), dataType % 128, array || formulaRange.getFrom() instanceof String);
                return string;
            }
            String string = (formulaRange.isLowLimitIncluded() ? " " : " _") + "to" + (formulaRange.isHighLimitIncluded() ? " " : "_ ");
            return PromptUtils.parsePrompt(formulaRange.getFrom(), dataType % 128, array || formulaRange.getFrom() instanceof String) + string + PromptUtils.parsePrompt(formulaRange.getTo(), dataType % 128, array || formulaRange.getTo() instanceof String);
        }
        if (p2 instanceof byte[]) {
            byte[] byArray = (byte[])p2;
            return Base64.getMimeEncoder().encodeToString(byArray);
        }
        return String.valueOf(p2);
    }

    public static String defaultPrompt(Object value, int dataType) {
        if (value != null) {
            return PromptUtils.parsePrompt(value, dataType);
        }
        return PromptUtils.setDefaultPrompt(value, dataType);
    }

    public static final boolean isArray(int type) {
        if (type < 0) {
            return false;
        }
        return (type & 0x100) > 0;
    }

    public static final boolean isRange(int type) {
        if (type < 0) {
            return false;
        }
        return (type & 0x80) > 0;
    }

    public static boolean checkValueType(Object value, int valueType) {
        if (value == null) {
            return true;
        }
        if (value instanceof FormulaRange) {
            return PromptUtils.checkValueType(((FormulaRange)value).getFrom(), valueType) && PromptUtils.checkValueType(((FormulaRange)value).getTo(), valueType);
        }
        switch (valueType) {
            case 11: {
                if (value instanceof String) break;
                return false;
            }
            case 6: 
            case 7: {
                if (value instanceof Number) break;
                return false;
            }
            case 9: 
            case 10: 
            case 15: {
                if (value instanceof Date) break;
                return false;
            }
            case 8: {
                if (value instanceof Boolean) break;
                return false;
            }
        }
        return true;
    }
}

