/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.permissions;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.permissions.SystemPermissionManager;
import com.inet.permissions.url.FilePermissions;
import com.inet.permissions.url.PluginPermissionChecker;
import com.inet.permissions.url.URLPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.plugins.ReportingServerPlugin;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class PermissionChecker {
    public static final Permission PERMISSION_EXECUTE_ALL_REPORTS;
    private static PermissionChecker awA;
    private static final ConfigValue<Boolean> awB;
    private static final ConfigValue<Boolean> awC;
    private static final List<PluginPermissionChecker> awD;

    private PermissionChecker() {
    }

    public static PermissionChecker getInstance() {
        return awA;
    }

    public static void checkReportLocation(URL url) throws AccessDeniedException {
        PermissionChecker.getInstance().checkReportLocationPermission(url);
    }

    public void checkReportLocationPermission(URL url) throws AccessDeniedException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount != null && userAccount.getAccountType() == UserAccountType.Administrator) {
            return;
        }
        URLPermissionChecker.checkReportLocation((URL)url);
    }

    public static void checkExecuteRight(URL url) throws AccessDeniedException {
        PermissionChecker.getInstance().checkExecutePermission(url);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="file used for checkings")
    public void checkExecutePermission(URL url) throws AccessDeniedException {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount != null && userAccount.getAccountType() == UserAccountType.Administrator) {
            return;
        }
        String string = url.toString();
        if ("file:".equals(string)) {
            return;
        }
        PermissionChecker.checkReportLocation(url);
        if (!((Boolean)awB.get()).booleanValue()) {
            return;
        }
        Object object = awD.iterator();
        while (object.hasNext()) {
            PluginPermissionChecker pluginPermissionChecker = object.next();
            if (!pluginPermissionChecker.checkExecutePermission(url)) continue;
            return;
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Checking global permissions...");
        }
        if (SystemPermissionChecker.checkAccess((Permission)PERMISSION_EXECUTE_ALL_REPORTS) && (((String)(object = string.toLowerCase())).endsWith(".rpt") || ((String)object).endsWith(".dataview"))) {
            return;
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Checking folder permissions...");
        }
        object = null;
        try {
            object = FilePermissions.getPermission((URL)url);
        }
        catch (Exception exception) {
            BaseUtils.printStackTrace(exception);
        }
        if (object != null && object.checkAccess(1)) {
            return;
        }
        if (BaseUtils.isParanoid()) {
            BaseUtils.paranoid("Access denied!");
        }
        throw new AccessDeniedException((ErrorCode)(userAccount == null ? BaseErrorCode.UserNotLoggedIn : BaseErrorCode.AccessDeniedOrFileNotExists), new Object[]{url});
    }

    public static void checkAccessPermission(URL url, URL reportURL) throws ReportException {
        if (url != null && "data".equals(url.getProtocol())) {
            return;
        }
        PermissionChecker.checkReportLocation(url);
        if (((Boolean)awC.get()).booleanValue() && "file".equals(url.getProtocol())) {
            if (reportURL != null && "file".equals(reportURL.getProtocol())) {
                String string = reportURL.toString();
                string = string.substring(0, string.lastIndexOf(47) + 1).toLowerCase();
                String string2 = url.toString().toLowerCase();
                if (!string2.startsWith(string)) {
                    throw new AccessDeniedException((ErrorCode)BaseErrorCode.IllegalPath, new Object[]{url});
                }
            } else {
                throw new AccessDeniedException((ErrorCode)BaseErrorCode.IllegalPath, new Object[]{url});
            }
        }
    }

    static {
        Permission.createCategory((String)"reports", (int)5000, (String)"com.inet.report.plugins.structure.i18n.ConfigStructure", PermissionChecker.class);
        PERMISSION_EXECUTE_ALL_REPORTS = SystemPermissionManager.add((String)"reporting", (String)"reports", null, (int)5200, (boolean)false, ReportingServerPlugin.class);
        awA = new PermissionChecker();
        awB = new ConfigValue(ConfigKey.SYSTEMPERMISSION_ENABLED);
        awC = new ConfigValue(ConfigKey.REPOSITORY_ENABLED);
        awD = ServerPluginManager.getInstance().get(PluginPermissionChecker.class);
    }
}

