/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.ae;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.a;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.i18n.ReportErrorCode;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@PublicApi
public abstract class JdbcData
extends BaseDataFactory {
    @Override
    @Nonnull
    public TableData getTableSourceData(TableSource ts) throws ReportException {
        try {
            return new TableData(ts.getResultSet());
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
    }

    @Override
    public boolean getReportDataPerInstance() {
        return true;
    }

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource ds, String catalog) throws ReportException {
        HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
        try {
            Object object;
            String string;
            String string2;
            String string3;
            ResultSet resultSet = this.getTables(ds, catalog);
            boolean bl2 = resultSet.next();
            if (!bl2) {
                resultSet.close();
                resultSet = this.getTables(ds, null);
                bl2 = resultSet.next();
            }
            if (bl2) {
                do {
                    int n2;
                    string3 = resultSet.getString(1);
                    string2 = resultSet.getString(2);
                    string = resultSet.getString(3);
                    object = resultSet.getString(4);
                    if ("VIEW".equals(object)) {
                        n2 = 10;
                    } else if ("TABLE".equals(object)) {
                        n2 = 0;
                    } else {
                        if (!"SYSTEM TABLE".equals(object)) continue;
                        n2 = 1;
                    }
                    TableSourceInfo tableSourceInfo = new TableSourceInfo(string3, string2, string, n2);
                    hashMap.put(tableSourceInfo.getName(), tableSourceInfo);
                } while (resultSet.next());
            }
            resultSet.close();
            try {
                resultSet = this.getProcedures(ds, catalog);
                while (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    object = new TableSourceInfo(string3, string2 = resultSet.getString(2), string = resultSet.getString(3), 20);
                    if (hashMap.get(((TableSourceInfo)object).getName()) != null) continue;
                    hashMap.put(((TableSourceInfo)object).getName(), (TableSourceInfo)object);
                }
                resultSet.close();
            }
            catch (Exception exception) {
                BaseUtils.info("procedures not supported by this datasource: " + String.valueOf(exception));
            }
        }
        catch (SQLException sQLException) {
            throw ReportExceptionFactory.createReportExceptionWithCause(sQLException);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<ColumnInfo> getColumns(TableSource ts) throws ReportException {
        block36: {
            var3_2 = ts.getDatasource().getConnection();
            try {
                var4_4 = var3_2.getMetaData().getDriverMajorVersion();
                var5_6 = ts.getType();
                switch (var5_6) {
                    case 1: 
                    case 3: {
                        var2_8 = new ArrayList<E>();
                        if (var5_6 == 3) {
                            var6_9 = ts.getSqlWithPromptFieldValues();
                            var6_9 = DatabaseTables.changeWhereToNoRows((String)var6_9);
                        } else {
                            var7_10 = this.getSourceNameWithChange(ts, this.getConfiguration().isUseEscapeEverything());
                            var6_9 = "SELECT * FROM " + (String)var7_10 + " WHERE 1=0";
                        }
                        var7_10 = var3_2.createStatement();
                        try {
                            try {
                                var7_10.setMaxRows(1);
                            }
                            catch (SQLException var8_12) {
                                if (!BaseUtils.isDebug()) ** GOTO lbl23
                                BaseUtils.debug(var8_12);
                            }
lbl23:
                            // 3 sources

                            var8_13 = DatabaseUtils.executeQuery((Statement)var7_10, (String)var6_9, null);
                            try {
                                this.a(var8_13, var2_8, var4_4, ts);
                                break;
                            }
                            finally {
                                if (var8_13 != null) {
                                    var8_13.close();
                                }
                            }
                        }
                        finally {
                            if (var7_10 != null) {
                                var7_10.close();
                            }
                        }
                    }
                    case 2: {
                        var7_11 = new a(this, var3_2, ts);
                        try {
                            var7_11.b(ae.y(ae.d(ts)));
                            var7_11.cG(1);
                            var2_8 = var7_11.mN();
                            try {
                                var8_15 = var7_11.mR();
                                this.a(var8_15, var2_8, var4_4, ts);
                                break;
                            }
                            catch (ReportException var8_16) {
                                if (var8_16.getErrorCode() != ReportErrorCode.UnknownPrompt.getErrorCodeNumber()) {
                                    throw var8_16;
                                }
                                break;
                            }
                        }
                        finally {
                            var7_11.close();
                        }
                    }
                    default: {
                        throw new IllegalStateException("Not supported source type: " + var5_6);
                    }
                }
                var6_9 = var2_8;
                if (var3_2 == null) break block36;
            }
            catch (Throwable var4_5) {
                try {
                    if (var3_2 != null) {
                        try {
                            var3_2.close();
                        }
                        catch (Throwable var5_7) {
                            var4_5.addSuppressed(var5_7);
                        }
                    }
                    throw var4_5;
                }
                catch (SQLException var3_3) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(var3_3);
                }
            }
            var3_2.close();
        }
        return var6_9;
    }

    @Override
    public boolean supportsCommands() {
        return true;
    }

    private void a(ResultSet resultSet, List<ColumnInfo> list, int n2, TableSource tableSource) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i2 = 1; i2 <= n3; ++i2) {
            String string = resultSetMetaData.getColumnName(i2);
            String string2 = resultSetMetaData.getColumnLabel(i2);
            string = this.getColumnName(string, string2, n2, tableSource, i2 - 1);
            int n4 = DatabaseTables.mapSqlTypeToCCType(resultSetMetaData.getColumnType(i2));
            list.add(new ColumnInfo(string, n4));
        }
    }

    protected abstract ResultSet getTables(Datasource var1, String var2) throws SQLException, ReportException;

    protected abstract ResultSet getProcedures(Datasource var1, String var2) throws SQLException, ReportException;

    protected abstract ResultSet getProcedureColumns(Datasource var1, String var2, String var3, String var4) throws SQLException, ReportException;

    protected String getColumnName(String colName, String alias, int driverVersion, TableSource ts, int colIdx) {
        return colName;
    }

    protected abstract String getSourceNameWithChange(TableSource var1, boolean var2);

    @Override
    public abstract SqlSyntax getSqlSyntax();

    @Nonnull
    protected String patchSQL(@Nonnull String sql) {
        return sql;
    }
}

