/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.plot;

import com.inet.annotations.PublicApi;
import com.inet.jfree.chart.labels.BubbleXYItemLabelGenerator;
import com.inet.jfree.chart.labels.StandardXYItemLabelGenerator;
import com.inet.jfree.chart.labels.XYItemLabelGenerator;
import com.inet.report.Chart2;
import com.inet.report.chart.a;
import com.inet.report.chart.axis.ContinuousNumberAxis;
import com.inet.report.chart.dataset.LabelProvider;
import com.inet.report.chart.dataset.XYDataset;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.XYStyle;
import com.inet.report.i;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class XYPlot
extends AbstractPlot {
    public static final XYStyle DEFAULT_STYLE = XYStyle.SCATTER;
    public static final double DEFAULT_SIZE_COEFFICIENT = 0.3;
    private XYStyle ZU;
    private XYDataset ZV;
    private ContinuousNumberAxis ZW;
    private ContinuousNumberAxis ZT;
    private double ZX;

    public XYPlot() {
        this(DEFAULT_STYLE);
    }

    public XYPlot(XYStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZU = style;
        this.setCategoryAxis(new ContinuousNumberAxis());
        this.setDataAxis(new ContinuousNumberAxis());
        this.ZX = 0.3;
    }

    @Override
    public XYDataset getDataset() {
        return this.ZV;
    }

    public void setDataset(XYDataset dataset) {
        if (dataset == null) {
            throw i.d("dataset");
        }
        this.ZV = dataset;
        this.ZV.updateReferences();
    }

    public ContinuousNumberAxis getCategoryAxis() {
        return this.ZW;
    }

    public void setCategoryAxis(ContinuousNumberAxis categoryAxis) {
        if (categoryAxis == null) {
            throw i.d("categoryAxis");
        }
        this.ZW = categoryAxis;
    }

    public ContinuousNumberAxis getDataAxis() {
        return this.ZT;
    }

    public void setDataAxis(ContinuousNumberAxis dataAxis) {
        if (dataAxis == null) {
            throw i.d("dataAxis");
        }
        this.ZT = dataAxis;
    }

    @Override
    public ChartStyle getStyle() {
        return this.ZU;
    }

    public void setStyle(XYStyle style) {
        if (style == null) {
            throw i.d("style");
        }
        this.ZU = style;
    }

    public double getSizeCoefficient() {
        return this.ZX;
    }

    public void setSizeCoefficient(double sizeCoefficient) {
        if (sizeCoefficient < 0.0 || sizeCoefficient > 1.0) {
            throw new IllegalArgumentException("Coefficient is out of range (0-1).");
        }
        this.ZX = sizeCoefficient;
    }

    @Override
    public void refreshAutoTitles(Chart2 chart) {
        if (this.ZV != null) {
            LabelProvider labelProvider = this.ZV.getLabelProvider();
            if (this.getStyle() == XYStyle.SCATTER) {
                a.setAutoTitle(chart.getHeaderTitle(), i.getMsg("ScatterChart", chart.getLocalizationResources()));
                a.setAutoTitle(chart.getFootnote(), labelProvider.getLabel(1));
            } else if (this.getStyle() == XYStyle.BUBBLE) {
                a.setAutoTitle(chart.getHeaderTitle(), i.getMsg("BubbleChart", chart.getLocalizationResources()));
                a.setAutoTitle(chart.getFootnote(), i.getMsg("BubbleSize", chart.getLocalizationResources()) + " " + labelProvider.getLabel(1));
            }
            a.setAutoTitle(this.getCategoryAxis().getTitle(), labelProvider.getLabel(2));
            a.setAutoTitle(this.getDataAxis().getTitle(), labelProvider.getLabel(4));
        }
    }

    XYItemLabelGenerator d(Locale locale) {
        StandardXYItemLabelGenerator standardXYItemLabelGenerator = null;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        ChartFormat chartFormat = this.getItemLabelFormat();
        if (chartFormat instanceof NumberFormat) {
            chartFormat.setFormatingProperties(new FormatingProperties(TimeZone.getDefault(), locale, -1));
            numberFormat = (NumberFormat)((Object)chartFormat);
        }
        if (this.getStyle().equals(XYStyle.SCATTER)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isShowLabel()) {
                stringBuilder.append("{0}");
                if (this.isShowValue()) {
                    stringBuilder.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuilder.append("({1}, {2})");
            }
            if (stringBuilder.length() > 0) {
                standardXYItemLabelGenerator = new StandardXYItemLabelGenerator(stringBuilder.toString(), numberFormat, numberFormat);
            }
        } else if (this.getStyle().equals(XYStyle.BUBBLE)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isShowLabel()) {
                stringBuilder.append("{0}");
                if (this.isShowValue()) {
                    stringBuilder.append("  ");
                }
            }
            if (this.isShowValue()) {
                stringBuilder.append("({1}, {2}, {3})");
            }
            if (stringBuilder.length() > 0) {
                standardXYItemLabelGenerator = new BubbleXYItemLabelGenerator(stringBuilder.toString(), numberFormat, numberFormat, numberFormat);
            }
        }
        return standardXYItemLabelGenerator;
    }

    @Override
    protected StringBuilder cl(int n2) {
        StringBuilder stringBuilder = super.cl(n2);
        f.b(stringBuilder, n2, "SizeCoefficient", String.valueOf(this.getSizeCoefficient()));
        return stringBuilder;
    }

    @Override
    protected void B(PrintWriter printWriter, int n2) {
        super.B(printWriter, n2);
        ++n2;
        if (this.ZV != null) {
            com.inet.report.chart.dataset.a.a(this.ZV, printWriter, n2);
        }
        this.ZW.saveProperties(printWriter, n2, "CategoryAxis");
        this.ZT.saveProperties(printWriter, n2, "DataAxis");
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("CategoryAxis")) {
                this.ZW.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("DataAxis")) {
                this.ZT.readProperties(element2, chart);
                continue;
            }
            if (element2.getNodeName().equals("SizeCoefficient")) {
                double d2;
                String string = element2.getAttribute("value");
                if (string.length() <= 0 || !((d2 = Double.valueOf(string).doubleValue()) >= 0.0) || !(d2 <= 1.0)) continue;
                this.setSizeCoefficient(d2);
                continue;
            }
            if (!element2.getNodeName().equals("Dataset")) continue;
            this.setDataset((XYDataset)com.inet.report.chart.dataset.a.b(element2, chart));
        }
    }

    @Override
    public List getReferencedObject() {
        List list = super.getReferencedObject();
        list.addAll(this.ZW.getReferencedObjects());
        list.addAll(this.ZT.getReferencedObjects());
        return list;
    }
}

