/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.format;

import com.inet.annotations.PublicApi;
import com.inet.report.chart.f;
import com.inet.report.chart.format.ChartFormat;
import com.inet.report.chart.format.FormatingProperties;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DateTimeFormat
extends DateFormat
implements ChartFormat {
    public static final String PATTERN_CONSTANT_FULL = "DateTimeFormat.PATTERN_FULL";
    public static final String PATTERN_CONSTANT_LONG = "DateTimeFormat.PATTERN_LONG";
    public static final String PATTERN_CONSTANT_MEDIUM = "DateTimeFormat.PATTERN_MEDIUM";
    public static final String PATTERN_CONSTANT_SHORT = "DateTimeFormat.PATTERN_SHORT";
    public static final String PATTERN_CONSTANT_DATE_D_MMMM_YYYY = "d. MMMM yyyy";
    public static final String PATTERN_CONSTANT_DATE_YYYY = "yyyy";
    public static final String PATTERN_CONSTANT_DATE_MMMM_YYYY = "MMMM yyyy";
    public static final String PATTERN_CONSTANT_DATE_MMM_YY = "MMM yy";
    public static final String PATTERN_CONSTANT_DATE_MMMM = "MMMM";
    public static final String PATTERN_CONSTANT_DATE_EEEE = "EEEE";
    public static final String PATTERN_CONSTANT_TIME_MM = "mm";
    public static final String PATTERN_CONSTANT_TIME_SS = "ss";
    private FormatingProperties Ya = new FormatingProperties();
    private SimpleDateFormat Yb;
    private String Yc = "DateTimeFormat.PATTERN_SHORT";
    private String Yd = "DateTimeFormat.PATTERN_SHORT";

    public String getDatePatternConstant() {
        return this.Yc;
    }

    public void setDatePatternConstant(String patternConstant) {
        this.Yc = patternConstant;
        this.Yb = null;
    }

    public String getTimePatternConstant() {
        return this.Yd;
    }

    public void setTimePatternConstant(String patternConstant) {
        this.Yd = patternConstant;
        this.Yb = null;
    }

    @Override
    public void setFormatingProperties(FormatingProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Parameter 'properties' is null.");
        }
        this.Ya = properties;
        this.Yb = null;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (this.Yb == null) {
            this.Yb = new SimpleDateFormat(this.getPattern(), this.Ya.getLocale());
        }
        return this.Yb.format(date, toAppendTo, fieldPosition);
    }

    private String getPattern() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = DateTimeFormat.aK(this.Yc);
        int n3 = DateTimeFormat.aK(this.Yd);
        if (n2 != -1) {
            stringBuilder.append(((SimpleDateFormat)DateFormat.getDateInstance(n2, this.Ya.getLocale())).toPattern());
            if (n3 != -1 || this.Yd != null) {
                stringBuilder.append(' ');
            }
        } else if (this.Yc != null) {
            stringBuilder.append(this.Yc);
            if (n3 != -1 || this.Yd != null) {
                stringBuilder.append(' ');
            }
        }
        if (n3 != -1) {
            stringBuilder.append(((SimpleDateFormat)DateFormat.getTimeInstance(n3, this.Ya.getLocale())).toPattern());
        } else if (this.Yd != null) {
            stringBuilder.append(this.Yd);
        }
        return stringBuilder.toString();
    }

    private static int aK(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals(PATTERN_CONSTANT_FULL)) {
            return 0;
        }
        if (string.equals(PATTERN_CONSTANT_LONG)) {
            return 1;
        }
        if (string.equals(PATTERN_CONSTANT_MEDIUM)) {
            return 2;
        }
        if (string.equals(PATTERN_CONSTANT_SHORT)) {
            return 3;
        }
        return -1;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        throw new RuntimeException("Method not implemented.");
    }

    @Override
    public void saveProperties(StringBuilder buffer, int depth) {
        f.a(buffer, depth, "Format", "type", this.getName());
        if (this.getDatePatternConstant() != null) {
            f.b(buffer, depth + 1, "DatePatternConstant", this.getDatePatternConstant());
        }
        if (this.getTimePatternConstant() != null) {
            f.b(buffer, depth + 1, "TimePatternConstant", this.getTimePatternConstant());
        }
        f.a(buffer, depth, "Format", null, true);
    }

    @Override
    public void readProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        String string = null;
        String string2 = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            String string3;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("DatePatternConstant")) {
                string3 = element2.getAttribute("value");
                if (string3.length() <= 0) continue;
                string = string3;
                continue;
            }
            if (!element2.getNodeName().equals("TimePatternConstant") || (string3 = element2.getAttribute("value")).length() <= 0) continue;
            string2 = string3;
        }
        this.setDatePatternConstant(string);
        this.setTimePatternConstant(string2);
    }

    protected String getName() {
        return "DateTimeFormat";
    }

    @Override
    public DateTimeFormat clone() {
        DateTimeFormat dateTimeFormat = new DateTimeFormat();
        dateTimeFormat.Yc = this.Yc;
        dateTimeFormat.Yd = this.Yd;
        dateTimeFormat.Ya = (FormatingProperties)this.Ya.clone();
        return dateTimeFormat;
    }
}

