/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseTables;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.RendererBase;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.list.DatabaseFieldList;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.r;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public class Join
implements ReferenceHolder,
NodeParser,
Serializable {
    private TableSource tW = null;
    private TableSource tX = null;
    private DatabaseFieldList tY = new DatabaseFieldList(1);
    private DatabaseFieldList tZ = new DatabaseFieldList(1);
    private int[] ua = new int[0];
    private int ub = 21;
    private RendererBase bB = null;
    private r qh = new r(this);

    Join(RendererBase renderer, int type, String sourceAliasName, String targetAliasName) throws ReportException {
        this(renderer, type, renderer.getDbTables().getTablesource(sourceAliasName), renderer.getDbTables().getTablesource(targetAliasName));
    }

    Join(RendererBase renderer, int type, TableSource sourceTableSource, TableSource targetTableSource) throws ReportException {
        this.tY.setAllowDuplicatedEntries(true);
        this.tZ.setAllowDuplicatedEntries(true);
        if (sourceTableSource.getDatasource().getEngine() != renderer.getEngine()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.TSFromOtherReport, sourceTableSource);
        }
        if (targetTableSource.getDatasource().getEngine() != renderer.getEngine()) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.TSFromOtherReport, targetTableSource);
        }
        this.setJoinType(type);
        this.tW = sourceTableSource;
        this.tX = targetTableSource;
        this.bB = renderer;
    }

    public int getJoinType() {
        return this.ub;
    }

    public void setJoinType(int newJoinType) {
        if (newJoinType < 20) {
            switch (newJoinType) {
                case 3: {
                    newJoinType = 21;
                    this.am(1);
                    break;
                }
                case 7: {
                    newJoinType = 21;
                    this.am(2);
                    break;
                }
                case 9: {
                    newJoinType = 21;
                    this.am(3);
                    break;
                }
                case 4: {
                    newJoinType = 23;
                    this.am(1);
                    break;
                }
                case 5: {
                    newJoinType = 22;
                    this.am(1);
                    break;
                }
                case 8: {
                    newJoinType = 21;
                    this.am(4);
                    break;
                }
                case 10: {
                    newJoinType = 21;
                    this.am(5);
                    break;
                }
                case 11: {
                    newJoinType = 21;
                    this.am(6);
                }
            }
        }
        this.ub = newJoinType;
    }

    private void am(int n2) {
        for (int i2 = 0; this.ua != null && i2 < this.ua.length; ++i2) {
            this.ua[i2] = n2;
        }
    }

    public String getSourceAlias() {
        return this.tW.getAlias();
    }

    public TableSource getSourceTableSource() {
        return this.tW;
    }

    public String getTargetAlias() {
        return this.tX.getAlias();
    }

    public TableSource getTargetTableSource() {
        return this.tX;
    }

    public void addCondition(String sourceColumn, String targetColumn, int linkType) {
        DatabaseField databaseField = this.tW.getDatabaseField(sourceColumn);
        DatabaseField databaseField2 = this.tX.getDatabaseField(targetColumn);
        if (databaseField == null) {
            throw new IllegalArgumentException("Could not find a DatabaseField for sourceColumn \"" + sourceColumn + "\"");
        }
        if (databaseField2 == null) {
            throw new IllegalArgumentException("Could not find a DatabaseField for targetColumn \"" + targetColumn + "\"");
        }
        this.addCondition(databaseField, databaseField2, linkType);
    }

    public void addCondition(DatabaseField sourceColumn, DatabaseField targetColumn, int linkType) {
        for (int i2 = 0; i2 < this.tY.size(); ++i2) {
            if (!this.tY.elementAt(i2).getShortName().equals(sourceColumn) || !this.tZ.elementAt(i2).getShortName().equals(targetColumn)) continue;
            return;
        }
        int[] nArray = new int[this.ua.length + 1];
        System.arraycopy(this.ua, 0, nArray, 0, this.ua.length);
        this.ua = nArray;
        this.ua[this.ua.length - 1] = linkType;
        if (targetColumn != null) {
            this.tZ.addElement(targetColumn);
            targetColumn.addReferenceHolder(this);
        }
        if (sourceColumn != null) {
            this.tY.addElement(sourceColumn);
            sourceColumn.addReferenceHolder(this);
        }
    }

    public void removeCondition(int i2) {
        if (i2 < 0 || i2 >= this.tY.size()) {
            throw new ArrayIndexOutOfBoundsException("" + i2);
        }
        DatabaseField databaseField = this.tZ.elementAt(i2);
        DatabaseField databaseField2 = this.tY.elementAt(i2);
        databaseField.removeReferenceHolder(this);
        databaseField2.removeReferenceHolder(this);
        this.tZ.removeElement(databaseField);
        this.tY.removeElement(databaseField2);
        int[] nArray = new int[this.ua.length - 1];
        System.arraycopy(this.ua, 0, nArray, 0, i2);
        System.arraycopy(this.ua, i2 + 1, nArray, i2, this.ua.length - i2 - 1);
        this.ua = nArray;
    }

    public int getConditionCount() {
        return this.tY.size();
    }

    public String getConditionSourceColumn(int i2) {
        return this.tY.elementAt(i2).getShortName();
    }

    public String getConditionTargetColumn(int i2) {
        return this.tZ.elementAt(i2).getShortName();
    }

    public int getConditionLinkType(int i2) {
        return this.ua[i2];
    }

    public String[] getConditionSourceColumns() {
        String[] stringArray = new String[this.tY.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.tY.elementAt(i2).getShortName();
        }
        return stringArray;
    }

    public DatabaseField[] getConditionSourceFields() {
        return this.tY.toArray();
    }

    public DatabaseField[] getConditionTargetFields() {
        return this.tZ.toArray();
    }

    public String[] getConditionTargetColumns() {
        String[] stringArray = new String[this.tZ.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.tZ.elementAt(i2).getShortName();
        }
        return stringArray;
    }

    public int[] getConditionLinkTypes() {
        int[] nArray = new int[this.ua.length];
        System.arraycopy(this.ua, 0, nArray, 0, this.ua.length);
        return nArray;
    }

    public String paramString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Join[");
        stringBuilder.append(this.ub);
        stringBuilder.append(',');
        stringBuilder.append(this.tW.getAlias());
        stringBuilder.append(',');
        stringBuilder.append(this.tX.getAlias());
        for (int i2 = 0; i2 < this.tY.size(); ++i2) {
            stringBuilder.append(',');
            stringBuilder.append(this.tY.elementAt(i2).getShortName());
            stringBuilder.append("->");
            stringBuilder.append(this.tZ.elementAt(i2).getShortName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public void swapJoin() {
        TableSource tableSource = this.tW;
        this.tW = this.tX;
        this.tX = tableSource;
        block12: for (int i2 = 0; i2 < this.tY.size(); ++i2) {
            DatabaseField databaseField = this.tY.elementAt(i2);
            this.tY.setElementAt(this.tZ.elementAt(i2), i2);
            this.tZ.setElementAt(databaseField, i2);
            switch (this.ua[i2]) {
                case 1: 
                case 6: {
                    continue block12;
                }
                case 3: {
                    this.ua[i2] = 5;
                    continue block12;
                }
                case 2: {
                    this.ua[i2] = 4;
                    continue block12;
                }
                case 5: {
                    this.ua[i2] = 3;
                    continue block12;
                }
                case 4: {
                    this.ua[i2] = 2;
                    continue block12;
                }
            }
        }
        switch (this.ub) {
            case 21: 
            case 24: {
                break;
            }
            case 23: {
                this.ub = 22;
                break;
            }
            case 22: {
                this.ub = 23;
                break;
            }
        }
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        if (a.valueOf(tag) == a.uc) {
            String string = atts.getValue("from");
            String string2 = atts.getValue("to");
            String string3 = atts.getValue("type");
            this.addCondition(string, string2, DatabaseTables.r(string3));
        }
        return null;
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public final void addReferencedObject(ReferencedObject reference) {
        this.qh.addReferencedObject(reference);
    }

    @Override
    public final void removeReferencedObject(ReferencedObject reference) {
        this.qh.removeReferencedObject(reference);
    }

    @Override
    public final int getRealReferencedObjectCount() {
        return this.qh.getRealReferencedObjectCount();
    }

    @Override
    public final int getReferencedObjectCount() {
        return this.qh.getRealReferencedObjectCount();
    }

    @Override
    public final ReferencedObject[] getReferencedObjects() {
        return this.qh.getReferencedObjects();
    }

    @Override
    public final void setReferences() {
        DatabaseField databaseField;
        int n2;
        if (this.bB == null || this.bB.getEngine() == null) {
            return;
        }
        for (n2 = 0; n2 < this.tZ.size(); ++n2) {
            databaseField = this.tZ.elementAt(n2);
            databaseField.addReferenceHolder(this);
        }
        for (n2 = 0; n2 < this.tY.size(); ++n2) {
            databaseField = this.tY.elementAt(n2);
            databaseField.addReferenceHolder(this);
        }
    }

    @Override
    public final void resetReferences() {
        this.qh.resetReferences();
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a uc = new a();
        private static final /* synthetic */ a[] ud;

        public static a[] values() {
            return (a[])ud.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] dy() {
            return new a[]{uc};
        }

        static {
            ud = a.dy();
        }
    }
}

